/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Statistics;

import arjuna.JavaSim.Statistics.Bucket;
import arjuna.JavaSim.Statistics.PrecisionHistogram;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class SimpleHistogram
extends PrecisionHistogram {
    private double minIndex;
    private double maxIndex;
    private double width;
    private long numberBuckets;

    public SimpleHistogram(double min, double max, long nbuckets) {
        if (min < max) {
            this.minIndex = min;
            this.maxIndex = max;
        } else {
            this.minIndex = max;
            this.maxIndex = min;
        }
        if (nbuckets > 0L) {
            this.numberBuckets = nbuckets;
        } else {
            nbuckets = 1L;
        }
        this.width = (max - min) / (double)this.numberBuckets;
    }

    public SimpleHistogram(double min, double max, double w) {
        if (min < max) {
            this.minIndex = min;
            this.maxIndex = max;
        } else {
            this.minIndex = max;
            this.maxIndex = min;
        }
        this.width = w > 0.0 ? w : 2.0;
        this.numberBuckets = (long)((max - min) / this.width);
        if ((max - min) / this.width - (double)this.numberBuckets > 0.0) {
            ++this.numberBuckets;
        }
    }

    public void setValue(double value) throws IllegalArgumentException {
        if (value < this.minIndex || value > this.maxIndex) {
            throw new IllegalArgumentException("Value " + value + " is beyond histogram range [ " + this.minIndex + ", " + this.maxIndex + " ]");
        }
        for (Bucket ptr = this.Head; ptr != null; ptr = ptr.cdr()) {
            double bucketValue = ptr.Name();
            if (value != bucketValue && !(value <= bucketValue + this.width)) continue;
            super.setValue(ptr.Name());
            return;
        }
        throw new IllegalArgumentException("Something went wrong with " + value);
    }

    public void reset() {
        double value = this.minIndex;
        super.reset();
        int i = 0;
        while ((long)i < this.numberBuckets) {
            super.create(value);
            value += this.width;
            ++i;
        }
    }

    public double sizeByName(double name) throws IllegalArgumentException {
        if (name < this.minIndex || name > this.maxIndex) {
            throw new IllegalArgumentException("Argument out of range.");
        }
        for (Bucket ptr = this.Head; ptr != null; ptr = ptr.cdr()) {
            double bucketValue = ptr.Name();
            if (name != bucketValue && !(name <= bucketValue + this.width)) continue;
            return ptr.size();
        }
        throw new IllegalArgumentException("Name " + name + " out of range.");
    }

    public double Width() {
        return this.width;
    }

    public void print() {
        System.out.println("Maximum index range  : " + this.maxIndex);
        System.out.println("Minimum index range  : " + this.minIndex);
        System.out.println("Number of buckets    : " + this.numberBuckets);
        System.out.println("Width of each bucket : " + this.width);
        super.print();
    }

    public boolean saveState(String fileName) throws IOException {
        FileOutputStream f = new FileOutputStream(fileName);
        DataOutputStream oFile = new DataOutputStream(f);
        boolean res = this.saveState(oFile);
        f.close();
        return res;
    }

    public boolean saveState(DataOutputStream oFile) throws IOException {
        oFile.writeDouble(this.minIndex);
        oFile.writeDouble(this.maxIndex);
        oFile.writeDouble(this.width);
        oFile.writeLong(this.numberBuckets);
        return super.saveState(oFile);
    }

    public boolean restoreState(String fileName) throws FileNotFoundException, IOException {
        FileInputStream f = new FileInputStream(fileName);
        DataInputStream iFile = new DataInputStream(f);
        boolean res = this.restoreState(iFile);
        f.close();
        return res;
    }

    public boolean restoreState(DataInputStream iFile) throws IOException {
        this.minIndex = iFile.readDouble();
        this.maxIndex = iFile.readDouble();
        this.width = iFile.readDouble();
        this.numberBuckets = iFile.readLong();
        return super.restoreState(iFile);
    }
}

