/*
 * Copyright (c) 2008, Stephen Colebourne & Michael Nascimento Santos
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  * Neither the name of JSR-310 nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package javax.time.calendar.format;


/**
 * Package scoped utility class for formatting.
 *
 * @author Stephen Colebourne
 */
final class FormatUtil {

    /**
     * Constructs a new instance of the builder.
     */
    private FormatUtil() {
        super();
    }

    //-----------------------------------------------------------------------
    /**
     * Checks if the object is not null throwing an exception if it is.
     *
     * @param object  the object to check for null
     * @param description  the description to use in the exception if the object is null
     */
    static void checkNotNull(Object object, String description) {
        if (object == null) {
            throw new NullPointerException("The " + description + " must not be null");
        }
    }

    //-----------------------------------------------------------------------
    /**
     * Converts a number to the internationalised version.
     *
     * @param numericText  the text containing only numbers to convert to a string, not null
     * @param symbols  the symbols to convert using, not null
     * @return the converted text, never null
     * @throws NullPointerException if the text or symbols are null
     */
    static String convertToI18N(String numericText, DateTimeFormatSymbols symbols) {
        if (symbols.getZeroChar() == '0') {
            return numericText;
        }
        int diff = symbols.getZeroChar() - '0';
        char[] array = numericText.toCharArray();
        for (int i = 0; i < array.length; i++) {
            array[i] = (char) (array[i] + diff);
        }
        return new String(array);
    }

}
