/*
 * Decompiled with CFR 0.152.
 */
package javax.time;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.MathUtils;
import javax.time.calendar.format.CalendricalParseException;

public final class Duration
implements Comparable<Duration>,
Serializable {
    public static final Duration ZERO = new Duration(0L, 0);
    private static final long serialVersionUID = 1L;
    private static final int NANOS_PER_SECOND = 1000000000;
    private final long seconds;
    private final int nanos;

    public static Duration seconds(long seconds) {
        return Duration.create(seconds, 0);
    }

    public static Duration seconds(long seconds, long nanoAdjustment) {
        long secs = MathUtils.safeAdd(seconds, nanoAdjustment / 1000000000L);
        int nos = (int)(nanoAdjustment % 1000000000L);
        if (nos < 0) {
            nos += 1000000000;
            secs = MathUtils.safeDecrement(secs);
        }
        return Duration.create(secs, nos);
    }

    public static Duration seconds(BigDecimal seconds) {
        Instant.checkNotNull(seconds, "Seconds must not be null");
        return Duration.nanos(seconds.movePointRight(9).toBigIntegerExact());
    }

    public static Duration millis(long millis) {
        long secs = millis / 1000L;
        int mos = (int)(millis % 1000L);
        if (mos < 0) {
            mos += 1000;
            --secs;
        }
        return Duration.create(secs, mos * 1000000);
    }

    public static Duration nanos(long nanos) {
        long secs = nanos / 1000000000L;
        int nos = (int)(nanos % 1000000000L);
        if (nos < 0) {
            nos += 1000000000;
            --secs;
        }
        return Duration.create(secs, nos);
    }

    public static Duration nanos(BigInteger nanos) {
        Instant.checkNotNull(nanos, "Nanos must not be null");
        BigInteger[] divRem = nanos.divideAndRemainder(Instant.BILLION);
        if (divRem[0].bitLength() > 63) {
            throw new ArithmeticException("Exceeds capacity of Duration: " + nanos);
        }
        return Duration.seconds(divRem[0].longValue(), divRem[1].intValue());
    }

    public static Duration standardMinutes(long minutes) {
        return Duration.create(MathUtils.safeMultiply(minutes, 60), 0);
    }

    public static Duration standardHours(long hours) {
        return Duration.create(MathUtils.safeMultiply(hours, 3600), 0);
    }

    public static Duration standardDays(long days) {
        return Duration.create(MathUtils.safeMultiply(days, 86400), 0);
    }

    public static Duration durationBetween(InstantProvider startInclusive, InstantProvider endExclusive) {
        Instant start = Instant.from(startInclusive);
        Instant end = Instant.from(endExclusive);
        long secs = MathUtils.safeSubtract(end.getEpochSeconds(), start.getEpochSeconds());
        int nanos = end.getNanoOfSecond() - start.getNanoOfSecond();
        if (nanos < 0) {
            nanos += 1000000000;
            secs = MathUtils.safeDecrement(secs);
        }
        return Duration.create(secs, nanos);
    }

    public static Duration parse(String text) {
        Instant.checkNotNull(text, "Text to parse must not be null");
        int len = text.length();
        if (len < 4 || text.charAt(0) != 'P' && text.charAt(0) != 'p' || text.charAt(1) != 'T' && text.charAt(1) != 't' || text.charAt(len - 1) != 'S' && text.charAt(len - 1) != 's' || len == 5 && text.charAt(2) == '-' && text.charAt(3) == '0') {
            throw new CalendricalParseException("Duration could not be parsed: " + text, text, 0);
        }
        String numberText = text.substring(2, len - 1).replace(',', '.');
        int dot = numberText.indexOf(46);
        try {
            if (dot == -1) {
                return Duration.create(Long.parseLong(numberText), 0);
            }
            boolean negative = false;
            if (numberText.charAt(0) == '-') {
                negative = true;
            }
            long secs = Long.parseLong(numberText.substring(0, dot));
            len = (numberText = numberText.substring(dot + 1)).length();
            if (len == 0 || len > 9 || numberText.charAt(0) == '-') {
                throw new CalendricalParseException("Duration could not be parsed: " + text, text, 2);
            }
            int nanos = Integer.parseInt(numberText);
            switch (len) {
                case 1: {
                    nanos *= 100000000;
                    break;
                }
                case 2: {
                    nanos *= 10000000;
                    break;
                }
                case 3: {
                    nanos *= 1000000;
                    break;
                }
                case 4: {
                    nanos *= 100000;
                    break;
                }
                case 5: {
                    nanos *= 10000;
                    break;
                }
                case 6: {
                    nanos *= 1000;
                    break;
                }
                case 7: {
                    nanos *= 100;
                    break;
                }
                case 8: {
                    nanos *= 10;
                }
            }
            return negative ? Duration.seconds(secs, -nanos) : Duration.create(secs, nanos);
        }
        catch (ArithmeticException ex) {
            throw new CalendricalParseException("Duration could not be parsed: " + text, text, 2, ex);
        }
        catch (NumberFormatException ex) {
            throw new CalendricalParseException("Duration could not be parsed: " + text, text, 2, ex);
        }
    }

    private static Duration create(long seconds, int nanoAdjustment) {
        if ((seconds | (long)nanoAdjustment) == 0L) {
            return ZERO;
        }
        return new Duration(seconds, nanoAdjustment);
    }

    private Duration(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
    }

    private Object readResolve() {
        return (this.seconds | (long)this.nanos) == 0L ? ZERO : this;
    }

    public boolean isZero() {
        return (this.seconds | (long)this.nanos) == 0L;
    }

    public boolean isPositive() {
        return this.seconds >= 0L && (this.seconds | (long)this.nanos) != 0L;
    }

    public boolean isPositiveOrZero() {
        return this.seconds >= 0L;
    }

    public boolean isNegative() {
        return this.seconds < 0L;
    }

    public boolean isNegativeOrZero() {
        return this.seconds < 0L || (this.seconds | (long)this.nanos) == 0L;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanosInSecond() {
        return this.nanos;
    }

    public Duration plus(Duration duration) {
        long secsToAdd = duration.seconds;
        int nanosToAdd = duration.nanos;
        if (secsToAdd == 0L && nanosToAdd == 0) {
            return this;
        }
        long secs = MathUtils.safeAdd(this.seconds, secsToAdd);
        int nos = this.nanos + nanosToAdd;
        if (nos >= 1000000000) {
            nos -= 1000000000;
            secs = MathUtils.safeIncrement(secs);
        }
        return Duration.create(secs, nos);
    }

    public Duration plusSeconds(long secondsToAdd) {
        if (secondsToAdd == 0L) {
            return this;
        }
        long secs = MathUtils.safeAdd(this.seconds, secondsToAdd);
        return Duration.create(secs, this.nanos);
    }

    public Duration plusMillis(long millisToAdd) {
        if (millisToAdd == 0L) {
            return this;
        }
        long secondsToAdd = millisToAdd / 1000L;
        int nos = (int)(millisToAdd % 1000L) * 1000000;
        if ((nos += this.nanos) < 0) {
            nos += 1000000000;
            --secondsToAdd;
        } else if (nos >= 1000000000) {
            nos -= 1000000000;
            ++secondsToAdd;
        }
        return Duration.create(MathUtils.safeAdd(this.seconds, secondsToAdd), nos);
    }

    public Duration plusNanos(long nanosToAdd) {
        if (nanosToAdd == 0L) {
            return this;
        }
        long secondsToAdd = nanosToAdd / 1000000000L;
        int nos = (int)(nanosToAdd % 1000000000L);
        if ((nos += this.nanos) < 0) {
            nos += 1000000000;
            --secondsToAdd;
        } else if (nos >= 1000000000) {
            nos -= 1000000000;
            ++secondsToAdd;
        }
        return Duration.create(MathUtils.safeAdd(this.seconds, secondsToAdd), nos);
    }

    public Duration minus(Duration duration) {
        long secsToSubtract = duration.seconds;
        int nanosToSubtract = duration.nanos;
        if (secsToSubtract == 0L && nanosToSubtract == 0) {
            return this;
        }
        long secs = MathUtils.safeSubtract(this.seconds, secsToSubtract);
        int nos = this.nanos - nanosToSubtract;
        if (nos < 0) {
            nos += 1000000000;
            secs = MathUtils.safeDecrement(secs);
        }
        return Duration.create(secs, nos);
    }

    public Duration minusSeconds(long secondsToSubtract) {
        if (secondsToSubtract == 0L) {
            return this;
        }
        long secs = MathUtils.safeSubtract(this.seconds, secondsToSubtract);
        return Duration.create(secs, this.nanos);
    }

    public Duration minusMillis(long millisToSubtract) {
        if (millisToSubtract == 0L) {
            return this;
        }
        long secondsToSubtract = millisToSubtract / 1000L;
        int nos = (int)(millisToSubtract % 1000L) * 1000000;
        if ((nos = this.nanos - nos) < 0) {
            nos += 1000000000;
            ++secondsToSubtract;
        } else if (nos >= 1000000000) {
            nos -= 1000000000;
            --secondsToSubtract;
        }
        return Duration.create(MathUtils.safeSubtract(this.seconds, secondsToSubtract), nos);
    }

    public Duration minusNanos(long nanosToSubtract) {
        if (nanosToSubtract == 0L) {
            return this;
        }
        long secondsToSubtract = nanosToSubtract / 1000000000L;
        int nos = (int)(nanosToSubtract % 1000000000L);
        if ((nos = this.nanos - nos) < 0) {
            nos += 1000000000;
            ++secondsToSubtract;
        } else if (nos >= 1000000000) {
            nos -= 1000000000;
            --secondsToSubtract;
        }
        return Duration.create(MathUtils.safeSubtract(this.seconds, secondsToSubtract), nos);
    }

    public Duration multipliedBy(long multiplicand) {
        if (multiplicand == 0L) {
            return ZERO;
        }
        if (multiplicand == 1L) {
            return this;
        }
        BigInteger nanos = this.toNanos();
        BigInteger[] divRem = (nanos = nanos.multiply(BigInteger.valueOf(multiplicand))).divideAndRemainder(Instant.BILLION);
        if (divRem[0].bitLength() > 63) {
            throw new ArithmeticException("Multiplication result exceeds capacity of Duration: " + this + " * " + multiplicand);
        }
        return Duration.seconds(divRem[0].longValue(), divRem[1].intValue());
    }

    public Duration dividedBy(long divisor) {
        if (divisor == 0L) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        if (divisor == 1L) {
            return this;
        }
        BigInteger nanos = this.toNanos();
        nanos = nanos.divide(BigInteger.valueOf(divisor));
        BigInteger[] divRem = nanos.divideAndRemainder(Instant.BILLION);
        return Duration.seconds(divRem[0].longValue(), divRem[1].intValue());
    }

    public Duration negated() {
        return this.multipliedBy(-1L);
    }

    public Duration abs() {
        return this.isNegative() ? this.negated() : this;
    }

    public BigDecimal toSeconds() {
        return BigDecimal.valueOf(this.seconds).add(BigDecimal.valueOf(this.nanos, 9));
    }

    public BigInteger toNanos() {
        return BigInteger.valueOf(this.seconds).multiply(Instant.BILLION).add(BigInteger.valueOf(this.nanos));
    }

    public long toNanosLong() {
        long millis = MathUtils.safeMultiply(this.seconds, 1000000000);
        millis = MathUtils.safeAdd(millis, (long)this.nanos);
        return millis;
    }

    public long toMillisLong() {
        long millis = MathUtils.safeMultiply(this.seconds, 1000);
        millis = MathUtils.safeAdd(millis, (long)(this.nanos / 1000000));
        return millis;
    }

    @Override
    public int compareTo(Duration otherDuration) {
        int cmp = MathUtils.safeCompare(this.seconds, otherDuration.seconds);
        if (cmp != 0) {
            return cmp;
        }
        return MathUtils.safeCompare(this.nanos, otherDuration.nanos);
    }

    public boolean isGreaterThan(Duration otherDuration) {
        return this.compareTo(otherDuration) > 0;
    }

    public boolean isLessThan(Duration otherDuration) {
        return this.compareTo(otherDuration) < 0;
    }

    public boolean equals(Object otherDuration) {
        if (this == otherDuration) {
            return true;
        }
        if (otherDuration instanceof Duration) {
            Duration other = (Duration)otherDuration;
            return this.seconds == other.seconds && this.nanos == other.nanos;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32) + 51 * this.nanos;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(24);
        buf.append("PT");
        if (this.seconds < 0L && this.nanos > 0) {
            if (this.seconds == -1L) {
                buf.append("-0");
            } else {
                buf.append(this.seconds + 1L);
            }
        } else {
            buf.append(this.seconds);
        }
        if (this.nanos > 0) {
            int pos = buf.length();
            if (this.seconds < 0L) {
                buf.append(2000000000 - this.nanos);
            } else {
                buf.append(this.nanos + 1000000000);
            }
            while (buf.charAt(buf.length() - 1) == '0') {
                buf.setLength(buf.length() - 1);
            }
            buf.setCharAt(pos, '.');
        }
        buf.append('S');
        return buf.toString();
    }
}

