/*
 * Decompiled with CFR 0.152.
 */
package javax.time;

public final class MathUtils {
    private MathUtils() {
    }

    public static int safeNegate(int value) {
        if (value == Integer.MIN_VALUE) {
            throw new ArithmeticException("Integer.MIN_VALUE cannot be negated");
        }
        return -value;
    }

    public static long safeNegate(long value) {
        if (value == Long.MIN_VALUE) {
            throw new ArithmeticException("Long.MIN_VALUE cannot be negated");
        }
        return -value;
    }

    public static int safeAdd(int a, int b) {
        int sum = a + b;
        if ((a ^ sum) < 0 && (a ^ b) >= 0) {
            throw new ArithmeticException("Addition overflows an int: " + a + " + " + b);
        }
        return sum;
    }

    public static long safeAdd(long a, long b) {
        long sum = a + b;
        if ((a ^ sum) < 0L && (a ^ b) >= 0L) {
            throw new ArithmeticException("Addition overflows a long: " + a + " + " + b);
        }
        return sum;
    }

    public static int safeSubtract(int a, int b) {
        int result = a - b;
        if ((a ^ result) < 0 && (a ^ b) < 0) {
            throw new ArithmeticException("Subtraction overflows an int: " + a + " - " + b);
        }
        return result;
    }

    public static long safeSubtract(long a, long b) {
        long result = a - b;
        if ((a ^ result) < 0L && (a ^ b) < 0L) {
            throw new ArithmeticException("Subtraction overflows a long: " + a + " - " + b);
        }
        return result;
    }

    public static int safeMultiply(int a, int b) {
        long total = (long)a * (long)b;
        if (total < Integer.MIN_VALUE || total > Integer.MAX_VALUE) {
            throw new ArithmeticException("Multiplication overflows an int: " + a + " * " + b);
        }
        return (int)total;
    }

    public static long safeMultiply(long a, int b) {
        switch (b) {
            case -1: {
                if (a == Long.MIN_VALUE) {
                    throw new ArithmeticException("Multiplication overflows a long: " + a + " * " + b);
                }
                return -a;
            }
            case 0: {
                return 0L;
            }
            case 1: {
                return a;
            }
        }
        long total = a * (long)b;
        if (total / (long)b != a) {
            throw new ArithmeticException("Multiplication overflows a long: " + a + " * " + b);
        }
        return total;
    }

    public static long safeMultiply(long a, long b) {
        if (b == 1L) {
            return a;
        }
        if (a == 1L) {
            return b;
        }
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long total = a * b;
        if (total / b != a || a == Long.MIN_VALUE && b == -1L || b == Long.MIN_VALUE && a == -1L) {
            throw new ArithmeticException("Multiplication overflows a long: " + a + " * " + b);
        }
        return total;
    }

    public static int safeIncrement(int value) {
        if (value == Integer.MAX_VALUE) {
            throw new ArithmeticException("Integer.MAX_VALUE cannot be incremented");
        }
        return value + 1;
    }

    public static long safeIncrement(long value) {
        if (value == Long.MAX_VALUE) {
            throw new ArithmeticException("Long.MAX_VALUE cannot be incremented");
        }
        return value + 1L;
    }

    public static int safeDecrement(int value) {
        if (value == Integer.MIN_VALUE) {
            throw new ArithmeticException("Integer.MIN_VALUE cannot be decremented");
        }
        return value - 1;
    }

    public static long safeDecrement(long value) {
        if (value == Long.MIN_VALUE) {
            throw new ArithmeticException("Long.MIN_VALUE cannot be decremented");
        }
        return value - 1L;
    }

    public static int safeToInt(long value) {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new ArithmeticException("Calculation overflows an int: " + value);
        }
        return (int)value;
    }

    public static int safeCompare(int a, int b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int safeCompare(long a, long b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }
}

