/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.TimeSource;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.Year;
import javax.time.calendar.YearMonth;
import javax.time.calendar.ZonedDateTime;

public abstract class Clock {
    public static Clock systemDefaultZone() {
        TimeZone zone = TimeZone.of(java.util.TimeZone.getDefault().getID());
        return new TimeSourceClock(TimeSource.system(), zone);
    }

    public static Clock system(TimeZone zone) {
        ISOChronology.checkNotNull(zone, "TimeZone must not be null");
        return new TimeSourceClock(TimeSource.system(), zone);
    }

    public static Clock clockDefaultZone(TimeSource timeSource) {
        ISOChronology.checkNotNull(timeSource, "TimeSource must not be null");
        TimeZone zone = TimeZone.of(java.util.TimeZone.getDefault().getID());
        return new TimeSourceClock(timeSource, zone);
    }

    public static Clock clock(TimeSource timeSource, TimeZone timeZone) {
        ISOChronology.checkNotNull(timeSource, "TimeSource must not be null");
        ISOChronology.checkNotNull(timeZone, "TimeZone must not be null");
        return new TimeSourceClock(timeSource, timeZone);
    }

    protected Clock() {
    }

    public TimeSource getSource() {
        throw new UnsupportedOperationException("Clock.getSource is not supported");
    }

    public Clock withSource(TimeSource timeSource) {
        throw new UnsupportedOperationException("Clock.withSource is not supported");
    }

    public TimeZone getZone() {
        throw new UnsupportedOperationException("Clock.getZone is not supported");
    }

    public Clock withZone(TimeZone zone) {
        throw new UnsupportedOperationException("Clock.withZone is not supported");
    }

    public Instant instant() {
        return this.getSource().instant();
    }

    public LocalDate today() {
        return this.offsetDate().toLocalDate();
    }

    public LocalDate yesterday() {
        return this.today().minusDays(1L);
    }

    public LocalDate tomorrow() {
        return this.today().plusDays(1L);
    }

    public YearMonth yearMonth() {
        LocalDate today = this.today();
        return YearMonth.of(today.getYear(), today.getMonthOfYear());
    }

    public Year year() {
        return this.today().toYear();
    }

    public LocalTime time() {
        return this.offsetTime().toLocalTime();
    }

    public LocalTime timeToSecond() {
        return this.time().withNanoOfSecond(0);
    }

    public LocalTime timeToMinute() {
        return this.time().withSecondOfMinute(0).withNanoOfSecond(0);
    }

    public LocalDateTime dateTime() {
        return this.offsetDateTime().toLocalDateTime();
    }

    public LocalDateTime dateTimeToSecond() {
        return this.dateTime().withNanoOfSecond(0);
    }

    public LocalDateTime dateTimeToMinute() {
        return this.dateTime().withSecondOfMinute(0).withNanoOfSecond(0);
    }

    public OffsetDate offsetDate() {
        Instant instant = this.instant();
        return OffsetDate.fromInstant(instant, this.getZone().getRules().getOffset(instant));
    }

    public OffsetTime offsetTime() {
        Instant instant = this.instant();
        return OffsetTime.fromInstant(instant, this.getZone().getRules().getOffset(instant));
    }

    public OffsetTime offsetTimeToSecond() {
        return this.offsetTime().withNanoOfSecond(0);
    }

    public OffsetTime offsetTimeToMinute() {
        return this.offsetTime().withSecondOfMinute(0).withNanoOfSecond(0);
    }

    public OffsetDateTime offsetDateTime() {
        Instant instant = this.instant();
        return OffsetDateTime.fromInstant(instant, this.getZone().getRules().getOffset(instant));
    }

    public OffsetDateTime offsetDateTimeToSecond() {
        return this.offsetDateTime().withNanoOfSecond(0);
    }

    public OffsetDateTime offsetDateTimeToMinute() {
        return this.offsetDateTime().withSecondOfMinute(0).withNanoOfSecond(0);
    }

    public ZonedDateTime zonedDateTime() {
        return ZonedDateTime.fromInstant(this.instant(), this.getZone());
    }

    public ZonedDateTime zonedDateTimeToSecond() {
        return this.zonedDateTime().withNanoOfSecond(0);
    }

    public ZonedDateTime zonedDateTimeToMinute() {
        return this.zonedDateTime().withSecondOfMinute(0).withNanoOfSecond(0);
    }

    private static final class TimeSourceClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TimeSource timeSource;
        private final TimeZone zone;

        private TimeSourceClock(TimeSource timeSource, TimeZone zone) {
            this.timeSource = timeSource;
            this.zone = zone;
        }

        @Override
        public TimeSource getSource() {
            return this.timeSource;
        }

        @Override
        public Clock withSource(TimeSource timeSource) {
            ISOChronology.checkNotNull(timeSource, "TimeSource must not be null");
            if (timeSource.equals(this.timeSource)) {
                return this;
            }
            return new TimeSourceClock(timeSource, this.zone);
        }

        @Override
        public TimeZone getZone() {
            return this.zone;
        }

        @Override
        public Clock withZone(TimeZone zone) {
            ISOChronology.checkNotNull(zone, "TimeZone must not be null");
            if (zone.equals(this.zone)) {
                return this;
            }
            return new TimeSourceClock(this.timeSource, zone);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof TimeSourceClock) {
                TimeSourceClock other = (TimeSourceClock)obj;
                return this.timeSource.equals(other.timeSource) && this.zone.equals(other.zone);
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + this.timeSource.hashCode();
            hash = 41 * hash + this.zone.hashCode();
            return hash;
        }

        public String toString() {
            return "TimeSourceClock[" + this.timeSource + ", " + this.zone + ']';
        }
    }
}

