/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.Chronology;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.PeriodUnit;
import javax.time.calendar.UnsupportedRuleException;
import javax.time.calendar.format.DateTimeFormatterBuilder;

public abstract class DateTimeFieldRule<T>
extends CalendricalRule<T> {
    private static final long serialVersionUID = 837528753278L;
    private static final MathContext FRACTION_CONTEXT = new MathContext(9, RoundingMode.FLOOR);
    private static final MathContext VALUE_CONTEXT = new MathContext(0, RoundingMode.FLOOR);
    private final int minimumValue;
    private final int maximumValue;
    private final transient ConcurrentMap<Locale, SoftReference<EnumMap<DateTimeFormatterBuilder.TextStyle, TextStore>>> textStores;

    protected DateTimeFieldRule(Class<T> reifiedClass, Chronology chronology, String name, PeriodUnit periodUnit, PeriodUnit periodRange, int minimumValue, int maximumValue) {
        this(reifiedClass, chronology, name, periodUnit, periodRange, minimumValue, maximumValue, false);
    }

    protected DateTimeFieldRule(Class<T> reifiedClass, Chronology chronology, String name, PeriodUnit periodUnit, PeriodUnit periodRange, int minimumValue, int maximumValue, boolean hasText) {
        super(reifiedClass, chronology, name, periodUnit, periodRange);
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.textStores = hasText ? new ConcurrentHashMap() : null;
    }

    public final Integer getInteger(Calendrical calendrical) {
        Object value = this.getValue(calendrical);
        return value == null ? null : this.convertValueToInteger(value);
    }

    public final int getInt(Calendrical calendrical) {
        Object value = this.getValue(calendrical);
        if (value == null) {
            throw new UnsupportedRuleException(this);
        }
        return this.convertValueToInt(value);
    }

    private Integer convertValueToInteger(T value) {
        if (this.getReifiedType() == Integer.class) {
            return (Integer)value;
        }
        return this.convertValueToInt(value);
    }

    public int convertValueToInt(T value) {
        if (value instanceof Enum) {
            return ((Enum)value).ordinal() + this.getMinimumValue();
        }
        return (Integer)value;
    }

    public T convertIntToValue(int value) {
        this.checkValue(value);
        if (Enum.class.isAssignableFrom(this.getReifiedType())) {
            return this.getReifiedType().getEnumConstants()[value - this.getMinimumValue()];
        }
        return this.reify(value);
    }

    public boolean isValidValue(int value) {
        return value >= this.getMinimumValue() && value <= this.getMaximumValue();
    }

    public boolean isValidValue(long value) {
        return value >= (long)this.getMinimumValue() && value <= (long)this.getMaximumValue();
    }

    public void checkValue(int value) {
        if (!this.isValidValue(value)) {
            throw new IllegalCalendarFieldValueException(this, value, this.getMinimumValue(), this.getMaximumValue());
        }
    }

    public int checkValue(long value) {
        if (!this.isValidValue(value)) {
            throw new IllegalCalendarFieldValueException(this, value, this.getMinimumValue(), this.getMaximumValue());
        }
        return (int)value;
    }

    public boolean isFixedValueSet() {
        return this.getMaximumValue() == this.getSmallestMaximumValue() && this.getMinimumValue() == this.getLargestMinimumValue();
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getLargestMinimumValue() {
        return this.getMinimumValue();
    }

    public int getMinimumValue(Calendrical calendrical) {
        return this.getMinimumValue();
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getSmallestMaximumValue() {
        return this.getMaximumValue();
    }

    public int getMaximumValue(Calendrical calendrical) {
        return this.getMaximumValue();
    }

    public String getText(int value, Locale locale, DateTimeFormatterBuilder.TextStyle textStyle) {
        TextStore textStore = this.getTextStore(locale, textStyle);
        String text = textStore != null ? textStore.getValueText(value) : null;
        return text == null ? Integer.toString(value) : text;
    }

    public TextStore getTextStore(Locale locale, DateTimeFormatterBuilder.TextStyle textStyle) {
        EnumMap textMapByStyle;
        if (this.textStores == null) {
            return null;
        }
        SoftReference ref = (SoftReference)this.textStores.get(locale);
        if (ref != null && (textMapByStyle = (EnumMap)ref.get()) != null) {
            return (TextStore)textMapByStyle.get((Object)textStyle);
        }
        EnumMap<DateTimeFormatterBuilder.TextStyle, TextStore> textStoreByStyle = new EnumMap<DateTimeFormatterBuilder.TextStyle, TextStore>(DateTimeFormatterBuilder.TextStyle.class);
        this.createTextStores(textStoreByStyle, locale);
        textStoreByStyle = new EnumMap<DateTimeFormatterBuilder.TextStyle, TextStore>(textStoreByStyle);
        this.textStores.put(locale, new SoftReference<EnumMap<DateTimeFormatterBuilder.TextStyle, TextStore>>(textStoreByStyle));
        return textStoreByStyle.get((Object)textStyle);
    }

    protected void createTextStores(EnumMap<DateTimeFormatterBuilder.TextStyle, TextStore> textStores, Locale locale) {
    }

    public BigDecimal convertIntToFraction(int value) {
        if (!this.isFixedValueSet()) {
            throw new UnsupportedRuleException("The fractional value of " + this.getName() + " cannot be obtained as the range is not fixed", this);
        }
        if (this.getMinimumValue() != 0) {
            throw new UnsupportedRuleException("The fractional value of " + this.getName() + " cannot be obtained as the minimum field value is not zero", this);
        }
        this.checkValue(value);
        long range = this.getMaximumValue();
        BigDecimal decimal = new BigDecimal(value);
        return decimal.divide(new BigDecimal(++range), FRACTION_CONTEXT);
    }

    public int convertFractionToInt(BigDecimal fraction) {
        if (!this.isFixedValueSet()) {
            throw new UnsupportedRuleException("The fractional value of " + this.getName() + " cannot be converted as the range is not fixed", this);
        }
        if (this.getMinimumValue() != 0) {
            throw new UnsupportedRuleException("The fractional value of " + this.getName() + " cannot be converted as the minimum field value is not zero", this);
        }
        long range = this.getMaximumValue();
        BigDecimal decimal = fraction.multiply(new BigDecimal(++range), VALUE_CONTEXT);
        try {
            int value = decimal.intValueExact();
            this.checkValue(value);
            return value;
        }
        catch (ArithmeticException ex) {
            throw new IllegalCalendarFieldValueException("The fractional value " + fraction + " of " + this.getName() + " cannot be converted as it is not in the range 0 (inclusive) to 1 (exclusive)", this);
        }
    }

    public static final class TextStore {
        private final Locale locale;
        private final Map<Integer, String> valueTextMap;
        private final Map<String, Integer> textValueMap;
        private final Map<String, Integer> insensitiveTextValueMap;
        private final int[] lengths;

        public TextStore(Locale locale, Map<Integer, String> valueTextMap) {
            ISOChronology.checkNotNull(locale, "Locale must not be null");
            ISOChronology.checkNotNull(valueTextMap, "Map must not be null");
            if (valueTextMap.containsKey(null) || valueTextMap.containsValue(null) || valueTextMap.containsValue("")) {
                throw new IllegalArgumentException("The map must not contain null or empty text");
            }
            this.locale = locale;
            HashMap<Integer, String> copy = new HashMap<Integer, String>(valueTextMap);
            HashMap<String, Integer> reverse = new HashMap<String, Integer>();
            HashMap<String, Integer> insensitive = new HashMap<String, Integer>();
            HashSet<Integer> lengthSet = new HashSet<Integer>();
            for (Map.Entry entry : copy.entrySet()) {
                String text = (String)entry.getValue();
                Integer value = (Integer)entry.getKey();
                reverse.put(text, value);
                lengthSet.add(text.length());
                String lower = text.toLowerCase(locale);
                insensitive.put(lower, value);
                lengthSet.add(lower.length());
                String upper = text.toUpperCase(locale);
                insensitive.put(upper, value);
                lengthSet.add(upper.length());
            }
            if (reverse.size() < copy.size()) {
                this.textValueMap = Collections.emptyMap();
                this.insensitiveTextValueMap = Collections.emptyMap();
                this.lengths = null;
            } else {
                this.textValueMap = Collections.unmodifiableMap(reverse);
                this.insensitiveTextValueMap = Collections.unmodifiableMap(insensitive);
                this.lengths = new int[lengthSet.size()];
                int i = 0;
                Iterator it = lengthSet.iterator();
                while (it.hasNext()) {
                    this.lengths[i++] = (Integer)it.next();
                }
                Arrays.sort(this.lengths);
            }
            this.valueTextMap = Collections.unmodifiableMap(copy);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Map<Integer, String> getValueTextMap() {
            return this.valueTextMap;
        }

        public String getValueText(int value) {
            return this.valueTextMap.get(value);
        }

        public Map<String, Integer> getTextValueMap() {
            return this.textValueMap;
        }

        public long matchText(boolean ignoreCase, String parseText) {
            ISOChronology.checkNotNull(parseText, "Search text must not be null");
            if (this.lengths == null) {
                return -1L;
            }
            int lengthsStart = Arrays.binarySearch(this.lengths, parseText.length());
            int n = lengthsStart = lengthsStart < 0 ? -lengthsStart - 2 : lengthsStart;
            if (ignoreCase) {
                Integer value;
                int i;
                parseText = parseText.toUpperCase(this.locale);
                for (i = lengthsStart; i >= 0; --i) {
                    value = this.insensitiveTextValueMap.get(parseText.substring(0, this.lengths[i]));
                    if (value == null) continue;
                    return ((long)this.lengths[i] << 32) + (long)value.intValue();
                }
                parseText = parseText.toLowerCase(this.locale);
                for (i = lengthsStart; i >= 0; --i) {
                    value = this.insensitiveTextValueMap.get(parseText.substring(0, this.lengths[i]));
                    if (value == null) continue;
                    return ((long)this.lengths[i] << 32) + (long)value.intValue();
                }
            } else {
                for (int i = lengthsStart; i >= 0; --i) {
                    Integer value = this.textValueMap.get(parseText.substring(0, this.lengths[i]));
                    if (value == null) continue;
                    return ((long)this.lengths[i] << 32) + (long)value.intValue();
                }
            }
            return 0L;
        }
    }
}

