/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import javax.time.CalendricalException;
import javax.time.Duration;
import javax.time.MathUtils;
import javax.time.calendar.AmPmOfDay;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMerger;
import javax.time.calendar.CalendricalRuleException;
import javax.time.calendar.Chronology;
import javax.time.calendar.DateAdjusters;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.PeriodUnit;
import javax.time.calendar.QuarterOfYear;
import javax.time.calendar.TimeZone;
import javax.time.calendar.Year;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.period.Period;
import javax.time.period.PeriodField;

public final class ISOChronology
extends Chronology
implements Serializable {
    public static final ISOChronology INSTANCE = new ISOChronology();
    public static final int MIN_WEEK_BASED_YEAR = -2147483646;
    public static final int MAX_WEEK_BASED_YEAR = Integer.MAX_VALUE;
    private static final long serialVersionUID = 1L;
    static final int SECONDS_PER_DAY = 86400;
    static final int DAYS_PER_CYCLE = 146097;
    static final long DAYS_0000_TO_1970 = 719528L;
    static final long DAYS_0000_TO_MJD_EPOCH = 678941L;
    private static final int[] STANDARD_MONTH_START = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP_MONTH_START = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private static final Unit NANOS = new Unit(0, "Nanos", null, Duration.nanos(1L));
    private static final Unit MICROS = new Unit(1, "Micros", PeriodField.of(1000L, NANOS), Duration.nanos(1000L));
    private static final Unit MILLIS = new Unit(2, "Millis", PeriodField.of(1000L, MICROS), Duration.millis(1L));
    private static final Unit SECONDS = new Unit(3, "Seconds", PeriodField.of(1000L, MILLIS), Duration.seconds(1L));
    private static final Unit MINUTES = new Unit(4, "Minutes", PeriodField.of(60L, SECONDS), Duration.seconds(60L));
    private static final Unit HOURS = new Unit(5, "Hours", PeriodField.of(60L, MINUTES), Duration.seconds(3600L));
    private static final Unit _12_HOURS = new Unit(6, "12Hours", PeriodField.of(12L, HOURS), Duration.seconds(43200L));
    private static final Unit _24_HOURS = new Unit(7, "24Hours", PeriodField.of(2L, _12_HOURS), Duration.seconds(86400L));
    private static final Unit DAYS = new Unit(8, "Days", null, Duration.seconds(86400L));
    private static final Unit WEEKS = new Unit(9, "Weeks", PeriodField.of(7L, DAYS), Duration.seconds(604800L));
    private static final Unit MONTHS = new Unit(10, "Months", null, Duration.seconds(2629746L));
    private static final Unit QUARTERS = new Unit(11, "Quarters", PeriodField.of(3L, MONTHS), Duration.seconds(7889238L));
    private static final Unit WEEK_BASED_YEARS = new Unit(12, "WeekBasedYears", null, Duration.seconds(31492800L));
    private static final Unit YEARS = new Unit(13, "Years", PeriodField.of(4L, QUARTERS), Duration.seconds(31556952L));
    private static final Unit DECADES = new Unit(14, "Decades", PeriodField.of(10L, YEARS), Duration.seconds(315569520L));
    private static final Unit CENTURIES = new Unit(15, "Centuries", PeriodField.of(10L, DECADES), Duration.seconds(3155695200L));
    private static final Unit MILLENNIA = new Unit(16, "Millennia", PeriodField.of(10L, CENTURIES), Duration.seconds(31556952000L));
    private static final Unit ERAS = new Unit(17, "Eras", null, Duration.seconds(63113904000000000L));
    private static final Unit[] UNIT_CACHE = new Unit[]{NANOS, MICROS, MILLIS, SECONDS, MINUTES, HOURS, _12_HOURS, _24_HOURS, DAYS, WEEKS, MONTHS, QUARTERS, WEEK_BASED_YEARS, YEARS, DECADES, CENTURIES, MILLENNIA, ERAS};

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    static void checkNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    static int addYears(int year, int years) {
        int result = year + years;
        if ((year ^ result) < 0 && (year ^ years) >= 0 || !ISOChronology.yearRule().isValidValue(result)) {
            throw new CalendricalException("Addition exceeds the supported year range: " + year + " + " + years);
        }
        return result;
    }

    static int subtractYears(int year, int years) {
        int result = year - years;
        if ((year ^ result) < 0 && (year ^ years) < 0 || !ISOChronology.yearRule().isValidValue(result)) {
            throw new CalendricalException("Subtraction exceeds the supported year range: " + year + " - " + years);
        }
        return result;
    }

    static DayOfWeek getDayOfWeekFromDate(LocalDate date) {
        long mjd = date.toModifiedJulianDays();
        if (mjd < 0L) {
            long weeks = mjd / 7L;
            mjd += (-weeks + 1L) * 7L;
        }
        int dow0 = (int)((mjd + 2L) % 7L);
        return DayOfWeek.of(dow0 + 1);
    }

    static int getDayOfYearFromDate(LocalDate date) {
        int moy0 = date.getMonthOfYear().ordinal();
        int dom = date.getDayOfMonth();
        if (ISOChronology.isLeapYear(date.getYear())) {
            return LEAP_MONTH_START[moy0] + dom;
        }
        return STANDARD_MONTH_START[moy0] + dom;
    }

    static LocalDate getDateFromDayOfYear(int year, int dayOfYear) {
        int month;
        boolean leap = ISOChronology.isLeapYear(year);
        if (dayOfYear == 366 && !leap) {
            throw new InvalidCalendarFieldException("DayOfYear 366 is invalid for year " + year, ISOChronology.dayOfYearRule());
        }
        int doy0 = dayOfYear - 1;
        int[] array = leap ? LEAP_MONTH_START : STANDARD_MONTH_START;
        for (month = 1; month < 12 && doy0 >= array[month]; ++month) {
        }
        MonthOfYear moy = MonthOfYear.of(month);
        int dom = dayOfYear - array[month - 1];
        return LocalDate.of(year, moy, dom);
    }

    static int getWeekBasedYearFromDate(LocalDate date) {
        int dow;
        int dom;
        Year year = date.toYear();
        if (date.getMonthOfYear() == MonthOfYear.JANUARY) {
            int dow2;
            int dom2 = date.getDayOfMonth();
            if (dom2 < 4 && (dow2 = date.getDayOfWeek().getValue()) > dom2 + 3) {
                year = year.previous();
            }
        } else if (date.getMonthOfYear() == MonthOfYear.DECEMBER && (dom = date.getDayOfMonth()) > 28 && (dow = date.getDayOfWeek().getValue()) <= dom % 7) {
            year = year.next();
        }
        return year.getValue();
    }

    static int getWeekOfWeekBasedYearFromDate(LocalDate date) {
        int wby = ISOChronology.getWeekBasedYearFromDate(date);
        LocalDate yearStart = LocalDate.of(wby, MonthOfYear.JANUARY, 4);
        return MathUtils.safeToInt((date.toModifiedJulianDays() - yearStart.toModifiedJulianDays() + (long)yearStart.getDayOfWeek().getValue() - 1L) / 7L + 1L);
    }

    private ISOChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "ISO";
    }

    public static DateTimeFieldRule<Integer> yearRule() {
        return YearRule.INSTANCE;
    }

    public static DateTimeFieldRule<MonthOfYear> monthOfYearRule() {
        return MonthOfYearRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> dayOfMonthRule() {
        return DayOfMonthRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> dayOfYearRule() {
        return DayOfYearRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> weekBasedYearRule() {
        return WeekBasedYearRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> weekOfWeekBasedYearRule() {
        return WeekOfWeekBasedYearRule.INSTANCE;
    }

    public static DateTimeFieldRule<DayOfWeek> dayOfWeekRule() {
        return DayOfWeekRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> weekOfYearRule() {
        return WeekOfYearRule.INSTANCE;
    }

    public static DateTimeFieldRule<QuarterOfYear> quarterOfYearRule() {
        return QuarterOfYearRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> monthOfQuarterRule() {
        return MonthOfQuarterRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> weekOfMonthRule() {
        return WeekOfMonthRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> hourOfDayRule() {
        return HourOfDayRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> minuteOfHourRule() {
        return MinuteOfHourRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> secondOfMinuteRule() {
        return SecondOfMinuteRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> nanoOfSecondRule() {
        return NanoOfSecondRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> secondOfDayRule() {
        return SecondOfDayRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> milliOfDayRule() {
        return MilliOfDayRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> milliOfSecondRule() {
        return MilliOfSecondRule.INSTANCE;
    }

    public static DateTimeFieldRule<AmPmOfDay> amPmOfDayRule() {
        return AmPmOfDayRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> hourOfAmPmRule() {
        return HourOfAmPmRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> clockHourOfAmPmRule() {
        return ClockHourOfAmPmRule.INSTANCE;
    }

    public static PeriodUnit periodEras() {
        return ERAS;
    }

    public static PeriodUnit periodMillennia() {
        return MILLENNIA;
    }

    public static PeriodUnit periodCenturies() {
        return CENTURIES;
    }

    public static PeriodUnit periodDecades() {
        return DECADES;
    }

    public static PeriodUnit periodYears() {
        return YEARS;
    }

    public static PeriodUnit periodWeekBasedYears() {
        return WEEK_BASED_YEARS;
    }

    public static PeriodUnit periodQuarters() {
        return QUARTERS;
    }

    public static PeriodUnit periodMonths() {
        return MONTHS;
    }

    public static PeriodUnit periodWeeks() {
        return WEEKS;
    }

    public static PeriodUnit periodDays() {
        return DAYS;
    }

    public static PeriodUnit period24Hours() {
        return _24_HOURS;
    }

    public static PeriodUnit period12Hours() {
        return _12_HOURS;
    }

    public static PeriodUnit periodHours() {
        return HOURS;
    }

    public static PeriodUnit periodMinutes() {
        return MINUTES;
    }

    public static PeriodUnit periodSeconds() {
        return SECONDS;
    }

    public static PeriodUnit periodMillis() {
        return MILLIS;
    }

    public static PeriodUnit periodMicros() {
        return MICROS;
    }

    public static PeriodUnit periodNanos() {
        return NANOS;
    }

    void merge(CalendricalMerger merger) {
        LocalDateTime ldt;
        Integer wbyVal;
        Integer yearVal;
        Integer hourVal;
        AmPmOfDay amPm;
        Integer modVal = merger.getValue(ISOChronology.milliOfDayRule());
        if (modVal != null) {
            merger.storeMerged(LocalTime.rule(), LocalTime.fromNanoOfDay((long)modVal.intValue() * 1000000L));
            merger.removeProcessed(ISOChronology.milliOfDayRule());
        }
        Integer sodVal = merger.getValue(ISOChronology.secondOfDayRule());
        if (modVal != null) {
            Integer nosVal = merger.getValue(ISOChronology.nanoOfSecondRule());
            if (nosVal != null) {
                merger.storeMerged(LocalTime.rule(), LocalTime.fromSecondOfDay(sodVal.intValue(), nosVal));
                merger.removeProcessed(ISOChronology.nanoOfSecondRule());
            } else {
                Integer mosVal = merger.getValue(ISOChronology.milliOfSecondRule());
                if (mosVal != null) {
                    merger.storeMerged(LocalTime.rule(), LocalTime.fromSecondOfDay(sodVal.intValue(), mosVal * 1000000));
                    merger.removeProcessed(ISOChronology.milliOfSecondRule());
                } else {
                    merger.storeMerged(LocalTime.rule(), LocalTime.fromSecondOfDay(sodVal.intValue()));
                }
            }
            merger.removeProcessed(ISOChronology.secondOfDayRule());
        }
        if ((amPm = merger.getValue(ISOChronology.amPmOfDayRule())) != null) {
            Integer chapVal;
            Integer hapVal = merger.getValue(ISOChronology.hourOfAmPmRule());
            if (hapVal != null) {
                int hourOfDay = amPm.getValue() * 12 + hapVal;
                merger.storeMerged(ISOChronology.hourOfDayRule(), hourOfDay);
                merger.removeProcessed(ISOChronology.amPmOfDayRule());
                merger.removeProcessed(ISOChronology.hourOfAmPmRule());
            }
            if ((chapVal = merger.getValue(ISOChronology.hourOfAmPmRule())) != null) {
                int hourOfDay = amPm.getValue() * 12 + chapVal;
                if (hourOfDay == 24) {
                    merger.addToOverflow(Period.days(1));
                    hourOfDay = 0;
                }
                merger.storeMerged(ISOChronology.hourOfDayRule(), hourOfDay);
                merger.removeProcessed(ISOChronology.amPmOfDayRule());
                merger.removeProcessed(ISOChronology.clockHourOfAmPmRule());
            }
        }
        if ((hourVal = merger.getValue(ISOChronology.hourOfDayRule())) != null) {
            Integer minuteVal = merger.getValue(ISOChronology.minuteOfHourRule());
            Integer secondVal = merger.getValue(ISOChronology.secondOfMinuteRule());
            Integer mosVal = merger.getValue(ISOChronology.milliOfSecondRule());
            Integer nanoVal = merger.getValue(ISOChronology.nanoOfSecondRule());
            if (minuteVal != null && secondVal != null && nanoVal != null) {
                merger.storeMerged(LocalTime.rule(), LocalTime.of(hourVal, minuteVal, secondVal, nanoVal));
                merger.removeProcessed(ISOChronology.hourOfDayRule());
                merger.removeProcessed(ISOChronology.minuteOfHourRule());
                merger.removeProcessed(ISOChronology.secondOfMinuteRule());
                merger.removeProcessed(ISOChronology.nanoOfSecondRule());
            } else if (minuteVal != null && secondVal != null && mosVal != null) {
                merger.storeMerged(LocalTime.rule(), LocalTime.of(hourVal, minuteVal, secondVal, mosVal * 1000000));
                merger.removeProcessed(ISOChronology.hourOfDayRule());
                merger.removeProcessed(ISOChronology.minuteOfHourRule());
                merger.removeProcessed(ISOChronology.secondOfMinuteRule());
                merger.removeProcessed(ISOChronology.milliOfSecondRule());
            } else if (minuteVal != null && secondVal != null) {
                merger.storeMerged(LocalTime.rule(), LocalTime.of(hourVal, minuteVal, secondVal, 0));
                merger.removeProcessed(ISOChronology.hourOfDayRule());
                merger.removeProcessed(ISOChronology.minuteOfHourRule());
                merger.removeProcessed(ISOChronology.secondOfMinuteRule());
            } else if (minuteVal != null) {
                merger.storeMerged(LocalTime.rule(), LocalTime.of(hourVal, minuteVal, 0, 0));
                merger.removeProcessed(ISOChronology.hourOfDayRule());
                merger.removeProcessed(ISOChronology.minuteOfHourRule());
            } else {
                merger.storeMerged(LocalTime.rule(), LocalTime.of(hourVal, 0));
                merger.removeProcessed(ISOChronology.hourOfDayRule());
            }
        }
        QuarterOfYear qoy = merger.getValue(ISOChronology.quarterOfYearRule());
        Integer moqVal = merger.getValue(ISOChronology.monthOfQuarterRule());
        if (qoy != null && moqVal != null) {
            MonthOfYear moy = MonthOfYear.of(qoy.getFirstMonthOfQuarter().ordinal() + moqVal);
            merger.storeMerged(ISOChronology.monthOfYearRule(), moy);
            merger.removeProcessed(ISOChronology.quarterOfYearRule());
            merger.removeProcessed(ISOChronology.monthOfQuarterRule());
        }
        if ((yearVal = merger.getValue(ISOChronology.yearRule())) != null) {
            Integer doyVal;
            MonthOfYear moy = merger.getValue(ISOChronology.monthOfYearRule());
            Integer domVal = merger.getValue(ISOChronology.dayOfMonthRule());
            if (moy != null && domVal != null) {
                LocalDate date = merger.getContext().resolveDate(yearVal, moy.getValue(), domVal);
                merger.storeMerged(LocalDate.rule(), date);
                merger.removeProcessed(ISOChronology.yearRule());
                merger.removeProcessed(ISOChronology.monthOfYearRule());
                merger.removeProcessed(ISOChronology.dayOfMonthRule());
            }
            if ((doyVal = merger.getValue(ISOChronology.dayOfYearRule())) != null) {
                merger.storeMerged(LocalDate.rule(), ISOChronology.getDateFromDayOfYear(yearVal, doyVal));
                merger.removeProcessed(ISOChronology.yearRule());
                merger.removeProcessed(ISOChronology.dayOfYearRule());
            }
            Integer woyVal = merger.getValue(ISOChronology.weekOfYearRule());
            DayOfWeek dow = merger.getValue(ISOChronology.dayOfWeekRule());
            if (woyVal != null && dow != null) {
                LocalDate date = LocalDate.of((int)yearVal, 1, 1).plusWeeks(woyVal - 1);
                date = date.with(DateAdjusters.nextOrCurrent(dow));
                merger.storeMerged(LocalDate.rule(), date);
                merger.removeProcessed(ISOChronology.yearRule());
                merger.removeProcessed(ISOChronology.weekOfYearRule());
                merger.removeProcessed(ISOChronology.dayOfWeekRule());
            }
            Integer womVal = merger.getValue(ISOChronology.weekOfMonthRule());
            if (moy != null && womVal != null && dow != null) {
                LocalDate date = LocalDate.of((int)yearVal, moy, 1).plusWeeks(womVal - 1);
                date = date.with(DateAdjusters.nextOrCurrent(dow));
                merger.storeMerged(LocalDate.rule(), date);
                merger.removeProcessed(ISOChronology.yearRule());
                merger.removeProcessed(ISOChronology.monthOfYearRule());
                merger.removeProcessed(ISOChronology.weekOfMonthRule());
                merger.removeProcessed(ISOChronology.dayOfWeekRule());
            }
        }
        if ((wbyVal = merger.getValue(ISOChronology.weekBasedYearRule())) != null) {
            Integer woy = merger.getValue(ISOChronology.weekOfWeekBasedYearRule());
            DayOfWeek dow = merger.getValue(ISOChronology.dayOfWeekRule());
            if (woy != null && dow != null) {
                merger.removeProcessed(ISOChronology.weekBasedYearRule());
                merger.removeProcessed(ISOChronology.weekOfWeekBasedYearRule());
                merger.removeProcessed(ISOChronology.dayOfWeekRule());
            }
        }
        LocalDate date = merger.getValue(LocalDate.rule());
        LocalTime time = merger.getValue(LocalTime.rule());
        ZoneOffset offset = merger.getValue(ZoneOffset.rule());
        TimeZone zone = merger.getValue(TimeZone.rule());
        if (date != null && time != null) {
            merger.storeMerged(LocalDateTime.rule(), LocalDateTime.from(date, time));
            merger.removeProcessed(LocalDate.rule());
            merger.removeProcessed(LocalTime.rule());
        }
        if (date != null && offset != null) {
            merger.storeMerged(OffsetDate.rule(), OffsetDate.from(date, offset));
            merger.removeProcessed(LocalDate.rule());
            merger.removeProcessed(ZoneOffset.rule());
        }
        if (time != null && offset != null) {
            merger.storeMerged(OffsetTime.rule(), OffsetTime.from(time, offset));
            merger.removeProcessed(LocalTime.rule());
            merger.removeProcessed(ZoneOffset.rule());
        }
        if ((ldt = merger.getValue(LocalDateTime.rule())) != null && offset != null) {
            merger.storeMerged(OffsetDateTime.rule(), OffsetDateTime.from(ldt, offset));
            merger.removeProcessed(LocalDateTime.rule());
            merger.removeProcessed(ZoneOffset.rule());
        } else {
            OffsetDate od = merger.getValue(OffsetDate.rule());
            OffsetTime ot = merger.getValue(OffsetTime.rule());
            if (od != null && ot != null) {
                if (!od.getOffset().equals(ot.getOffset())) {
                    if (merger.getContext().isStrict()) {
                        throw new CalendricalRuleException("Unable to merge OffsetDate and OffsetTime as offsets differ", OffsetTime.rule());
                    }
                    ot = ot.adjustLocalTime(od.getOffset());
                }
                merger.storeMerged(OffsetDateTime.rule(), OffsetDateTime.from(od, ot, od.getOffset()));
                merger.removeProcessed(OffsetDate.rule());
                merger.removeProcessed(OffsetTime.rule());
            }
        }
        OffsetDateTime odt = merger.getValue(OffsetDateTime.rule());
        if (odt != null && zone != null) {
            if (merger.getContext().isStrict()) {
                merger.storeMerged(ZonedDateTime.rule(), ZonedDateTime.of(odt, zone));
            } else {
                merger.storeMerged(ZonedDateTime.rule(), ZonedDateTime.fromInstant(odt, zone));
            }
            merger.removeProcessed(OffsetDateTime.rule());
            merger.removeProcessed(TimeZone.rule());
        }
    }

    static final class Unit
    extends PeriodUnit {
        private static final long serialVersionUID = 1L;
        private final int ordinal;

        private Unit(int ordinal, String name, PeriodField equivalentPeriod, Duration estimatedDuration) {
            super(name, equivalentPeriod, estimatedDuration);
            this.ordinal = ordinal;
        }

        private Object readResolve() {
            return UNIT_CACHE[this.ordinal];
        }
    }

    static final class ClockHourOfAmPmRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new ClockHourOfAmPmRule();
        private static final long serialVersionUID = 1L;

        private ClockHourOfAmPmRule() {
            super(Integer.class, INSTANCE, "ClockHourOfAmPm", HOURS, _12_HOURS, 1, 12);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            Integer hourVal = calendrical.get(ISOChronology.hourOfDayRule());
            if (hourVal == null) {
                return null;
            }
            long hour = hourVal.intValue();
            hour = (hour < 0L ? hour + 0x80000010L : hour) % 12L;
            return (int)(hour == 0L ? 12L : hour);
        }
    }

    static final class HourOfAmPmRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new HourOfAmPmRule();
        private static final long serialVersionUID = 1L;

        private HourOfAmPmRule() {
            super(Integer.class, INSTANCE, "HourOfAmPm", HOURS, _12_HOURS, 0, 11);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            Integer hourVal = calendrical.get(ISOChronology.hourOfDayRule());
            if (hourVal == null) {
                return null;
            }
            long hour = hourVal.intValue();
            hour = (hour < 0L ? hour + 0x80000010L : hour) % 12L;
            return (int)hour;
        }
    }

    static final class AmPmOfDayRule
    extends DateTimeFieldRule<AmPmOfDay>
    implements Serializable {
        static final DateTimeFieldRule<AmPmOfDay> INSTANCE = new AmPmOfDayRule();
        private static final long serialVersionUID = 1L;

        private AmPmOfDayRule() {
            super(AmPmOfDay.class, INSTANCE, "AmPmOfDay", _12_HOURS, DAYS, 0, 1, true);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected AmPmOfDay derive(Calendrical calendrical) {
            Integer hourVal = calendrical.get(ISOChronology.hourOfDayRule());
            if (hourVal == null) {
                return null;
            }
            int hour = hourVal;
            hour = hour < 0 ? 0x40000008 + hour + 0x40000008 : hour;
            return AmPmOfDay.of(hour % 24 / 12);
        }

        @Override
        public int convertValueToInt(AmPmOfDay value) {
            return value.getValue();
        }

        @Override
        public AmPmOfDay convertIntToValue(int value) {
            return AmPmOfDay.of(value);
        }

        @Override
        protected AmPmOfDay interpret(CalendricalMerger merger, Object value) {
            if (value instanceof Integer) {
                int val = (Integer)value;
                if (val < 0 || val > 1) {
                    int days = val > 0 ? val / 2 : (val + 1) / 2 - 1;
                    merger.addToOverflow(Period.days(days));
                    val = val > 0 ? val % 2 : -(val % 2);
                }
                return AmPmOfDay.of(val);
            }
            return null;
        }

        @Override
        protected void createTextStores(EnumMap<DateTimeFormatterBuilder.TextStyle, DateTimeFieldRule.TextStore> textStores, Locale locale) {
            DateFormatSymbols oldSymbols = new DateFormatSymbols(locale);
            String[] array = oldSymbols.getAmPmStrings();
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            map.put(0, array[0]);
            map.put(1, array[1]);
            DateTimeFieldRule.TextStore textStore = new DateTimeFieldRule.TextStore(locale, map);
            textStores.put(DateTimeFormatterBuilder.TextStyle.FULL, textStore);
            textStores.put(DateTimeFormatterBuilder.TextStyle.SHORT, textStore);
        }
    }

    static final class MilliOfSecondRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new MilliOfSecondRule();
        private static final long serialVersionUID = 1L;

        private MilliOfSecondRule() {
            super(Integer.class, INSTANCE, "MilliOfSecond", MILLIS, SECONDS, 0, 999);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalTime time = calendrical.get(LocalTime.rule());
            return time != null ? Integer.valueOf(time.getNanoOfSecond() / 1000000) : null;
        }
    }

    static final class MilliOfDayRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new MilliOfDayRule();
        private static final long serialVersionUID = 1L;

        private MilliOfDayRule() {
            super(Integer.class, INSTANCE, "MilliOfDay", MILLIS, DAYS, 0, 86399999);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalTime time = calendrical.get(LocalTime.rule());
            return time != null ? Integer.valueOf((int)(time.toNanoOfDay() / 1000000L)) : null;
        }
    }

    static final class SecondOfDayRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new SecondOfDayRule();
        private static final long serialVersionUID = 1L;

        private SecondOfDayRule() {
            super(Integer.class, INSTANCE, "SecondOfDay", SECONDS, DAYS, 0, 86399);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalTime time = calendrical.get(LocalTime.rule());
            return time != null ? Integer.valueOf(time.toSecondOfDay()) : null;
        }
    }

    static final class NanoOfSecondRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new NanoOfSecondRule();
        private static final long serialVersionUID = 1L;

        private NanoOfSecondRule() {
            super(Integer.class, INSTANCE, "NanoOfSecond", NANOS, SECONDS, 0, 999999999);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalTime time = calendrical.get(LocalTime.rule());
            return time != null ? Integer.valueOf(time.getNanoOfSecond()) : null;
        }
    }

    static final class SecondOfMinuteRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new SecondOfMinuteRule();
        private static final long serialVersionUID = 1L;

        private SecondOfMinuteRule() {
            super(Integer.class, INSTANCE, "SecondOfMinute", SECONDS, MINUTES, 0, 59);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalTime time = calendrical.get(LocalTime.rule());
            return time != null ? Integer.valueOf(time.getSecondOfMinute()) : null;
        }
    }

    static final class MinuteOfHourRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new MinuteOfHourRule();
        private static final long serialVersionUID = 1L;

        private MinuteOfHourRule() {
            super(Integer.class, INSTANCE, "MinuteOfHour", MINUTES, HOURS, 0, 59);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalTime time = calendrical.get(LocalTime.rule());
            return time != null ? Integer.valueOf(time.getMinuteOfHour()) : null;
        }
    }

    static final class HourOfDayRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new HourOfDayRule();
        private static final long serialVersionUID = 1L;

        private HourOfDayRule() {
            super(Integer.class, INSTANCE, "HourOfDay", HOURS, DAYS, 0, 23);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalTime time = calendrical.get(LocalTime.rule());
            return time != null ? Integer.valueOf(time.getHourOfDay()) : null;
        }
    }

    static final class WeekOfMonthRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new WeekOfMonthRule();
        private static final long serialVersionUID = 1L;

        private WeekOfMonthRule() {
            super(Integer.class, INSTANCE, "WeekOfMonth", WEEKS, MONTHS, 1, 5);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 4;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer year = calendrical.get(ISOChronology.yearRule());
            MonthOfYear moy = calendrical.get(ISOChronology.monthOfYearRule());
            if (year != null && moy == MonthOfYear.FEBRUARY) {
                return Year.of(year).isLeap() ? 5 : 4;
            }
            return this.getMaximumValue();
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            Integer domVal = calendrical.get(ISOChronology.dayOfMonthRule());
            return domVal != null ? Integer.valueOf((domVal + 6) / 7) : null;
        }
    }

    static final class MonthOfQuarterRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new MonthOfQuarterRule();
        private static final long serialVersionUID = 1L;

        private MonthOfQuarterRule() {
            super(Integer.class, INSTANCE, "MonthOfQuarter", MONTHS, QUARTERS, 1, 3);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            MonthOfYear moy = calendrical.get(ISOChronology.monthOfYearRule());
            return moy != null ? Integer.valueOf(moy.ordinal() % 3 + 1) : null;
        }
    }

    static final class QuarterOfYearRule
    extends DateTimeFieldRule<QuarterOfYear>
    implements Serializable {
        static final DateTimeFieldRule<QuarterOfYear> INSTANCE = new QuarterOfYearRule();
        private static final long serialVersionUID = 1L;

        private QuarterOfYearRule() {
            super(QuarterOfYear.class, INSTANCE, "QuarterOfYear", QUARTERS, YEARS, 1, 4);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected QuarterOfYear derive(Calendrical calendrical) {
            MonthOfYear moy = calendrical.get(ISOChronology.monthOfYearRule());
            return moy != null ? QuarterOfYear.of(moy.ordinal() / 3 + 1) : null;
        }

        @Override
        public int convertValueToInt(QuarterOfYear value) {
            return value.getValue();
        }

        @Override
        public QuarterOfYear convertIntToValue(int value) {
            return QuarterOfYear.of(value);
        }
    }

    static final class WeekOfYearRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new WeekOfYearRule();
        private static final long serialVersionUID = 1L;

        private WeekOfYearRule() {
            super(Integer.class, INSTANCE, "WeekOfYear", WEEKS, YEARS, 1, 53);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            Integer doyVal = calendrical.get(ISOChronology.dayOfYearRule());
            return doyVal != null ? Integer.valueOf((doyVal + 6) / 7) : null;
        }
    }

    static final class DayOfWeekRule
    extends DateTimeFieldRule<DayOfWeek>
    implements Serializable {
        static final DateTimeFieldRule<DayOfWeek> INSTANCE = new DayOfWeekRule();
        private static final long serialVersionUID = 1L;

        private DayOfWeekRule() {
            super(DayOfWeek.class, INSTANCE, "DayOfWeek", DAYS, WEEKS, 1, 7, true);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected DayOfWeek derive(Calendrical calendrical) {
            LocalDate date = calendrical.get(LocalDate.rule());
            return date != null ? ISOChronology.getDayOfWeekFromDate(date) : null;
        }

        @Override
        public int convertValueToInt(DayOfWeek value) {
            return value.getValue();
        }

        @Override
        public DayOfWeek convertIntToValue(int value) {
            return DayOfWeek.of(value);
        }

        @Override
        protected DayOfWeek interpret(CalendricalMerger merger, Object value) {
            if (value instanceof Integer) {
                int val = (Integer)value;
                if (val < 1 || val > 7) {
                    merger.addToOverflow(Period.days(val - 1));
                    val = 1;
                }
                return DayOfWeek.of(val);
            }
            return null;
        }

        @Override
        protected void createTextStores(EnumMap<DateTimeFormatterBuilder.TextStyle, DateTimeFieldRule.TextStore> textStores, Locale locale) {
            DateFormatSymbols oldSymbols = new DateFormatSymbols(locale);
            String[] array = oldSymbols.getWeekdays();
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            map.put(1, array[2]);
            map.put(2, array[3]);
            map.put(3, array[4]);
            map.put(4, array[5]);
            map.put(5, array[6]);
            map.put(6, array[7]);
            map.put(7, array[1]);
            textStores.put(DateTimeFormatterBuilder.TextStyle.FULL, new DateTimeFieldRule.TextStore(locale, map));
            array = oldSymbols.getShortWeekdays();
            map.clear();
            map.put(1, array[2]);
            map.put(2, array[3]);
            map.put(3, array[4]);
            map.put(4, array[5]);
            map.put(5, array[6]);
            map.put(6, array[7]);
            map.put(7, array[1]);
            textStores.put(DateTimeFormatterBuilder.TextStyle.SHORT, new DateTimeFieldRule.TextStore(locale, map));
        }
    }

    static final class WeekOfWeekBasedYearRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new WeekOfWeekBasedYearRule();
        private static final long serialVersionUID = 1L;

        private WeekOfWeekBasedYearRule() {
            super(Integer.class, INSTANCE, "WeekOfWeekBasedYear", WEEKS, WEEK_BASED_YEARS, 1, 53);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 52;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            LocalDate date = calendrical.get(LocalDate.rule());
            if (date == null) {
                return 53;
            }
            if ((date = date.withDayOfMonth(1).withMonthOfYear(1)).getDayOfWeek() == DayOfWeek.THURSDAY || date.getDayOfWeek() == DayOfWeek.WEDNESDAY && ISOChronology.isLeapYear(date.getYear())) {
                return 53;
            }
            return 52;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalDate date = calendrical.get(LocalDate.rule());
            return date != null ? Integer.valueOf(ISOChronology.getWeekOfWeekBasedYearFromDate(date)) : null;
        }
    }

    static final class WeekBasedYearRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new WeekBasedYearRule();
        private static final long serialVersionUID = 1L;

        private WeekBasedYearRule() {
            super(Integer.class, INSTANCE, "WeekBasedYear", WEEK_BASED_YEARS, null, -2147483646, Integer.MAX_VALUE);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalDate date = calendrical.get(LocalDate.rule());
            return date != null ? Integer.valueOf(ISOChronology.getWeekBasedYearFromDate(date)) : null;
        }
    }

    static final class DayOfYearRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new DayOfYearRule();
        private static final long serialVersionUID = 1L;

        private DayOfYearRule() {
            super(Integer.class, INSTANCE, "DayOfYear", DAYS, YEARS, 1, 366);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 365;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer year = calendrical.get(ISOChronology.yearRule());
            return year != null && !ISOChronology.isLeapYear(year) ? 365 : 366;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalDate date = calendrical.get(LocalDate.rule());
            return date != null ? Integer.valueOf(ISOChronology.getDayOfYearFromDate(date)) : null;
        }
    }

    static final class DayOfMonthRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new DayOfMonthRule();
        private static final long serialVersionUID = 1L;

        private DayOfMonthRule() {
            super(Integer.class, INSTANCE, "DayOfMonth", DAYS, MONTHS, 1, 31);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 28;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            MonthOfYear moy = calendrical.get(ISOChronology.monthOfYearRule());
            if (moy == null) {
                return 31;
            }
            Integer year = calendrical.get(ISOChronology.yearRule());
            return year != null ? moy.lengthInDays(ISOChronology.isLeapYear(year)) : moy.maxLengthInDays();
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalDate date = calendrical.get(LocalDate.rule());
            return date != null ? Integer.valueOf(date.getDayOfMonth()) : null;
        }
    }

    static final class MonthOfYearRule
    extends DateTimeFieldRule<MonthOfYear>
    implements Serializable {
        static final DateTimeFieldRule<MonthOfYear> INSTANCE = new MonthOfYearRule();
        private static final long serialVersionUID = 1L;

        private MonthOfYearRule() {
            super(MonthOfYear.class, INSTANCE, "MonthOfYear", MONTHS, YEARS, 1, 12, true);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected MonthOfYear derive(Calendrical calendrical) {
            LocalDate date = calendrical.get(LocalDate.rule());
            return date != null ? date.getMonthOfYear() : null;
        }

        @Override
        public int convertValueToInt(MonthOfYear value) {
            return value.getValue();
        }

        @Override
        public MonthOfYear convertIntToValue(int value) {
            return MonthOfYear.of(value);
        }

        @Override
        protected MonthOfYear interpret(CalendricalMerger merger, Object value) {
            if (value instanceof Integer) {
                int val = (Integer)value;
                if (val < 1 || val > 12) {
                    merger.addToOverflow(Period.months(val - 1));
                    val = 1;
                }
                return MonthOfYear.of(val);
            }
            return null;
        }

        @Override
        protected void createTextStores(EnumMap<DateTimeFormatterBuilder.TextStyle, DateTimeFieldRule.TextStore> textStores, Locale locale) {
            DateFormatSymbols oldSymbols = new DateFormatSymbols(locale);
            String[] array = oldSymbols.getMonths();
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            map.put(1, array[0]);
            map.put(2, array[1]);
            map.put(3, array[2]);
            map.put(4, array[3]);
            map.put(5, array[4]);
            map.put(6, array[5]);
            map.put(7, array[6]);
            map.put(8, array[7]);
            map.put(9, array[8]);
            map.put(10, array[9]);
            map.put(11, array[10]);
            map.put(12, array[11]);
            textStores.put(DateTimeFormatterBuilder.TextStyle.FULL, new DateTimeFieldRule.TextStore(locale, map));
            array = oldSymbols.getShortMonths();
            map.clear();
            map.put(1, array[0]);
            map.put(2, array[1]);
            map.put(3, array[2]);
            map.put(4, array[3]);
            map.put(5, array[4]);
            map.put(6, array[5]);
            map.put(7, array[6]);
            map.put(8, array[7]);
            map.put(9, array[8]);
            map.put(10, array[9]);
            map.put(11, array[10]);
            map.put(12, array[11]);
            textStores.put(DateTimeFormatterBuilder.TextStyle.SHORT, new DateTimeFieldRule.TextStore(locale, map));
        }
    }

    static final class YearRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        static final DateTimeFieldRule<Integer> INSTANCE = new YearRule();
        private static final long serialVersionUID = 1L;

        private YearRule() {
            super(Integer.class, INSTANCE, "Year", YEARS, null, -2147483646, Integer.MAX_VALUE);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            LocalDate date = calendrical.get(LocalDate.rule());
            return date != null ? Integer.valueOf(date.getYear()) : null;
        }
    }
}

