/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.util.Locale;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.QuarterOfYear;
import javax.time.calendar.format.DateTimeFormatterBuilder;

public enum MonthOfYear {
    JANUARY,
    FEBRUARY,
    MARCH,
    APRIL,
    MAY,
    JUNE,
    JULY,
    AUGUST,
    SEPTEMBER,
    OCTOBER,
    NOVEMBER,
    DECEMBER;


    public static MonthOfYear of(int monthOfYear) {
        switch (monthOfYear) {
            case 1: {
                return JANUARY;
            }
            case 2: {
                return FEBRUARY;
            }
            case 3: {
                return MARCH;
            }
            case 4: {
                return APRIL;
            }
            case 5: {
                return MAY;
            }
            case 6: {
                return JUNE;
            }
            case 7: {
                return JULY;
            }
            case 8: {
                return AUGUST;
            }
            case 9: {
                return SEPTEMBER;
            }
            case 10: {
                return OCTOBER;
            }
            case 11: {
                return NOVEMBER;
            }
            case 12: {
                return DECEMBER;
            }
        }
        throw new IllegalCalendarFieldValueException(ISOChronology.monthOfYearRule(), monthOfYear, 1, 12);
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getShortText(Locale locale) {
        return ISOChronology.monthOfYearRule().getText(this.getValue(), locale, DateTimeFormatterBuilder.TextStyle.SHORT);
    }

    public String getText(Locale locale) {
        return ISOChronology.monthOfYearRule().getText(this.getValue(), locale, DateTimeFormatterBuilder.TextStyle.FULL);
    }

    public boolean isJanuary() {
        return this == JANUARY;
    }

    public boolean isFebruary() {
        return this == FEBRUARY;
    }

    public boolean isMarch() {
        return this == MARCH;
    }

    public boolean isApril() {
        return this == APRIL;
    }

    public boolean isMay() {
        return this == MAY;
    }

    public boolean isJune() {
        return this == JUNE;
    }

    public boolean isJuly() {
        return this == JULY;
    }

    public boolean isAugust() {
        return this == AUGUST;
    }

    public boolean isSeptember() {
        return this == SEPTEMBER;
    }

    public boolean isOctober() {
        return this == OCTOBER;
    }

    public boolean isNovember() {
        return this == NOVEMBER;
    }

    public boolean isDecember() {
        return this == DECEMBER;
    }

    public MonthOfYear next() {
        return MonthOfYear.values()[(this.ordinal() + 1) % 12];
    }

    public MonthOfYear previous() {
        return MonthOfYear.values()[(this.ordinal() + 12 - 1) % 12];
    }

    public MonthOfYear roll(int months) {
        return MonthOfYear.values()[(this.ordinal() + (months % 12 + 12)) % 12];
    }

    public int lengthInDays(boolean leapYear) {
        switch (this) {
            case FEBRUARY: {
                return leapYear ? 29 : 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int minLengthInDays() {
        switch (this) {
            case FEBRUARY: {
                return 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int maxLengthInDays() {
        switch (this) {
            case FEBRUARY: {
                return 29;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int getLastDayOfMonth(boolean leapYear) {
        return this.lengthInDays(leapYear);
    }

    public QuarterOfYear getQuarterOfYear() {
        if (this.ordinal() < 3) {
            return QuarterOfYear.Q1;
        }
        if (this.ordinal() < 6) {
            return QuarterOfYear.Q2;
        }
        if (this.ordinal() < 9) {
            return QuarterOfYear.Q3;
        }
        return QuarterOfYear.Q4;
    }

    public int getMonthOfQuarter() {
        return this.ordinal() % 3 + 1;
    }
}

