/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.Year;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZoneResolvers;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.PeriodProvider;

public final class OffsetDate
implements Calendrical,
DateProvider,
CalendricalMatcher,
DateAdjuster,
Comparable<OffsetDate>,
Serializable {
    private static final long serialVersionUID = -3618963189L;
    private final LocalDate date;
    private final ZoneOffset offset;

    public static OffsetDate of(int year, MonthOfYear monthOfYear, int dayOfMonth, ZoneOffset offset) {
        LocalDate date = LocalDate.of(year, monthOfYear, dayOfMonth);
        return new OffsetDate(date, offset);
    }

    public static OffsetDate of(int year, int monthOfYear, int dayOfMonth, ZoneOffset offset) {
        LocalDate date = LocalDate.of(year, monthOfYear, dayOfMonth);
        return new OffsetDate(date, offset);
    }

    public static OffsetDate from(DateProvider dateProvider, ZoneOffset offset) {
        LocalDate date = LocalDate.from(dateProvider);
        return new OffsetDate(date, offset);
    }

    public static OffsetDate fromInstant(InstantProvider instantProvider, ZoneOffset offset) {
        Instant instant = Instant.from(instantProvider);
        ISOChronology.checkNotNull(offset, "ZoneOffset must not be null");
        long epochSecs = instant.getEpochSeconds() + (long)offset.getAmountSeconds();
        long yearZeroDays = epochSecs / 86400L + 719528L;
        long secsOfDay = epochSecs % 86400L;
        if (secsOfDay < 0L) {
            --yearZeroDays;
        }
        LocalDate date = LocalDate.fromYearZeroDays(yearZeroDays);
        return new OffsetDate(date, offset);
    }

    public static OffsetDate parse(String text) {
        return DateTimeFormatters.isoOffsetDate().parse(text, OffsetDate.rule());
    }

    private OffsetDate(LocalDate date, ZoneOffset offset) {
        if (date == null) {
            throw new NullPointerException("The date must not be null");
        }
        if (offset == null) {
            throw new NullPointerException("The zone offset must not be null");
        }
        this.date = date;
        this.offset = offset;
    }

    private OffsetDate with(LocalDate date, ZoneOffset offset) {
        if (this.date == date && this.offset.equals(offset)) {
            return this;
        }
        return new OffsetDate(date, offset);
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        return OffsetDate.rule().deriveValueFor(rule, this, this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetDate withOffset(ZoneOffset offset) {
        ISOChronology.checkNotNull(offset, "ZoneOffset must not be null");
        return this.with(this.date, offset);
    }

    public int getYear() {
        return this.date.getYear();
    }

    public MonthOfYear getMonthOfYear() {
        return this.date.getMonthOfYear();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.date.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    public OffsetDate with(DateAdjuster adjuster) {
        return this.with(this.date.with(adjuster), this.offset);
    }

    public OffsetDate withDate(DateProvider dateProvider) {
        LocalDate newDate = LocalDate.from(dateProvider);
        if (newDate.equals(this.date)) {
            return this;
        }
        return this.with(newDate, this.offset);
    }

    public OffsetDate withYear(int year) {
        return this.with(this.date.withYear(year), this.offset);
    }

    public OffsetDate withYear(int year, DateResolver dateResolver) {
        return this.with(this.date.withYear(year, dateResolver), this.offset);
    }

    public OffsetDate withMonthOfYear(int monthOfYear) {
        return this.with(this.date.withMonthOfYear(monthOfYear), this.offset);
    }

    public OffsetDate withMonthOfYear(int monthOfYear, DateResolver dateResolver) {
        return this.with(this.date.withMonthOfYear(monthOfYear, dateResolver), this.offset);
    }

    public OffsetDate with(MonthOfYear monthOfYear) {
        return this.with(this.date.with(monthOfYear), this.offset);
    }

    public OffsetDate with(MonthOfYear monthOfYear, DateResolver dateResolver) {
        return this.with(this.date.with(monthOfYear, dateResolver), this.offset);
    }

    public OffsetDate withDayOfMonth(int dayOfMonth) {
        return this.with(this.date.withDayOfMonth(dayOfMonth), this.offset);
    }

    public OffsetDate withDayOfMonth(int dayOfMonth, DateResolver dateResolver) {
        return this.with(this.date.withDayOfMonth(dayOfMonth, dateResolver), this.offset);
    }

    public OffsetDate withDayOfYear(int dayOfYear) {
        return this.with(this.date.withDayOfYear(dayOfYear), this.offset);
    }

    public OffsetDate plus(PeriodProvider periodProvider) {
        return this.with(this.date.plus(periodProvider), this.offset);
    }

    public OffsetDate plusYears(int years) {
        return this.with(this.date.plusYears(years), this.offset);
    }

    public OffsetDate plusYears(int years, DateResolver dateResolver) {
        return this.with(this.date.plusYears(years, dateResolver), this.offset);
    }

    public OffsetDate plusMonths(int months) {
        return this.with(this.date.plusMonths(months), this.offset);
    }

    public OffsetDate plusMonths(int months, DateResolver dateResolver) {
        return this.with(this.date.plusMonths(months, dateResolver), this.offset);
    }

    public OffsetDate plusWeeks(int weeks) {
        return this.with(this.date.plusWeeks(weeks), this.offset);
    }

    public OffsetDate plusDays(long days) {
        return this.with(this.date.plusDays(days), this.offset);
    }

    public OffsetDate minus(PeriodProvider periodProvider) {
        return this.with(this.date.minus(periodProvider), this.offset);
    }

    public OffsetDate minusYears(int years) {
        return this.with(this.date.minusYears(years), this.offset);
    }

    public OffsetDate minusYears(int years, DateResolver dateResolver) {
        return this.with(this.date.minusYears(years, dateResolver), this.offset);
    }

    public OffsetDate minusMonths(int months) {
        return this.with(this.date.minusMonths(months), this.offset);
    }

    public OffsetDate minusMonths(int months, DateResolver dateResolver) {
        return this.with(this.date.minusMonths(months, dateResolver), this.offset);
    }

    public OffsetDate minusWeeks(int weeks) {
        return this.with(this.date.minusWeeks(weeks), this.offset);
    }

    public OffsetDate minusDays(long days) {
        return this.with(this.date.minusDays(days), this.offset);
    }

    public boolean matches(CalendricalMatcher matcher) {
        return matcher.matchesCalendrical(this);
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        return this.equals(calendrical.get(OffsetDate.rule()));
    }

    @Override
    public LocalDate adjustDate(LocalDate date) {
        return this.date.adjustDate(date);
    }

    public OffsetDateTime atTime(LocalTime time) {
        return OffsetDateTime.from(this, time, this.getOffset());
    }

    public OffsetDateTime atMidnight() {
        return OffsetDateTime.from(this, LocalTime.MIDNIGHT, this.getOffset());
    }

    public ZonedDateTime atStartOfDayInZone(TimeZone zone) {
        return ZonedDateTime.from(this, LocalTime.MIDNIGHT, zone, ZoneResolvers.postGapPreOverlap());
    }

    @Override
    public LocalDate toLocalDate() {
        return this.date;
    }

    public Year toYear() {
        return this.date.toYear();
    }

    @Override
    public int compareTo(OffsetDate other) {
        LocalDateTime otherUTC;
        if (this.offset.equals(other.offset)) {
            return this.date.compareTo(other.date);
        }
        LocalDateTime thisDT = LocalDateTime.midnight(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth());
        LocalDateTime otherDT = LocalDateTime.midnight(other.getYear(), other.getMonthOfYear(), other.getDayOfMonth());
        LocalDateTime thisUTC = thisDT.plusSeconds(-this.offset.getAmountSeconds());
        int compare = thisUTC.compareTo(otherUTC = otherDT.plusSeconds(-other.offset.getAmountSeconds()));
        if (compare == 0) {
            compare = this.date.compareTo(other.date);
        }
        return compare;
    }

    public boolean isAfter(OffsetDate other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(OffsetDate other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof OffsetDate) {
            OffsetDate zonedDate = (OffsetDate)other;
            return this.date.equals(zonedDate.date) && this.offset.equals(zonedDate.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.date.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.date.toString() + this.offset.toString();
    }

    public static CalendricalRule<OffsetDate> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<OffsetDate>
    implements Serializable {
        private static final CalendricalRule<OffsetDate> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(OffsetDate.class, ISOChronology.INSTANCE, "OffsetDate", ISOChronology.periodDays(), null);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected OffsetDate derive(Calendrical calendrical) {
            OffsetDateTime odt = calendrical.get(OffsetDateTime.rule());
            return odt != null ? odt.toOffsetDate() : null;
        }
    }
}

