/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.time.Duration;
import javax.time.calendar.ISOChronology;
import javax.time.period.PeriodField;

public abstract class PeriodUnit
implements Comparable<PeriodUnit>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final transient String name;
    private final transient Duration estimatedDuration;
    private final transient List<PeriodField> equivalentPeriods;
    private final transient int hashCode;

    protected PeriodUnit(String name, Duration estimatedDuration) {
        ISOChronology.checkNotNull(name, "Name must not be null");
        ISOChronology.checkNotNull(estimatedDuration, "Estimated duration must not be null");
        if (estimatedDuration.isNegative() || estimatedDuration.isZero()) {
            throw new IllegalArgumentException("Alternate period must not be negative or zero");
        }
        this.name = name;
        this.estimatedDuration = estimatedDuration;
        this.equivalentPeriods = PeriodUnit.buildEquivalentPeriods(null);
        this.hashCode = name.hashCode() ^ estimatedDuration.hashCode() ^ 0;
    }

    protected PeriodUnit(String name, PeriodField equivalentPeriod) {
        ISOChronology.checkNotNull(name, "Name must not be null");
        ISOChronology.checkNotNull(equivalentPeriod, "Equivalent period must not be null");
        if (equivalentPeriod.isNegative() || equivalentPeriod.isZero()) {
            throw new IllegalArgumentException("Equivalent period must not be negative or zero");
        }
        this.name = name;
        this.estimatedDuration = equivalentPeriod.toEstimatedDuration();
        this.equivalentPeriods = PeriodUnit.buildEquivalentPeriods(equivalentPeriod);
        this.hashCode = name.hashCode() ^ this.estimatedDuration.hashCode() ^ equivalentPeriod.hashCode();
    }

    PeriodUnit(String name, PeriodField equivalentPeriod, Duration estimatedDuration) {
        this.name = name;
        this.estimatedDuration = estimatedDuration;
        this.equivalentPeriods = PeriodUnit.buildEquivalentPeriods(equivalentPeriod);
        this.hashCode = name.hashCode() ^ estimatedDuration.hashCode() ^ (equivalentPeriod != null ? equivalentPeriod.hashCode() : 0);
    }

    private static List<PeriodField> buildEquivalentPeriods(PeriodField equivalentPeriod) {
        if (equivalentPeriod == null) {
            return Collections.emptyList();
        }
        ArrayList<PeriodField> equivalents = new ArrayList<PeriodField>();
        equivalents.add(equivalentPeriod);
        long multiplier = equivalentPeriod.getAmount();
        List<PeriodField> baseEquivalents = equivalentPeriod.getUnit().getEquivalentPeriods();
        for (int i = 0; i < baseEquivalents.size(); ++i) {
            equivalents.add(baseEquivalents.get(i).multipliedBy(multiplier));
        }
        return Collections.unmodifiableList(equivalents);
    }

    public String getName() {
        return this.name;
    }

    public List<PeriodField> getEquivalentPeriods() {
        return this.equivalentPeriods;
    }

    public PeriodField getEquivalentPeriod(PeriodUnit requiredUnit) {
        for (PeriodField equivalent : this.equivalentPeriods) {
            if (!equivalent.getUnit().equals(requiredUnit)) continue;
            return equivalent;
        }
        if (requiredUnit.equals(this)) {
            return PeriodField.of(1L, this);
        }
        return null;
    }

    public Duration getEstimatedDuration() {
        return this.estimatedDuration;
    }

    @Override
    public int compareTo(PeriodUnit other) {
        int cmp = this.estimatedDuration.compareTo(other.estimatedDuration);
        if (cmp == 0 && (cmp = this.name.compareTo(other.name)) == 0 && (cmp = this.equivalentPeriods.size() - other.equivalentPeriods.size()) == 0 && this.equivalentPeriods.size() > 0) {
            cmp = this.equivalentPeriods.get(0).compareTo(other.equivalentPeriods.get(0));
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PeriodUnit) {
            PeriodUnit other = (PeriodUnit)obj;
            return this.name.equals(other.name) && this.estimatedDuration.equals(other.estimatedDuration) && this.equivalentPeriods.size() == other.equivalentPeriods.size() && (this.equivalentPeriods.size() == 0 || this.equivalentPeriods.get(0).equals(other.equivalentPeriods.get(0)));
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }
}

