/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateResolvers;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.Year;
import javax.time.calendar.format.DateTimeFormatter;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class YearMonth
implements Calendrical,
CalendricalMatcher,
DateAdjuster,
Comparable<YearMonth>,
Serializable {
    private static final long serialVersionUID = 1507289123L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendValue(ISOChronology.yearRule(), 4, 10, DateTimeFormatterBuilder.SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ISOChronology.monthOfYearRule(), 2).toFormatter();
    private final int year;
    private final MonthOfYear month;

    public static YearMonth of(int year, MonthOfYear monthOfYear) {
        ISOChronology.yearRule().checkValue(year);
        ISOChronology.checkNotNull((Object)monthOfYear, "MonthOfYear must not be null");
        return new YearMonth(year, monthOfYear);
    }

    public static YearMonth of(int year, int monthOfYear) {
        return YearMonth.of(year, MonthOfYear.of(monthOfYear));
    }

    public static YearMonth from(Calendrical calendrical) {
        Integer year = (Integer)ISOChronology.yearRule().getValueChecked(calendrical);
        MonthOfYear month = (MonthOfYear)((Object)ISOChronology.monthOfYearRule().getValueChecked(calendrical));
        return YearMonth.of((int)year, month);
    }

    public static YearMonth parse(String text) {
        return PARSER.parse(text, YearMonth.rule());
    }

    private YearMonth(int year, MonthOfYear monthOfYear) {
        this.year = year;
        this.month = monthOfYear;
    }

    private YearMonth with(int newYear, MonthOfYear newMonth) {
        if (this.year == newYear && this.month == newMonth) {
            return this;
        }
        return new YearMonth(newYear, newMonth);
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        ISOChronology.checkNotNull(rule, "CalendricalRule must not be null");
        if (rule.equals(ISOChronology.yearRule())) {
            return rule.reify(this.year);
        }
        if (rule.equals(ISOChronology.monthOfYearRule())) {
            return rule.reify((Object)this.month);
        }
        return YearMonth.rule().deriveValueFor(rule, this, this);
    }

    public int getYear() {
        return this.year;
    }

    public MonthOfYear getMonthOfYear() {
        return this.month;
    }

    public YearMonth with(Year year) {
        ISOChronology.checkNotNull(year, "Year must not be null");
        return this.withYear(year.getValue());
    }

    public YearMonth with(MonthOfYear monthOfYear) {
        ISOChronology.checkNotNull((Object)monthOfYear, "MonthOfYear must not be null");
        return this.with(this.year, monthOfYear);
    }

    public YearMonth withYear(int year) {
        ISOChronology.yearRule().checkValue(year);
        return this.with(year, this.month);
    }

    public YearMonth withMonthOfYear(int monthOfYear) {
        return this.with(MonthOfYear.of(monthOfYear));
    }

    public YearMonth plus(PeriodProvider periodProvider) {
        Period period = Period.from(periodProvider);
        return this.plusYears(period.getYears()).plusMonths(period.getMonths());
    }

    public YearMonth plusYears(int years) {
        if (years == 0) {
            return this;
        }
        int newYear = ISOChronology.addYears(this.year, years);
        return this.with(newYear, this.month);
    }

    public YearMonth plusMonths(int months) {
        if (months == 0) {
            return this;
        }
        long newMonth0 = this.month.getValue() - 1;
        int years = (int)((newMonth0 += (long)months) / 12L);
        if ((newMonth0 %= 12L) < 0L) {
            newMonth0 += 12L;
            --years;
        }
        int newYear = ISOChronology.addYears(this.year, years);
        MonthOfYear newMonth = MonthOfYear.of((int)(++newMonth0));
        return this.with(newYear, newMonth);
    }

    public YearMonth minus(PeriodProvider periodProvider) {
        Period period = Period.from(periodProvider);
        return this.minusYears(period.getYears()).minusMonths(period.getMonths());
    }

    public YearMonth minusYears(int years) {
        if (years == 0) {
            return this;
        }
        int newYear = ISOChronology.subtractYears(this.year, years);
        return this.with(newYear, this.month);
    }

    public YearMonth minusMonths(int months) {
        if (months == 0) {
            return this;
        }
        long newMonth0 = this.month.getValue() - 1;
        int years = (int)((newMonth0 -= (long)months) / 12L);
        if ((newMonth0 %= 12L) < 0L) {
            newMonth0 += 12L;
            --years;
        }
        int newYear = ISOChronology.subtractYears(this.year, -years);
        MonthOfYear newMonth = MonthOfYear.of((int)(++newMonth0));
        return this.with(newYear, newMonth);
    }

    public YearMonth rollMonthOfYear(int months) {
        return this.with(this.month.roll(months));
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        return this.equals(calendrical.get(YearMonth.rule()));
    }

    @Override
    public LocalDate adjustDate(LocalDate date) {
        return this.adjustDate(date, DateResolvers.previousValid());
    }

    public LocalDate adjustDate(LocalDate date, DateResolver resolver) {
        ISOChronology.checkNotNull(date, "LocalDate must not be null");
        ISOChronology.checkNotNull(resolver, "DateResolver must not be null");
        if (date.getYear() == this.year && date.getMonthOfYear() == this.month) {
            return date;
        }
        LocalDate resolved = resolver.resolveDate(this.year, this.month, date.getDayOfMonth());
        ISOChronology.checkNotNull(resolved, "The implementation of DateResolver must not return null");
        return resolved;
    }

    public int lengthInDays() {
        return this.month.lengthInDays(ISOChronology.isLeapYear(this.year));
    }

    public boolean isValidDay(int dayOfMonth) {
        return dayOfMonth >= 1 && dayOfMonth <= this.lengthInDays();
    }

    public LocalDate atDay(int dayOfMonth) {
        return LocalDate.of(this.year, this.month, dayOfMonth);
    }

    public Year toYear() {
        return Year.of(this.year);
    }

    @Override
    public int compareTo(YearMonth other) {
        int cmp = MathUtils.safeCompare(this.year, other.year);
        if (cmp == 0) {
            cmp = this.month.compareTo(other.month);
        }
        return cmp;
    }

    public boolean isAfter(YearMonth other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(YearMonth other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof YearMonth) {
            YearMonth otherYM = (YearMonth)other;
            return this.year == otherYM.year && this.month == otherYM.month;
        }
        return false;
    }

    public int hashCode() {
        return this.year ^ this.month.getValue() << 27;
    }

    public String toString() {
        int yearValue = this.year;
        int monthValue = this.month.getValue();
        int absYear = Math.abs(yearValue);
        StringBuilder buf = new StringBuilder(9);
        if (absYear < 1000) {
            if (yearValue < 0) {
                buf.append(yearValue - 10000).deleteCharAt(1);
            } else {
                buf.append(yearValue + 10000).deleteCharAt(0);
            }
        } else {
            buf.append(yearValue);
        }
        return buf.append(monthValue < 10 ? "-0" : "-").append(monthValue).toString();
    }

    public static CalendricalRule<YearMonth> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<YearMonth>
    implements Serializable {
        private static final CalendricalRule<YearMonth> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(YearMonth.class, ISOChronology.INSTANCE, "YearMonth", ISOChronology.periodMonths(), null);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected YearMonth derive(Calendrical calendrical) {
            Integer year = calendrical.get(ISOChronology.yearRule());
            MonthOfYear moy = calendrical.get(ISOChronology.monthOfYearRule());
            return year != null && moy != null ? YearMonth.of((int)year, moy) : null;
        }
    }
}

