/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.util.Locale;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.format.DateTimeFormatter;
import javax.time.calendar.format.DateTimeFormatterBuilder;

public final class DateTimeFormatters {
    private static final DateTimeFormatter ISO_LOCAL_DATE = new DateTimeFormatterBuilder().appendValue(ISOChronology.yearRule(), 4, 10, DateTimeFormatterBuilder.SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ISOChronology.monthOfYearRule(), 2).appendLiteral('-').appendValue(ISOChronology.dayOfMonthRule(), 2).toFormatter();
    private static final DateTimeFormatter ISO_OFFSET_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE).appendOffsetId().toFormatter();
    private static final DateTimeFormatter ISO_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').appendZoneId().appendLiteral(']').toFormatter();
    private static final DateTimeFormatter ISO_LOCAL_TIME = new DateTimeFormatterBuilder().appendValue(ISOChronology.hourOfDayRule(), 2).appendLiteral(':').appendValue(ISOChronology.minuteOfHourRule(), 2).optionalStart().appendLiteral(':').appendValue(ISOChronology.secondOfMinuteRule(), 2).optionalStart().appendFraction(ISOChronology.nanoOfSecondRule(), 0, 9).toFormatter();
    private static final DateTimeFormatter ISO_OFFSET_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_TIME).appendOffsetId().toFormatter();
    private static final DateTimeFormatter ISO_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_TIME).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').appendZoneId().appendLiteral(']').toFormatter();
    private static final DateTimeFormatter ISO_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE).appendLiteral('T').append(ISO_LOCAL_TIME).toFormatter();
    private static final DateTimeFormatter ISO_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().append(ISO_LOCAL_DATE_TIME).appendOffsetId().toFormatter();
    private static final DateTimeFormatter ISO_ZONED_DATE_TIME = new DateTimeFormatterBuilder().append(ISO_LOCAL_DATE_TIME).appendOffsetId().appendLiteral('[').appendZoneId().appendLiteral(']').toFormatter();
    private static final DateTimeFormatter ISO_DATE_TIME = new DateTimeFormatterBuilder().append(ISO_LOCAL_DATE_TIME).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').appendZoneId().appendLiteral(']').toFormatter();
    private static final DateTimeFormatter ISO_ORDINAL_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ISOChronology.yearRule(), 4, 10, DateTimeFormatterBuilder.SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ISOChronology.dayOfYearRule(), 3).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').appendZoneId().appendLiteral(']').toFormatter();
    private static final DateTimeFormatter ISO_WEEK_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ISOChronology.weekBasedYearRule(), 4, 10, DateTimeFormatterBuilder.SignStyle.EXCEEDS_PAD).appendLiteral("-W").appendValue(ISOChronology.weekOfWeekBasedYearRule(), 2).appendLiteral('-').appendValue(ISOChronology.dayOfWeekRule(), 1).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').appendZoneId().appendLiteral(']').toFormatter();
    private static final DateTimeFormatter BASIC_ISO_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ISOChronology.yearRule(), 4).appendValue(ISOChronology.monthOfYearRule(), 2).appendValue(ISOChronology.dayOfMonthRule(), 2).optionalStart().appendOffset("Z", false, false).optionalStart().appendLiteral('[').appendZoneId().appendLiteral(']').toFormatter();
    private static final DateTimeFormatter RFC_1123_DATE_TIME = new DateTimeFormatterBuilder().appendText(ISOChronology.dayOfWeekRule(), DateTimeFormatterBuilder.TextStyle.SHORT).appendLiteral(", ").appendValue(ISOChronology.dayOfMonthRule(), 2).appendLiteral(' ').appendText(ISOChronology.monthOfYearRule(), DateTimeFormatterBuilder.TextStyle.SHORT).appendLiteral(' ').appendValue(ISOChronology.yearRule(), 4, 4, DateTimeFormatterBuilder.SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendValue(ISOChronology.hourOfDayRule(), 2).appendLiteral(':').appendValue(ISOChronology.minuteOfHourRule(), 2).appendLiteral(':').appendValue(ISOChronology.secondOfMinuteRule(), 2).appendLiteral(' ').appendOffset("Z", false, false).toFormatter().withLocale(Locale.ENGLISH);

    private DateTimeFormatters() {
    }

    public static DateTimeFormatter isoLocalDate() {
        return ISO_LOCAL_DATE;
    }

    public static DateTimeFormatter isoOffsetDate() {
        return ISO_OFFSET_DATE;
    }

    public static DateTimeFormatter isoDate() {
        return ISO_DATE;
    }

    public static DateTimeFormatter isoLocalTime() {
        return ISO_LOCAL_TIME;
    }

    public static DateTimeFormatter isoOffsetTime() {
        return ISO_OFFSET_TIME;
    }

    public static DateTimeFormatter isoTime() {
        return ISO_TIME;
    }

    public static DateTimeFormatter isoLocalDateTime() {
        return ISO_LOCAL_DATE_TIME;
    }

    public static DateTimeFormatter isoOffsetDateTime() {
        return ISO_OFFSET_DATE_TIME;
    }

    public static DateTimeFormatter isoZonedDateTime() {
        return ISO_ZONED_DATE_TIME;
    }

    public static DateTimeFormatter isoDateTime() {
        return ISO_DATE_TIME;
    }

    public static DateTimeFormatter isoOrdinalDate() {
        return ISO_ORDINAL_DATE;
    }

    public static DateTimeFormatter isoWeekDate() {
        return ISO_WEEK_DATE;
    }

    public static DateTimeFormatter basicIsoDate() {
        return BASIC_ISO_DATE;
    }

    public static DateTimeFormatter rfc1123() {
        return RFC_1123_DATE_TIME;
    }

    public static DateTimeFormatter fullDate(Locale locale) {
        return DateTimeFormatters.date(DateTimeFormatterBuilder.FormatStyle.FULL, locale);
    }

    public static DateTimeFormatter longDate(Locale locale) {
        return DateTimeFormatters.date(DateTimeFormatterBuilder.FormatStyle.LONG, locale);
    }

    public static DateTimeFormatter mediumDate(Locale locale) {
        return DateTimeFormatters.date(DateTimeFormatterBuilder.FormatStyle.MEDIUM, locale);
    }

    public static DateTimeFormatter shortDate(Locale locale) {
        return DateTimeFormatters.date(DateTimeFormatterBuilder.FormatStyle.SHORT, locale);
    }

    public static DateTimeFormatter date(DateTimeFormatterBuilder.FormatStyle dateStyle, Locale locale) {
        DateTimeFormatter.checkNotNull((Object)dateStyle, "Date style must not be null");
        return new DateTimeFormatterBuilder().appendLocalized(dateStyle, null).toFormatter(locale);
    }

    public static DateTimeFormatter fullTime(Locale locale) {
        return DateTimeFormatters.time(DateTimeFormatterBuilder.FormatStyle.FULL, locale);
    }

    public static DateTimeFormatter longTime(Locale locale) {
        return DateTimeFormatters.time(DateTimeFormatterBuilder.FormatStyle.LONG, locale);
    }

    public static DateTimeFormatter mediumTime(Locale locale) {
        return DateTimeFormatters.time(DateTimeFormatterBuilder.FormatStyle.MEDIUM, locale);
    }

    public static DateTimeFormatter shortTime(Locale locale) {
        return DateTimeFormatters.time(DateTimeFormatterBuilder.FormatStyle.SHORT, locale);
    }

    public static DateTimeFormatter time(DateTimeFormatterBuilder.FormatStyle timeStyle, Locale locale) {
        DateTimeFormatter.checkNotNull((Object)timeStyle, "Time style must not be null");
        return new DateTimeFormatterBuilder().appendLocalized(null, timeStyle).toFormatter(locale);
    }

    public static DateTimeFormatter fullDateTime(Locale locale) {
        return DateTimeFormatters.dateTime(DateTimeFormatterBuilder.FormatStyle.FULL, locale);
    }

    public static DateTimeFormatter longDateTime(Locale locale) {
        return DateTimeFormatters.dateTime(DateTimeFormatterBuilder.FormatStyle.LONG, locale);
    }

    public static DateTimeFormatter mediumDateTime(Locale locale) {
        return DateTimeFormatters.dateTime(DateTimeFormatterBuilder.FormatStyle.MEDIUM, locale);
    }

    public static DateTimeFormatter shortDateTime(Locale locale) {
        return DateTimeFormatters.dateTime(DateTimeFormatterBuilder.FormatStyle.SHORT, locale);
    }

    public static DateTimeFormatter dateTime(DateTimeFormatterBuilder.FormatStyle dateTimeStyle, Locale locale) {
        DateTimeFormatter.checkNotNull((Object)dateTimeStyle, "Date-time style must not be null");
        return new DateTimeFormatterBuilder().appendLocalized(dateTimeStyle, dateTimeStyle).toFormatter(locale);
    }

    public static DateTimeFormatter dateTime(DateTimeFormatterBuilder.FormatStyle dateStyle, DateTimeFormatterBuilder.FormatStyle timeStyle, Locale locale) {
        DateTimeFormatter.checkNotNull((Object)dateStyle, "Date style must not be null");
        DateTimeFormatter.checkNotNull((Object)timeStyle, "Time style must not be null");
        return new DateTimeFormatterBuilder().appendLocalized(dateStyle, timeStyle).toFormatter(locale);
    }
}

