/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.format.CalendricalPrintException;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

final class PadPrinterParserDecorator
implements DateTimePrinter,
DateTimeParser {
    private final DateTimePrinter printer;
    private final DateTimeParser parser;
    private final int padWidth;
    private final char padChar;

    PadPrinterParserDecorator(DateTimePrinter printer, DateTimeParser parser, int padWidth, char padChar) {
        this.printer = printer;
        this.parser = parser;
        this.padWidth = padWidth;
        this.padChar = padChar;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols symbols) throws IOException {
        StringBuilder buf = new StringBuilder(32);
        this.printer.print(calendrical, buf, symbols);
        int len = buf.length();
        if (len > this.padWidth) {
            throw new CalendricalPrintException("Output of " + len + " characters exceeds pad width of " + this.padWidth);
        }
        for (int i = 0; i < this.padWidth - len; ++i) {
            appendable.append(this.padChar);
        }
        appendable.append(buf);
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return this.printer.isPrintDataAvailable(calendrical);
    }

    @Override
    public int parse(DateTimeParseContext context, String parseText, int position) {
        int pos;
        if (position > parseText.length()) {
            throw new IndexOutOfBoundsException();
        }
        int endPos = position + this.padWidth;
        if (endPos > parseText.length()) {
            return ~position;
        }
        for (pos = position; pos < endPos && parseText.charAt(pos) == this.padChar; ++pos) {
        }
        parseText = parseText.substring(0, endPos);
        int firstError = 0;
        while (pos >= position) {
            int resultPos = this.parser.parse(context, parseText, pos);
            if (resultPos < 0) {
                if (firstError == 0) {
                    firstError = resultPos;
                }
                --pos;
                continue;
            }
            if (resultPos != endPos) {
                return ~position;
            }
            return resultPos;
        }
        return firstError;
    }

    public String toString() {
        String base = "Pad(";
        base = this.printer == this.parser ? base + this.printer : base + (this.printer == null ? "" : this.printer) + "," + (this.parser == null ? "" : this.parser);
        return base + "," + this.padWidth + (this.padChar == ' ' ? ")" : ",'" + this.padChar + "')");
    }
}

