/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.format.CalendricalPrintException;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

final class ZoneOffsetPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final String utcText;
    private final boolean includeColon;
    private final boolean allowSeconds;

    ZoneOffsetPrinterParser(String utcText, boolean includeColon, boolean allowSeconds) {
        this.utcText = utcText;
        this.includeColon = includeColon;
        this.allowSeconds = allowSeconds;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols symbols) throws IOException {
        ZoneOffset offset = calendrical.get(ZoneOffset.rule());
        if (offset == null) {
            throw new CalendricalPrintException("Unable to print ZoneOffset");
        }
        int totalSecs = offset.getAmountSeconds();
        if (totalSecs == 0) {
            appendable.append(this.utcText);
        } else if (this.includeColon && (this.allowSeconds || offset.getSecondsField() == 0)) {
            appendable.append(offset.getID());
        } else {
            int absHours = Math.abs(offset.getHoursField());
            int absMinutes = Math.abs(offset.getMinutesField());
            int absSeconds = Math.abs(offset.getSecondsField());
            appendable.append(totalSecs < 0 ? "-" : "+").append((char)(absHours / 10 + 48)).append((char)(absHours % 10 + 48)).append(this.includeColon ? ":" : "").append((char)(absMinutes / 10 + 48)).append((char)(absMinutes % 10 + 48));
            if (this.allowSeconds && absSeconds > 0) {
                appendable.append(this.includeColon ? ":" : "").append((char)(absSeconds / 10 + 48)).append((char)(absSeconds % 10 + 48));
            }
        }
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return calendrical.get(ZoneOffset.rule()) != null;
    }

    @Override
    public int parse(DateTimeParseContext context, String parseText, int position) {
        char sign;
        ZoneOffset offset = null;
        int length = parseText.length();
        int utcLen = this.utcText.length();
        if (utcLen == 0) {
            if (position == length) {
                context.setParsed(ZoneOffset.rule(), ZoneOffset.UTC);
                return position;
            }
        } else {
            if (position == length) {
                return ~position;
            }
            if (parseText.regionMatches(!context.isCaseSensitive(), position, this.utcText, 0, utcLen)) {
                context.setParsed(ZoneOffset.rule(), ZoneOffset.UTC);
                return position + utcLen;
            }
        }
        if ((sign = parseText.charAt(position)) == '+' || sign == '-') {
            int negative = sign == '-' ? -1 : 1;
            int[] array = new int[4];
            array[0] = position + 1;
            if (this.parseNumber(array, 1, parseText, true) || this.parseNumber(array, 2, parseText, true) || this.parseNumber(array, 3, parseText, false)) {
                return ~position;
            }
            int total = array[1] * 60 * 60 + array[2] * 60 + array[3];
            if (total > 64800) {
                return ~position;
            }
            offset = ZoneOffset.hoursMinutesSeconds(negative * array[1], negative * array[2], negative * array[3]);
            context.setParsed(ZoneOffset.rule(), offset);
            return array[0];
        }
        if (utcLen == 0) {
            context.setParsed(ZoneOffset.rule(), ZoneOffset.UTC);
            return position + utcLen;
        }
        return ~position;
    }

    private boolean parseNumber(int[] array, int arrayIndex, String parseText, boolean required) {
        if (!this.allowSeconds && arrayIndex == 3) {
            return false;
        }
        int pos = array[0];
        if (this.includeColon && arrayIndex > 1) {
            if (pos + 1 > parseText.length() || parseText.charAt(pos) != ':') {
                return required;
            }
            ++pos;
        }
        if (pos + 2 > parseText.length()) {
            return required;
        }
        char ch1 = parseText.charAt(pos++);
        char ch2 = parseText.charAt(pos++);
        if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9') {
            return required;
        }
        int value = (ch1 - 48) * 10 + (ch2 - 48);
        if (value < 0 || value > 59) {
            return required;
        }
        array[arrayIndex] = value;
        array[0] = pos;
        return false;
    }

    public String toString() {
        if (this.utcText.equals("Z") && this.includeColon && this.allowSeconds) {
            return "OffsetId()";
        }
        String converted = this.utcText.replace("'", "''");
        return "Offset('" + converted + "'," + this.includeColon + "," + this.allowSeconds + ")";
    }
}

