/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.Serializable;
import javax.time.calendar.DateAdjusters;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneRules;
import javax.time.calendar.zone.ZoneRulesBuilder;

public final class ZoneOffsetTransitionRule
implements Serializable {
    private static final long serialVersionUID = -32352886665458L;
    private final MonthOfYear month;
    private final int dom;
    private final DayOfWeek dow;
    private final LocalTime time;
    private final ZoneRulesBuilder.TimeDefinition timeDefinition;
    private final ZoneOffset standardOffset;
    private final ZoneOffset offsetBefore;
    private final ZoneOffset offsetAfter;

    ZoneOffsetTransitionRule(MonthOfYear month, int dayOfMonthIndicator, DayOfWeek dayOfWeek, LocalTime time, ZoneRulesBuilder.TimeDefinition timeDefnition, ZoneOffset standardOffset, ZoneOffset offsetBefore, ZoneOffset offsetAfter) {
        ZoneRules.checkNotNull((Object)month, "MonthOfYear must not be null");
        ZoneRules.checkNotNull(time, "LocalTime must not be null");
        ZoneRules.checkNotNull((Object)timeDefnition, "TimeDefinition must not be null");
        ZoneRules.checkNotNull(standardOffset, "Standard offset must not be null");
        ZoneRules.checkNotNull(offsetBefore, "Offset before must not be null");
        ZoneRules.checkNotNull(offsetAfter, "Offset after must not be null");
        this.month = month;
        this.dom = dayOfMonthIndicator;
        this.dow = dayOfWeek;
        this.time = time;
        this.timeDefinition = timeDefnition;
        this.standardOffset = standardOffset;
        this.offsetBefore = offsetBefore;
        this.offsetAfter = offsetAfter;
    }

    public MonthOfYear getMonthOfYear() {
        return this.month;
    }

    public int getDayOfMonthIndicator() {
        return this.dom;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dow;
    }

    public LocalTime getLocalTime() {
        return this.time;
    }

    public ZoneRulesBuilder.TimeDefinition getTimeDefinition() {
        return this.timeDefinition;
    }

    public ZoneOffset getStandardOffset() {
        return this.standardOffset;
    }

    public ZoneOffset getOffsetBefore() {
        return this.offsetBefore;
    }

    public ZoneOffset getOffsetAfter() {
        return this.offsetAfter;
    }

    public ZoneOffsetTransition createTransition(int year) {
        LocalDate date;
        if (this.dom < 0) {
            date = LocalDate.of(year, this.month, this.month.getLastDayOfMonth(ISOChronology.isLeapYear(year)) + 1 + this.dom);
            if (this.dow != null) {
                date = date.with(DateAdjusters.previousOrCurrent(this.dow));
            }
        } else {
            date = LocalDate.of(year, this.month, this.dom);
            if (this.dow != null) {
                date = date.with(DateAdjusters.nextOrCurrent(this.dow));
            }
        }
        LocalDateTime localDT = LocalDateTime.from(date, this.time);
        OffsetDateTime transition = this.timeDefinition.createDateTime(localDT, this.standardOffset, this.offsetBefore);
        return new ZoneOffsetTransition(transition, this.offsetAfter);
    }

    public boolean equals(Object otherRule) {
        if (otherRule == this) {
            return true;
        }
        if (otherRule instanceof ZoneOffsetTransitionRule) {
            ZoneOffsetTransitionRule other = (ZoneOffsetTransitionRule)otherRule;
            return this.month == other.month && this.dom == other.dom && this.dow == other.dow && this.timeDefinition == other.timeDefinition && this.time.equals(other.time) && this.standardOffset.equals(other.standardOffset) && this.offsetBefore.equals(other.offsetBefore) && this.offsetBefore.equals(other.offsetBefore);
        }
        return false;
    }

    public int hashCode() {
        int hash = (this.time.toSecondOfDay() << 15) + (this.month.ordinal() << 11) + (this.dom + 32 << 5) + (this.dow.ordinal() << 2) + this.timeDefinition.ordinal();
        return hash ^ this.standardOffset.hashCode() ^ this.offsetBefore.hashCode() ^ this.offsetAfter.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TransitionRule[").append(this.offsetBefore.compareTo(this.offsetAfter) > 0 ? "Gap " : "Overlap ").append(this.offsetBefore).append(" to ").append(this.offsetAfter).append(", ");
        if (this.dow != null) {
            if (this.dom < 0) {
                buf.append(this.dow.name()).append(" on or before ").append(this.month.name()).append(' ').append(this.dom);
            } else {
                buf.append(this.dow.name()).append(" on or after ").append(this.month.name()).append(' ').append(this.dom);
            }
        } else {
            buf.append(this.month.name()).append(' ').append(this.dom);
        }
        buf.append(" at ").append(this.time).append(" ").append((Object)this.timeDefinition).append(", standard offset ").append(this.standardOffset).append(']');
        return buf.toString();
    }
}

