/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.util.List;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.zone.FixedZoneRules;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneOffsetTransitionRule;
import javax.time.calendar.zone.ZoneRulesBuilder;
import javax.time.period.Period;

public abstract class ZoneRules {
    private static final long serialVersionUID = 93618758758127L;

    public static ZoneRules fixed(ZoneOffset offset) {
        return new FixedZoneRules(offset);
    }

    static void checkNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    protected ZoneRules() {
    }

    public boolean isFixedOffset() {
        return false;
    }

    public abstract ZoneOffset getOffset(InstantProvider var1);

    public OffsetInfo getOffsetInfo(Instant instant) {
        ZoneOffset offset = this.getOffset(instant);
        OffsetDateTime odt = OffsetDateTime.fromInstant(instant, offset);
        return this.getOffsetInfo(odt.toLocalDateTime());
    }

    public abstract OffsetInfo getOffsetInfo(LocalDateTime var1);

    public abstract ZoneOffset getStandardOffset(InstantProvider var1);

    public Period getDaylightSavings(InstantProvider instantProvider) {
        Instant instant = Instant.from(instantProvider);
        ZoneOffset standardOffset = this.getStandardOffset(instant);
        ZoneOffset actualOffset = this.getOffset(instant);
        return actualOffset.toPeriod().minus(standardOffset.toPeriod()).normalized();
    }

    public boolean isDaylightSavings(InstantProvider instant) {
        return !this.getStandardOffset(instant).equals(this.getOffset(instant));
    }

    public abstract ZoneOffsetTransition nextTransition(InstantProvider var1);

    public abstract ZoneOffsetTransition previousTransition(InstantProvider var1);

    public abstract List<ZoneOffsetTransition> getTransitions();

    public abstract List<ZoneOffsetTransitionRule> getTransitionRules();

    public boolean isValidDateTime(OffsetDateTime dateTime) {
        OffsetInfo info = this.getOffsetInfo(dateTime.toLocalDateTime());
        return info.isValidOffset(dateTime.getOffset());
    }

    protected OffsetInfo createOffsetInfo(LocalDateTime dateTime, ZoneOffset offset) {
        ZoneRules.checkNotNull(dateTime, "LocalDateTime must not be null");
        ZoneRules.checkNotNull(offset, "ZoneOffset must not be null");
        return new OffsetInfo(dateTime, offset);
    }

    protected OffsetInfo createOffsetInfo(LocalDateTime dateTime, OffsetDateTime cutoverDateTime, ZoneOffset offsetAfter) {
        ZoneRules.checkNotNull(dateTime, "LocalDateTime must not be null");
        ZoneRules.checkNotNull(cutoverDateTime, "OffsetDateTime must not be null");
        ZoneRules.checkNotNull(offsetAfter, "ZoneOffset must not be null");
        return new OffsetInfo(dateTime, cutoverDateTime, offsetAfter);
    }

    protected ZoneOffsetTransition createTransition(OffsetDateTime transition, ZoneOffset offsetAfter) {
        return new ZoneOffsetTransition(transition, offsetAfter);
    }

    protected ZoneOffsetTransitionRule createTransitionRule(MonthOfYear month, int dayOfMonthIndicator, DayOfWeek dayOfWeek, LocalTime time, ZoneRulesBuilder.TimeDefinition timeDefnition, ZoneOffset standardOffset, ZoneOffset offsetBefore, ZoneOffset offsetAfter) {
        return new ZoneOffsetTransitionRule(month, dayOfMonthIndicator, dayOfWeek, time, timeDefnition, standardOffset, offsetBefore, offsetAfter);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static final class OffsetInfo {
        private final LocalDateTime dateTime;
        private final ZoneOffset offset;
        private final ZoneOffsetTransition transition;

        OffsetInfo(LocalDateTime dateTime, ZoneOffset offset) {
            this.dateTime = dateTime;
            this.offset = offset;
            this.transition = null;
        }

        OffsetInfo(LocalDateTime dateTime, OffsetDateTime cutoverDateTime, ZoneOffset offsetAfter) {
            this.dateTime = dateTime;
            this.offset = null;
            this.transition = new ZoneOffsetTransition(cutoverDateTime, offsetAfter);
        }

        public LocalDateTime getLocalDateTime() {
            return this.dateTime;
        }

        public boolean isTransition() {
            return this.transition != null;
        }

        public ZoneOffset getOffset() {
            return this.offset;
        }

        public ZoneOffsetTransition getTransition() {
            return this.transition;
        }

        public ZoneOffset getEstimatedOffset() {
            return this.isTransition() ? this.getTransition().getOffsetAfter() : this.offset;
        }

        public boolean isValidOffset(ZoneOffset offset) {
            return this.isTransition() ? this.transition.isValidOffset(offset) : this.offset.equals(offset);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("OffsetInfo[").append(this.isTransition() ? this.transition : this.offset).append(']');
            return buf.toString();
        }
    }
}

