/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.time.CalendricalException;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.zone.JarZoneRulesDataProvider;
import javax.time.calendar.zone.ZoneRules;
import javax.time.calendar.zone.ZoneRulesDataProvider;

public final class ZoneRulesGroup {
    private static final Set<String> IDS = new CopyOnWriteArraySet<String>();
    private static final ConcurrentMap<String, ZoneRulesGroup> GROUPS = new ConcurrentHashMap<String, ZoneRulesGroup>(16, 0.75f, 2);
    private final String groupID;
    private final ConcurrentMap<String, TreeMap<String, ZoneRulesDataProvider>> regions = new ConcurrentHashMap<String, TreeMap<String, ZoneRulesDataProvider>>(100, 0.75f, 2);

    public static boolean isValidGroup(String groupID) {
        if (groupID == null) {
            return false;
        }
        return GROUPS.containsKey(groupID);
    }

    public static ZoneRulesGroup getGroup(String groupID) {
        ZoneRules.checkNotNull(groupID, "Group ID must not be null");
        ZoneRulesGroup group = (ZoneRulesGroup)GROUPS.get(groupID);
        if (group == null) {
            throw new CalendricalException("Unknown time zone group ID: " + groupID);
        }
        return group;
    }

    public static List<ZoneRulesGroup> getAvailableGroups() {
        return new ArrayList<ZoneRulesGroup>(GROUPS.values());
    }

    public static Set<String> getParsableIDs() {
        return Collections.unmodifiableSet(IDS);
    }

    public static synchronized void registerProvider(ZoneRulesDataProvider provider) {
        ZoneRulesGroup group = (ZoneRulesGroup)GROUPS.get(provider.getGroupID());
        if (group == null) {
            group = new ZoneRulesGroup(provider.getGroupID());
            GROUPS.put(provider.getGroupID(), group);
        }
        group.registerProvider0(provider);
    }

    private ZoneRulesGroup(String groupID) {
        if (groupID == null) {
            throw new NullPointerException("Group ID must not be null");
        }
        if (!groupID.matches("[A-Za-z0-9._-]+")) {
            throw new CalendricalException("Group ID must only contain alphanumerics, dot, underscore and dash");
        }
        this.groupID = groupID;
    }

    private synchronized void registerProvider0(ZoneRulesDataProvider provider) {
        Set<String> ids = provider.getIDs();
        HashSet<String> fullIDs = new HashSet<String>(ids.size());
        HashSet<String[]> splits = new HashSet<String[]>(ids.size());
        for (String id : ids) {
            TreeMap versions;
            int pos = id.indexOf(35);
            String regionID = id;
            String versionID = "";
            if (pos >= 0) {
                regionID = id.substring(0, pos);
                versionID = id.substring(pos + 1);
            }
            if ((versions = (TreeMap)this.regions.get(regionID)) != null) {
                if (versionID.length() > 0 && versions.containsKey("")) {
                    throw new CalendricalException("Cannot register versioned provider '" + this.groupID + ":" + regionID + "#" + versionID + "' as an unversioned provider '" + this.groupID + ":" + regionID + "' is already registered");
                }
                if (versions.containsKey(versionID)) {
                    throw new CalendricalException("Cannot register provider '" + this.groupID + ":" + regionID + "#" + versionID + "' as one is already registered with that ID");
                }
            }
            splits.add(new String[]{regionID, versionID});
            if (this.groupID.equals("TZDB")) {
                fullIDs.add(id);
                fullIDs.add(regionID);
            }
            fullIDs.add(this.groupID + ':' + id);
            fullIDs.add(this.groupID + ':' + regionID);
        }
        for (String[] split : splits) {
            TreeMap<String, ZoneRulesDataProvider> map = new TreeMap<String, ZoneRulesDataProvider>();
            map.put(split[1], provider);
            if ((map = this.regions.putIfAbsent(split[0], map)) == null) continue;
            ((TreeMap)this.regions.get(split[0])).put(split[1], provider);
        }
        IDS.addAll(fullIDs);
    }

    private TreeMap<String, ZoneRulesDataProvider> getVersions(String regionID) {
        TreeMap versions = (TreeMap)this.regions.get(regionID);
        if (versions == null) {
            throw new CalendricalException("Unknown time zone region: " + this.groupID + ":" + regionID);
        }
        return versions;
    }

    public String getID() {
        return this.groupID;
    }

    public boolean isValidRules(String regionID, String versionID) {
        if (regionID == null || versionID == null) {
            return false;
        }
        TreeMap versions = (TreeMap)this.regions.get(regionID);
        return versions != null && (versionID.length() == 0 || versions.containsKey(versionID));
    }

    public ZoneRules getRules(String regionID, String versionID) {
        ZoneRulesDataProvider provider;
        ZoneRules.checkNotNull(regionID, "Region ID must not be null");
        ZoneRules.checkNotNull(versionID, "Version ID must not be null");
        TreeMap<String, ZoneRulesDataProvider> versions = this.getVersions(regionID);
        if (versionID.length() == 0) {
            versionID = versions.lastKey();
            provider = versions.get(versionID);
        } else {
            provider = versions.get(versionID);
            if (provider == null) {
                throw new CalendricalException("Unknown time zone version: " + this.groupID + ":" + regionID + (versionID.length() == 0 ? "" : "#" + versionID));
            }
        }
        return provider.getZoneRules(regionID, versionID);
    }

    public boolean isValidRulesFor(String regionID, String versionID, OffsetDateTime dateTime) {
        if (regionID == null || versionID == null || dateTime == null) {
            return false;
        }
        try {
            this.getRulesValidFor(regionID, versionID, dateTime);
            return true;
        }
        catch (CalendricalException ex) {
            return false;
        }
    }

    public ZoneRules getRulesValidFor(String regionID, String versionID, OffsetDateTime dateTime) {
        ZoneRules.checkNotNull(regionID, "Region ID must not be null");
        ZoneRules.checkNotNull(versionID, "Version ID must not be null");
        ZoneRules.checkNotNull(dateTime, "Valid date-time must not be null");
        if (versionID.length() > 0) {
            ZoneRules rules = this.getRules(regionID, versionID);
            if (!rules.isValidDateTime(dateTime)) {
                throw new CalendricalException("Rules in time zone " + this.groupID + ":" + regionID + "#" + versionID + " are invalid for date-time " + dateTime);
            }
            return rules;
        }
        versionID = this.getLatestVersionIDValidFor(regionID, dateTime);
        return this.getRules(regionID, versionID);
    }

    public String getLatestVersionIDValidFor(String regionID, OffsetDateTime dateTime) {
        ZoneRules.checkNotNull(regionID, "Region ID must not be null");
        ZoneRules.checkNotNull(dateTime, "OffsetDateTime must not be null");
        TreeMap versions = new TreeMap(Collections.reverseOrder());
        versions.putAll(this.getVersions(regionID));
        for (Map.Entry entry : versions.entrySet()) {
            ZoneRulesDataProvider provider = (ZoneRulesDataProvider)entry.getValue();
            ZoneRules rules = provider.getZoneRules(regionID, (String)entry.getKey());
            if (!rules.isValidDateTime(dateTime)) continue;
            return (String)entry.getKey();
        }
        throw new CalendricalException("No rules could be found in time zone " + this.groupID + ":" + regionID + " that are valid for date-time " + dateTime);
    }

    public List<String> getAvailableRegionIDs() {
        ArrayList<String> list = new ArrayList<String>(this.regions.keySet());
        Collections.sort(list);
        return list;
    }

    public List<String> getAvailableRegionIDs(String versionID) {
        ZoneRules.checkNotNull(versionID, "Version ID must not be null");
        if (versionID.length() == 0) {
            return this.getAvailableRegionIDs();
        }
        HashSet set = new HashSet();
        for (Map.Entry entry : this.regions.entrySet()) {
            if (!((TreeMap)entry.getValue()).containsKey(versionID)) continue;
            set.add(entry.getKey());
        }
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        return list;
    }

    public String getLatestVersionID(String regionID) {
        ZoneRules.checkNotNull(regionID, "Region ID must not be null");
        TreeMap<String, ZoneRulesDataProvider> versions = this.getVersions(regionID);
        return versions.lastKey();
    }

    public List<String> getAvailableVersionIDs(String regionID) {
        ZoneRules.checkNotNull(regionID, "Region ID must not be null");
        TreeMap<String, ZoneRulesDataProvider> versions = this.getVersions(regionID);
        return new ArrayList<String>(versions.keySet());
    }

    public boolean equals(Object otherGroup) {
        if (this == otherGroup) {
            return true;
        }
        if (otherGroup instanceof ZoneRulesGroup) {
            return this.groupID.equals(((ZoneRulesGroup)otherGroup).groupID);
        }
        return false;
    }

    public int hashCode() {
        return this.groupID.hashCode();
    }

    public String toString() {
        return this.groupID;
    }

    static {
        JarZoneRulesDataProvider.load();
    }
}

