/*
 * Decompiled with CFR 0.152.
 */
package javax.time.i18n;

import java.io.Serializable;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMerger;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDate;
import javax.time.i18n.CopticChronology;

public final class CopticDate
implements DateProvider,
Calendrical,
Comparable<CopticDate>,
Serializable {
    public static final int MIN_YEAR = 1;
    public static final int MAX_YEAR = 9999;
    private static final long serialVersionUID = 27545623L;
    private static final int MJD_TO_COPTIC = 574971;
    private static final int MIN_EPOCH_DAY = 0;
    private static final int MAX_EPOCH_DAY = 3652134;
    private final int epochDays;
    private final transient int year;
    private final transient int month;
    private final transient int day;

    public static CopticDate of(int copticYear, int copticMonthOfYear, int copticDayOfMonth) {
        CopticChronology.yearRule().checkValue(copticYear);
        CopticChronology.monthOfYearRule().checkValue(copticMonthOfYear);
        CopticChronology.dayOfMonthRule().checkValue(copticDayOfMonth);
        if (!(copticMonthOfYear != 13 || copticDayOfMonth <= 5 || copticDayOfMonth <= 6 && CopticChronology.isLeapYear(copticYear))) {
            throw new InvalidCalendarFieldException("Invalid Coptic date", CopticChronology.dayOfMonthRule());
        }
        int epochDays = (copticYear - 1) * 365 + copticYear / 4 + 30 * (copticMonthOfYear - 1) + copticDayOfMonth - 1;
        return new CopticDate(epochDays, copticYear, copticMonthOfYear, copticDayOfMonth);
    }

    private static CopticDate copticDatePreviousValid(int year, int monthOfYear, int dayOfMonth) {
        CopticChronology.yearRule().checkValue(year);
        CopticChronology.monthOfYearRule().checkValue(monthOfYear);
        CopticChronology.dayOfMonthRule().checkValue(dayOfMonth);
        if (monthOfYear == 13 && dayOfMonth > 5) {
            dayOfMonth = CopticChronology.isLeapYear(year) ? 6 : 5;
        }
        int epochDays = (year - 1) * 365 + year / 4 + 30 * (monthOfYear - 1) + dayOfMonth - 1;
        return new CopticDate(epochDays, year, monthOfYear, dayOfMonth);
    }

    public static CopticDate from(Calendrical calendrical) {
        return CopticDate.rule().getValueChecked(calendrical);
    }

    private static CopticDate copticDateFromEopchDays(int epochDays) {
        if (epochDays < 0 || epochDays > 3652134) {
            throw new IllegalCalendarFieldValueException("Date exceeds supported range for CopticDate", CopticChronology.yearRule());
        }
        int year = (epochDays * 4 + 1463) / 1461;
        int startYearEpochDays = (year - 1) * 365 + year / 4;
        int doy0 = epochDays - startYearEpochDays;
        int month = doy0 / 30 + 1;
        int day = doy0 % 30 + 1;
        return new CopticDate(epochDays, year, month, day);
    }

    private CopticDate(int epochDays, int year, int month, int day) {
        this.epochDays = epochDays;
        this.year = year;
        this.month = month;
        this.day = day;
    }

    private Object readResolve() {
        return CopticDate.copticDateFromEopchDays(this.epochDays);
    }

    public CopticChronology getChronology() {
        return CopticChronology.INSTANCE;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        if (rule.equals(LocalDate.rule())) {
            return rule.reify(this.toLocalDate());
        }
        return CopticDate.rule().deriveValueFor(rule, this, this);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonthOfYear() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfYear() {
        int startYearEpochDays = (this.year - 1) * 365 + this.year / 4;
        return this.epochDays - startYearEpochDays + 1;
    }

    public DayOfWeek getDayOfWeek() {
        return DayOfWeek.of((this.epochDays + 4) % 7 + 1);
    }

    public boolean isLeapYear() {
        return CopticChronology.isLeapYear(this.getYear());
    }

    public boolean isLeapDay() {
        return this.getMonthOfYear() == 13 && this.getDayOfMonth() == 6;
    }

    public CopticDate withYear(int year) {
        return CopticDate.copticDatePreviousValid(year, this.getMonthOfYear(), this.getDayOfMonth());
    }

    public CopticDate withMonthOfYear(int monthOfYear) {
        return CopticDate.copticDatePreviousValid(this.getYear(), monthOfYear, this.getDayOfMonth());
    }

    public CopticDate withDayOfMonth(int dayOfMonth) {
        return CopticDate.of(this.getYear(), this.getMonthOfYear(), dayOfMonth);
    }

    public CopticDate withDayOfYear(int dayOfYear) {
        return CopticDate.of(this.getYear(), --dayOfYear / 30 + 1, dayOfYear % 30 + 1);
    }

    public CopticDate plusYears(int years) {
        int newYear = this.getYear() + years;
        return CopticDate.copticDatePreviousValid(newYear, this.getMonthOfYear(), this.getDayOfMonth());
    }

    public CopticDate plusMonths(int months) {
        int newMonth0 = this.getMonthOfYear() + months - 1;
        int years = newMonth0 / 13;
        if ((newMonth0 %= 13) < 0) {
            newMonth0 += 13;
            --years;
        }
        int newYear = this.getYear() + years;
        int newDay = this.getDayOfMonth();
        return CopticDate.copticDatePreviousValid(newYear, newMonth0 + 1, newDay);
    }

    public CopticDate plusDays(int days) {
        int newEpochDays = this.epochDays + days;
        return CopticDate.copticDateFromEopchDays(newEpochDays);
    }

    @Override
    public LocalDate toLocalDate() {
        return LocalDate.fromModifiedJulianDays(this.epochDays - 574971);
    }

    @Override
    public int compareTo(CopticDate otherDate) {
        return MathUtils.safeCompare(this.epochDays, otherDate.epochDays);
    }

    public boolean isAfter(CopticDate otherDate) {
        return this.epochDays > otherDate.epochDays;
    }

    public boolean isBefore(CopticDate otherDate) {
        return this.epochDays < otherDate.epochDays;
    }

    public boolean equals(Object otherDate) {
        if (this == otherDate) {
            return true;
        }
        if (otherDate instanceof CopticDate) {
            CopticDate other = (CopticDate)otherDate;
            return this.epochDays == other.epochDays;
        }
        return false;
    }

    public int hashCode() {
        return this.epochDays;
    }

    public String toString() {
        int yearValue = this.getYear();
        int monthValue = this.getMonthOfYear();
        int dayValue = this.getDayOfMonth();
        int absYear = Math.abs(yearValue);
        StringBuilder buf = new StringBuilder(12);
        if (absYear < 1000) {
            buf.append(yearValue + 10000).deleteCharAt(0);
        } else {
            buf.append(yearValue);
        }
        return buf.append(monthValue < 10 ? "-0" : "-").append(monthValue).append(dayValue < 10 ? "-0" : "-").append(dayValue).append(" (Coptic)").toString();
    }

    public static CalendricalRule<CopticDate> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<CopticDate>
    implements Serializable {
        private static final CalendricalRule<CopticDate> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(CopticDate.class, CopticChronology.INSTANCE, "CopticDate", CopticChronology.periodDays(), null);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected CopticDate derive(Calendrical calendrical) {
            LocalDate ld = calendrical.get(LocalDate.rule());
            if (ld == null) {
                return null;
            }
            long epochDays = ld.toModifiedJulianDays() + 574971L;
            return CopticDate.copticDateFromEopchDays((int)epochDays);
        }

        @Override
        protected void merge(CalendricalMerger merger) {
            CopticDate cd = merger.getValue(this);
            merger.storeMerged(LocalDate.rule(), cd.toLocalDate());
            merger.removeProcessed(this);
        }
    }
}

