/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.time.Duration;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.PeriodUnit;
import javax.time.period.PeriodField;
import javax.time.period.PeriodProvider;

public final class PeriodFields
implements PeriodProvider,
Iterable<PeriodField>,
Serializable {
    public static final PeriodFields ZERO = new PeriodFields(new TreeMap<PeriodUnit, PeriodField>());
    private static final long serialVersionUID = 1L;
    private final TreeMap<PeriodUnit, PeriodField> unitFieldMap;

    public static PeriodFields of(long amount, PeriodUnit unit) {
        PeriodFields.checkNotNull(unit, "PeriodUnit must not be null");
        TreeMap<PeriodUnit, PeriodField> internalMap = PeriodFields.createMap();
        internalMap.put(unit, PeriodField.of(amount, unit));
        return PeriodFields.create(internalMap);
    }

    public static PeriodFields of(PeriodField period) {
        PeriodFields.checkNotNull(period, "PeriodField must not be null");
        TreeMap<PeriodUnit, PeriodField> internalMap = PeriodFields.createMap();
        internalMap.put(period.getUnit(), period);
        return PeriodFields.create(internalMap);
    }

    public static PeriodFields of(PeriodField ... periods) {
        PeriodFields.checkNotNull(periods, "PeriodField array must not be null");
        TreeMap<PeriodUnit, PeriodField> internalMap = PeriodFields.createMap();
        for (PeriodField period : periods) {
            PeriodFields.checkNotNull(period, "PeriodField array must not contain null");
            if (internalMap.put(period.getUnit(), period) == null) continue;
            throw new IllegalArgumentException("PeriodField array contains the same unit twice");
        }
        return PeriodFields.create(internalMap);
    }

    public static PeriodFields of(Map<PeriodUnit, ? extends Number> unitAmountMap) {
        PeriodFields.checkNotNull(unitAmountMap, "Map must not be null");
        TreeMap<PeriodUnit, PeriodField> internalMap = PeriodFields.createMap();
        for (Map.Entry<PeriodUnit, ? extends Number> entry : unitAmountMap.entrySet()) {
            PeriodUnit unit = entry.getKey();
            Number amount = entry.getValue();
            PeriodFields.checkNotNull(unit, "Null keys are not permitted in unit-amount map");
            PeriodFields.checkNotNull(amount, "Null amounts are not permitted in unit-amount map");
            internalMap.put(unit, PeriodField.of(amount.longValue(), unit));
        }
        return PeriodFields.create(internalMap);
    }

    public static PeriodFields from(PeriodProvider periodProvider) {
        PeriodFields.checkNotNull(periodProvider, "PeriodProvider must not be null");
        PeriodFields result = periodProvider.toPeriodFields();
        PeriodFields.checkNotNull(result, "PeriodProvider implementation must not return null");
        return result;
    }

    public static PeriodFields total(PeriodProvider ... periodProviders) {
        PeriodFields.checkNotNull(periodProviders, "PeriodProvider[] must not be null");
        if (periodProviders.length == 1) {
            return PeriodFields.from(periodProviders[0]);
        }
        TreeMap<PeriodUnit, PeriodField> map = PeriodFields.createMap();
        for (PeriodProvider periodProvider : periodProviders) {
            PeriodFields periods = PeriodFields.from(periodProvider);
            for (PeriodField period : periods.unitFieldMap.values()) {
                PeriodField old = map.get(period.getUnit());
                period = old != null ? old.plus(period) : period;
                map.put(period.getUnit(), period);
            }
        }
        return PeriodFields.create(map);
    }

    public static PeriodFields from(Duration duration) {
        PeriodFields.checkNotNull(duration, "Duration must not be null");
        TreeMap<PeriodUnit, PeriodField> internalMap = PeriodFields.createMap();
        internalMap.put(ISOChronology.periodSeconds(), PeriodField.of(duration.getSeconds(), ISOChronology.periodSeconds()));
        internalMap.put(ISOChronology.periodNanos(), PeriodField.of(duration.getNanosInSecond(), ISOChronology.periodNanos()));
        return PeriodFields.create(internalMap);
    }

    private static TreeMap<PeriodUnit, PeriodField> createMap() {
        return new TreeMap<PeriodUnit, PeriodField>(Collections.reverseOrder());
    }

    static PeriodFields create(TreeMap<PeriodUnit, PeriodField> periodMap) {
        if (periodMap.isEmpty()) {
            return ZERO;
        }
        return new PeriodFields(periodMap);
    }

    static void checkNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    private PeriodFields(TreeMap<PeriodUnit, PeriodField> periodMap) {
        this.unitFieldMap = periodMap;
    }

    private Object readResolve() {
        if (this.unitFieldMap.size() == 0) {
            return ZERO;
        }
        return this;
    }

    public boolean isZero() {
        for (PeriodField field : this.unitFieldMap.values()) {
            if (field.isZero()) continue;
            return false;
        }
        return true;
    }

    public boolean isPositive() {
        for (PeriodField field : this.unitFieldMap.values()) {
            if (!field.isNegative()) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.unitFieldMap.size();
    }

    @Override
    public Iterator<PeriodField> iterator() {
        return this.unitFieldMap.values().iterator();
    }

    public boolean contains(PeriodUnit unit) {
        return this.unitFieldMap.containsKey(unit);
    }

    public PeriodField get(PeriodUnit unit) {
        PeriodFields.checkNotNull(unit, "PeriodUnit must not be null");
        return this.unitFieldMap.get(unit);
    }

    public long getAmount(PeriodUnit unit) {
        PeriodField field = this.get(unit);
        if (field == null) {
            return 0L;
        }
        return field.getAmount();
    }

    public int getAmountInt(PeriodUnit unit) {
        PeriodField field = this.get(unit);
        if (field == null) {
            return 0;
        }
        return field.getAmountInt();
    }

    public PeriodFields withZeroesRemoved() {
        if (this.isZero()) {
            return ZERO;
        }
        TreeMap<PeriodUnit, PeriodField> copy = this.clonedMap();
        Iterator<PeriodField> it = copy.values().iterator();
        while (it.hasNext()) {
            if (!it.next().isZero()) continue;
            it.remove();
        }
        return PeriodFields.create(copy);
    }

    public PeriodFields with(long amount, PeriodUnit unit) {
        PeriodField existing = this.get(unit);
        if (existing != null && existing.getAmount() == amount) {
            return this;
        }
        TreeMap<PeriodUnit, PeriodField> copy = this.clonedMap();
        copy.put(unit, PeriodField.of(amount, unit));
        return PeriodFields.create(copy);
    }

    public PeriodFields with(PeriodFields period) {
        if (this == ZERO) {
            return period;
        }
        if (period == ZERO) {
            return this;
        }
        TreeMap<PeriodUnit, PeriodField> copy = this.clonedMap();
        copy.putAll(period.unitFieldMap);
        return PeriodFields.create(copy);
    }

    public PeriodFields without(PeriodUnit unit) {
        PeriodFields.checkNotNull(unit, "PeriodUnit must not be null");
        if (!this.unitFieldMap.containsKey(unit)) {
            return this;
        }
        TreeMap<PeriodUnit, PeriodField> copy = this.clonedMap();
        copy.remove(unit);
        return PeriodFields.create(copy);
    }

    public PeriodFields plus(PeriodProvider periodProvider) {
        PeriodFields.checkNotNull(periodProvider, "PeriodProvider must not be null");
        if (this == ZERO && periodProvider instanceof PeriodFields) {
            return (PeriodFields)periodProvider;
        }
        TreeMap<PeriodUnit, PeriodField> copy = this.clonedMap();
        PeriodFields periods = PeriodFields.from(periodProvider);
        for (PeriodField period : periods.unitFieldMap.values()) {
            PeriodField old = copy.get(period.getUnit());
            period = old != null ? old.plus(period) : period;
            copy.put(period.getUnit(), period);
        }
        return PeriodFields.create(copy);
    }

    public PeriodFields plus(long amount, PeriodUnit unit) {
        PeriodFields.checkNotNull(unit, "PeiodRule must not be null");
        if (amount == 0L && this.contains(unit)) {
            return this;
        }
        TreeMap<PeriodUnit, PeriodField> copy = this.clonedMap();
        PeriodField old = copy.get(unit);
        PeriodField field = old != null ? old.plus(amount) : PeriodField.of(amount, unit);
        copy.put(unit, field);
        return PeriodFields.create(copy);
    }

    public PeriodFields minus(PeriodProvider periodProvider) {
        PeriodFields.checkNotNull(periodProvider, "PeriodProvider must not be null");
        if (this == ZERO && periodProvider instanceof PeriodFields) {
            return (PeriodFields)periodProvider;
        }
        TreeMap<PeriodUnit, PeriodField> copy = this.clonedMap();
        PeriodFields periods = PeriodFields.from(periodProvider);
        for (PeriodField period : periods.unitFieldMap.values()) {
            PeriodField old = copy.get(period.getUnit());
            period = old != null ? old.minus(period) : period.negated();
            copy.put(period.getUnit(), period);
        }
        return PeriodFields.create(copy);
    }

    public PeriodFields minus(long amount, PeriodUnit unit) {
        TreeMap<PeriodUnit, PeriodField> copy;
        PeriodFields.checkNotNull(unit, "PeiodRule must not be null");
        if (amount == 0L && this.contains(unit)) {
            return this;
        }
        PeriodField old = (copy = this.clonedMap()).get(unit);
        copy.put(unit, old != null ? old.minus(amount) : PeriodField.of(amount, unit).negated());
        return PeriodFields.create(copy);
    }

    public PeriodFields multipliedBy(long scalar) {
        if (scalar == 1L || this.isZero()) {
            return this;
        }
        TreeMap<PeriodUnit, PeriodField> copy = PeriodFields.createMap();
        for (PeriodField field : this) {
            copy.put(field.getUnit(), field.multipliedBy(scalar));
        }
        return PeriodFields.create(copy);
    }

    public PeriodFields dividedBy(long divisor) {
        if (divisor == 0L) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        if (divisor == 1L || this.isZero()) {
            return this;
        }
        TreeMap<PeriodUnit, PeriodField> copy = PeriodFields.createMap();
        for (PeriodField field : this) {
            copy.put(field.getUnit(), field.dividedBy(divisor));
        }
        return PeriodFields.create(copy);
    }

    public PeriodFields negated() {
        return this.multipliedBy(-1L);
    }

    private TreeMap<PeriodUnit, PeriodField> clonedMap() {
        return (TreeMap)this.unitFieldMap.clone();
    }

    public PeriodFields toEquivalentPeriod(PeriodUnit ... units) {
        TreeMap<PeriodUnit, PeriodField> map = PeriodFields.createMap();
        for (PeriodField period : this.unitFieldMap.values()) {
            PeriodField old = map.get((period = period.toEquivalentPeriod(units)).getUnit());
            period = old != null ? old.plus(period) : period;
            map.put(period.getUnit(), period);
        }
        return map.equals(this.unitFieldMap) ? this : PeriodFields.create(map);
    }

    public SortedMap<PeriodUnit, Long> toRuleAmountMap() {
        TreeMap<PeriodUnit, Long> map = new TreeMap<PeriodUnit, Long>(Collections.reverseOrder());
        for (PeriodField field : this) {
            map.put(field.getUnit(), field.getAmount());
        }
        return map;
    }

    public Duration toEstimatedDuration() {
        Duration dur = Duration.ZERO;
        for (PeriodField field : this) {
            dur = dur.plus(field.toEstimatedDuration());
        }
        return dur;
    }

    public Duration toDuration() {
        PeriodFields period = this.toEquivalentPeriod(ISOChronology.periodSeconds(), ISOChronology.periodNanos());
        return Duration.seconds(period.getAmount(ISOChronology.periodSeconds()), period.getAmount(ISOChronology.periodNanos()));
    }

    @Override
    public PeriodFields toPeriodFields() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PeriodFields) {
            PeriodFields other = (PeriodFields)obj;
            return this.unitFieldMap.equals(other.unitFieldMap);
        }
        return false;
    }

    public int hashCode() {
        return this.unitFieldMap.hashCode();
    }

    public String toString() {
        if (this.unitFieldMap.size() == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (PeriodField field : this) {
            buf.append(field.toString()).append(',').append(' ');
        }
        buf.setLength(buf.length() - 2);
        buf.append(']');
        return buf.toString();
    }
}

