/*
 * Decompiled with CFR 0.152.
 */
package javax.time.scales;

import java.io.Serializable;
import javax.time.Duration;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.MathUtils;
import javax.time.scales.ScaleUtil;
import javax.time.scales.TimeScale;
import javax.time.scales.TimeScaleInstantFormat;

public final class TimeScaleInstant
implements InstantProvider,
Comparable<TimeScaleInstant>,
Serializable {
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final long serialVersionUID = -9114640809030911667L;
    private final TimeScale timeScale;
    private final long epochSeconds;
    private final int nanoOfSecond;

    public static TimeScaleInstant from(TimeScale timeScale, InstantProvider instantProvider) {
        ScaleUtil.checkNotNull(timeScale, "TimeScale must not be null");
        ScaleUtil.checkNotNull(instantProvider, "InstantProvider must not be null");
        return timeScale.toTimeScaleInstant(instantProvider);
    }

    public static TimeScaleInstant seconds(TimeScale timeScale, long epochSeconds) {
        return new TimeScaleInstant(timeScale, epochSeconds, 0);
    }

    public static TimeScaleInstant seconds(TimeScale timeScale, long epochSeconds, int nanoOfSecond) {
        if (nanoOfSecond >= 1000000000) {
            throw new IllegalArgumentException("Nanosecond fraction must not be more than 999,999,999 but was " + nanoOfSecond);
        }
        if (nanoOfSecond < 0) {
            if ((nanoOfSecond += 1000000000) <= 0) {
                throw new IllegalArgumentException("Nanosecond fraction must not be less than -999,999,999 but was " + nanoOfSecond);
            }
            epochSeconds = MathUtils.safeDecrement(epochSeconds);
        }
        return new TimeScaleInstant(timeScale, epochSeconds, nanoOfSecond);
    }

    public static TimeScaleInstant seconds(TimeScale timeScale, long epochSeconds, int leapSecond, int nanoOfSecond) {
        if (nanoOfSecond >= 1000000000) {
            throw new IllegalArgumentException("Nanosecond fraction must not be more than 999,999,999 but was " + nanoOfSecond);
        }
        if (nanoOfSecond < 0) {
            if ((nanoOfSecond += 1000000000) <= 0) {
                throw new IllegalArgumentException("Nanosecond fraction must not be less than -999,999,999 but was " + nanoOfSecond);
            }
            epochSeconds = MathUtils.safeDecrement(epochSeconds);
        }
        if (leapSecond != 0) {
            if (leapSecond < 0 || leapSecond > 1) {
                throw new IllegalArgumentException("Leap second must be zero or 1");
            }
            if (!timeScale.supportsLeapSecond()) {
                throw new IllegalArgumentException("Time scale does not support leap-seconds");
            }
            nanoOfSecond += 1000000000;
        }
        return new TimeScaleInstant(timeScale, epochSeconds, nanoOfSecond);
    }

    private TimeScaleInstant(TimeScale timeScale, long epochSeconds, int nanoOfSecond) {
        this.timeScale = timeScale;
        this.epochSeconds = epochSeconds;
        this.nanoOfSecond = nanoOfSecond;
    }

    public TimeScale getTimeScale() {
        return this.timeScale;
    }

    public long getEpochSeconds() {
        return this.epochSeconds;
    }

    public int getLeapSecond() {
        return this.nanoOfSecond < 1000000000 ? 0 : 1;
    }

    public int getNanoOfSecond() {
        return this.nanoOfSecond < 1000000000 ? this.nanoOfSecond : this.nanoOfSecond - 1000000000;
    }

    public Validity getValidity() {
        return this.timeScale.getValidity(this);
    }

    public TimeScaleInstant plus(Duration duration) {
        return this.timeScale.add(this, duration);
    }

    public TimeScaleInstant minus(Duration duration) {
        return this.timeScale.subtract(this, duration);
    }

    @Override
    public Instant toInstant() {
        return this.timeScale.toInstant(this);
    }

    @Override
    public int compareTo(TimeScaleInstant otherInstant) {
        if (this.timeScale.equals(otherInstant.timeScale)) {
            int cmp = MathUtils.safeCompare(this.epochSeconds, otherInstant.epochSeconds);
            if (cmp != 0) {
                return cmp;
            }
            return MathUtils.safeCompare(this.nanoOfSecond, otherInstant.nanoOfSecond);
        }
        throw new UnsupportedOperationException("Comparison of instants on different time scales not supported yet");
    }

    public boolean isAfter(TimeScaleInstant otherInstant) {
        return this.compareTo(otherInstant) > 0;
    }

    public boolean isBefore(TimeScaleInstant otherInstant) {
        return this.compareTo(otherInstant) < 0;
    }

    public boolean equals(Object otherInstant) {
        if (this == otherInstant) {
            return true;
        }
        if (otherInstant instanceof TimeScaleInstant) {
            TimeScaleInstant other = (TimeScaleInstant)otherInstant;
            return this.epochSeconds == other.epochSeconds && this.nanoOfSecond == other.nanoOfSecond && this.timeScale.equals(other.timeScale);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.epochSeconds ^ this.epochSeconds >>> 32) + 51 * this.nanoOfSecond + 7 * this.timeScale.hashCode();
    }

    public String toString() {
        return TimeScaleInstantFormat.getInstance().format(this);
    }

    public static enum Validity {
        VALID,
        AMBIGUOUS,
        POSSIBLE,
        INVALID;

    }
}

