/*
 * Decompiled with CFR 0.152.
 */
package javax.time.scales;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import javax.time.scales.TimeScaleInstant;

public class TimeScaleInstantFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private static long SECONDS_PER_DAY;
    private static int DAYS_STANDARD_YEAR;
    private static int DAYS_JULIAN_CYCLE;
    private static int DAYS_STANDARD_CENTURY;
    private static int DAYS_GREGORIAN_CYCLE;
    private static int DATE_1600_03_01;
    private static final String[] SMALL_NUMBERS;
    private static TimeScaleInstantFormat INSTANCE;

    public static TimeScaleInstantFormat getInstance() {
        return INSTANCE;
    }

    private static void formatDate(long date, StringBuffer buffer) {
        long year = (date += (long)DATE_1600_03_01) / (long)DAYS_GREGORIAN_CYCLE;
        int r = (int)(date % (long)DAYS_GREGORIAN_CYCLE);
        if (r < 0) {
            --year;
            r += DAYS_GREGORIAN_CYCLE;
        }
        year = 1600L + 400L * year;
        int q = r / DAYS_STANDARD_CENTURY;
        r %= DAYS_STANDARD_CENTURY;
        int leap = 0;
        if (q == 4) {
            --q;
            r = DAYS_STANDARD_CENTURY - 1;
            leap = 1;
        }
        year += (long)(100 * q);
        q = r / DAYS_JULIAN_CYCLE;
        year += (long)(4 * q);
        q = (r %= DAYS_JULIAN_CYCLE) / DAYS_STANDARD_YEAR;
        r %= DAYS_STANDARD_YEAR;
        if (q == 4) {
            --q;
            r = DAYS_STANDARD_YEAR - 1;
            leap = 1;
        }
        year += (long)q;
        int month = (r * 5 + 308) / 153 - 2;
        int day = r - (month + 4) * 153 / 5 + 122 + leap;
        if (month >= 10) {
            ++year;
            month -= 10;
        } else {
            month += 2;
        }
        if (year < 0L) {
            buffer.append('-');
            year = -year;
        }
        if (year < 1000L) {
            buffer.append('0');
            if (year < 100L) {
                buffer.append('0');
                if (year < 10L) {
                    buffer.append('0');
                }
            }
        }
        buffer.append(year);
        buffer.append('-');
        buffer.append(SMALL_NUMBERS[month + 1]);
        buffer.append('-');
        buffer.append(SMALL_NUMBERS[day + 1]);
    }

    private static void formatTime(int seconds, int leapSecond, int nanoOfSecond, StringBuffer buffer) {
        int q = seconds / 3600;
        buffer.append(SMALL_NUMBERS[q]);
        buffer.append(':');
        q = (seconds %= 3600) / 60;
        buffer.append(SMALL_NUMBERS[q]);
        seconds = seconds % 60 + leapSecond;
        if (seconds > 0 || nanoOfSecond > 0) {
            buffer.append(':');
            buffer.append(SMALL_NUMBERS[seconds]);
            if (nanoOfSecond > 0) {
                buffer.append('.');
                int d = 100000000;
                do {
                    q = nanoOfSecond / d;
                    buffer.append((char)(48 + q));
                } while ((nanoOfSecond %= (d /= 10)) != 0);
            }
        }
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof TimeScaleInstant) {
            return this.format((TimeScaleInstant)obj, toAppendTo, pos);
        }
        if (obj == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("Can't format class as an Instant: " + obj.getClass().getName());
    }

    public StringBuffer format(TimeScaleInstant instant, StringBuffer toAppendTo, FieldPosition pos) {
        long date;
        long s = instant.getEpochSeconds();
        int time = (int)(s - (date = s / SECONDS_PER_DAY) * SECONDS_PER_DAY);
        if (time < 0) {
            --date;
            time = (int)((long)time + SECONDS_PER_DAY);
        }
        TimeScaleInstantFormat.formatDate(date, toAppendTo);
        toAppendTo.append('T');
        TimeScaleInstantFormat.formatTime(time, instant.getLeapSecond(), instant.getNanoOfSecond(), toAppendTo);
        toAppendTo.append('[');
        toAppendTo.append(instant.getTimeScale().getName());
        toAppendTo.append(']');
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException("Not implemented");
    }

    static {
        int i;
        SECONDS_PER_DAY = 86400L;
        DAYS_STANDARD_YEAR = 365;
        DAYS_JULIAN_CYCLE = 4 * DAYS_STANDARD_YEAR + 1;
        DAYS_STANDARD_CENTURY = 25 * DAYS_JULIAN_CYCLE - 1;
        DAYS_GREGORIAN_CYCLE = 4 * DAYS_STANDARD_CENTURY + 1;
        DATE_1600_03_01 = 3 * DAYS_STANDARD_CENTURY + 17 * DAYS_JULIAN_CYCLE + 2 * DAYS_STANDARD_YEAR - 59;
        SMALL_NUMBERS = new String[62];
        char[] text = new char[2];
        text[0] = 48;
        for (i = 0; i < 10; ++i) {
            text[1] = (char)(48 + i);
            TimeScaleInstantFormat.SMALL_NUMBERS[i] = new String(text);
        }
        for (i = 10; i < SMALL_NUMBERS.length; ++i) {
            text[0] = (char)(48 + i / 10);
            text[1] = (char)(48 + i % 10);
            TimeScaleInstantFormat.SMALL_NUMBERS[i] = new String(text);
        }
        INSTANCE = new TimeScaleInstantFormat();
    }
}

