/*
 * Decompiled with CFR 0.152.
 */
package javax.time.scales;

import java.io.Serializable;
import javax.time.Duration;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.MathUtils;
import javax.time.scales.EarlyUTC_TAI;
import javax.time.scales.LeapSeconds;
import javax.time.scales.ScaleUtil;
import javax.time.scales.TAI;
import javax.time.scales.TimeScale;
import javax.time.scales.TimeScaleInstant;

class UTC
implements TimeScale,
Serializable {
    static final UTC INSTANCE = new UTC();
    static final String NAME = "UTC";
    private static final long serialVersionUID = 1L;

    private UTC() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean supportsLeapSecond() {
        return false;
    }

    @Override
    public Instant toInstant(TimeScaleInstant tsInstant) {
        if (tsInstant.getTimeScale() != this) {
            return tsInstant.getTimeScale().toInstant(tsInstant);
        }
        return Instant.seconds(tsInstant.getEpochSeconds(), tsInstant.getNanoOfSecond());
    }

    @Override
    public TimeScaleInstant toTAI(TimeScaleInstant src) {
        if (src.getTimeScale() != this) {
            return src.getTimeScale().toTAI(src);
        }
        return ScaleUtil.tai(src.getEpochSeconds(), src.getNanoOfSecond());
    }

    @Override
    public TimeScaleInstant toTimeScaleInstant(InstantProvider instantProvider) {
        Instant t = Instant.from(instantProvider);
        return TimeScaleInstant.seconds(this, t.getEpochSeconds(), t.getNanoOfSecond());
    }

    @Override
    public TimeScaleInstant toTimeScaleInstant(TimeScaleInstant src) {
        if (src.getTimeScale() == this) {
            return src;
        }
        String srcName = src.getTimeScale().getName();
        if (srcName == "TrueUTC") {
            return TimeScaleInstant.seconds(this, src.getEpochSeconds(), src.getNanoOfSecond());
        }
        if (srcName != "TAI") {
            src = src.getTimeScale().toTAI(src);
        }
        return this.fromTAI(src);
    }

    private TimeScaleInstant fromTAI(TimeScaleInstant tsInstant) {
        if (tsInstant.compareTo(TAI.START_LEAP_SECONDS) >= 0) {
            return this.fromModernTAI(tsInstant);
        }
        if (tsInstant.compareTo(TAI.START_TAI) > 0) {
            return this.fromEarlyTAI(tsInstant);
        }
        return TimeScaleInstant.seconds(this, tsInstant.getEpochSeconds(), tsInstant.getNanoOfSecond());
    }

    private TimeScaleInstant fromModernTAI(TimeScaleInstant tsInstant) {
        LeapSeconds.Entry e = LeapSeconds.list().entryFromTAI(tsInstant);
        long s = MathUtils.safeSubtract(tsInstant.getEpochSeconds(), (long)e.getDeltaSeconds());
        if (e.getNext() != null && s == e.getNext().getStartEpochSeconds()) {
            --s;
        }
        return TimeScaleInstant.seconds(this, s, tsInstant.getNanoOfSecond());
    }

    private TimeScaleInstant fromEarlyTAI(TimeScaleInstant tsInstant) {
        EarlyUTC_TAI.Entry e = EarlyUTC_TAI.list().entryFromTAI(tsInstant);
        long nanos = (long)tsInstant.getNanoOfSecond() - e.getTAIDeltaNanoseconds(tsInstant.getEpochSeconds(), tsInstant.getNanoOfSecond());
        long s = MathUtils.safeAdd(tsInstant.getEpochSeconds(), nanos / 1000000000L);
        if ((nanos %= 1000000000L) < 0L) {
            --s;
            nanos += 1000000000L;
        }
        if (s == e.getEndEpochSeconds() && (nanos -= (long)e.getUTCGapNanoseconds()) < 0L) {
            --s;
            nanos += 1000000000L;
        }
        return TimeScaleInstant.seconds(this, s, (int)nanos);
    }

    @Override
    public TimeScaleInstant.Validity getValidity(TimeScaleInstant instant) {
        if (instant.getTimeScale() != this) {
            return instant.getTimeScale().getValidity(instant);
        }
        long s = instant.getEpochSeconds();
        if (s >= ScaleUtil.START_LEAP_SECONDS) {
            return this.checkLeapAmbiguity(instant);
        }
        if (s <= ScaleUtil.START_TAI) {
            return TimeScaleInstant.Validity.VALID;
        }
        return ScaleUtil.checkEarlyValidity(instant);
    }

    private TimeScaleInstant.Validity checkLeapAmbiguity(TimeScaleInstant instant) {
        LeapSeconds.Entry e = LeapSeconds.list().entryFromUTC(instant.getEpochSeconds());
        return e.getNext() != null && instant.getEpochSeconds() == e.getNext().getStartEpochSeconds() - 1L ? TimeScaleInstant.Validity.AMBIGUOUS : TimeScaleInstant.Validity.VALID;
    }

    @Override
    public TimeScaleInstant add(TimeScaleInstant t, Duration d) {
        if (t.getTimeScale() != this) {
            return t.getTimeScale().add(t, d);
        }
        long seconds = d.getSeconds();
        int nanos = d.getNanosInSecond();
        if (seconds == 0L && nanos == 0) {
            return t;
        }
        seconds = MathUtils.safeAdd(t.getEpochSeconds(), seconds);
        if ((nanos += t.getNanoOfSecond()) >= 1000000000) {
            nanos -= 1000000000;
            seconds = MathUtils.safeIncrement(seconds);
        }
        if (seconds < ScaleUtil.START_LEAP_SECONDS && seconds > ScaleUtil.START_TAI) {
            return ScaleUtil.adjustUTCAroundGaps(t, seconds, nanos);
        }
        return TimeScaleInstant.seconds(this, seconds, nanos);
    }

    @Override
    public TimeScaleInstant subtract(TimeScaleInstant t, Duration d) {
        if (t.getTimeScale() != this) {
            return t.getTimeScale().subtract(t, d);
        }
        long seconds = d.getSeconds();
        int nanos = d.getNanosInSecond();
        if (seconds == 0L && nanos == 0) {
            return t;
        }
        seconds = MathUtils.safeSubtract(t.getEpochSeconds(), seconds);
        nanos = t.getNanoOfSecond() - nanos;
        if (nanos < 0) {
            nanos += 1000000000;
            seconds = MathUtils.safeDecrement(seconds);
        }
        if (seconds < ScaleUtil.START_LEAP_SECONDS && seconds > ScaleUtil.START_TAI) {
            return ScaleUtil.adjustUTCAroundGaps(t, seconds, nanos);
        }
        return TimeScaleInstant.seconds(this, seconds, nanos);
    }

    @Override
    public Duration durationBetween(TimeScaleInstant a, TimeScaleInstant b) {
        if (a.getTimeScale() != this) {
            a = this.toTimeScaleInstant(a);
        }
        if (b.getTimeScale() != this) {
            b = this.toTimeScaleInstant(b);
        }
        return ScaleUtil.durationBetween(a, b);
    }
}

