/*
 * Decompiled with CFR 0.152.
 */
package javax.time.scales;

import java.util.AbstractList;
import javax.time.scales.TAI;
import javax.time.scales.TimeScaleInstant;
import javax.time.scales.UTCPeriod;

public class UTC_TAI<P extends UTCPeriod>
extends AbstractList<P> {
    private P[] entries;

    UTC_TAI(P[] entries) {
        this.entries = entries;
        UTCPeriod p = null;
        for (int i = 0; i < entries.length; ++i) {
            P e = entries[i];
            ((UTCPeriod)e).initialise(p);
            p = (UTCPeriod)e;
        }
    }

    public P entryFromUTC(long utcEpochSeconds) {
        int left = 0;
        int right = this.entries.length;
        while (left < right) {
            int m = left + (right - left >> 1);
            if (utcEpochSeconds < ((UTCPeriod)this.entries[m]).getStartEpochSeconds()) {
                right = m;
                continue;
            }
            left = m + 1;
        }
        if (right == 0) {
            throw new IllegalArgumentException("Value below lower bound");
        }
        return this.entries[right - 1];
    }

    public P entryFromTAI(TimeScaleInstant t) {
        if (t.getTimeScale() != TAI.INSTANCE) {
            throw new IllegalArgumentException("Require TAI instant");
        }
        int left = 0;
        int right = this.entries.length;
        while (left < right) {
            int m = left + (right - left >> 1);
            if (t.compareTo(((UTCPeriod)this.entries[m]).getStartTAI()) < 0) {
                right = m;
                continue;
            }
            left = m + 1;
        }
        if (right == 0) {
            throw new IllegalArgumentException("Value below lower bound");
        }
        return this.entries[right - 1];
    }

    public P entryFromTAI(long epochSeconds, int nanoOfSecond) {
        int left = 0;
        int right = this.entries.length;
        while (left < right) {
            int m = left + (right - left >> 1);
            TimeScaleInstant ts = ((UTCPeriod)this.entries[m]).getStartTAI();
            int z = epochSeconds < ts.getEpochSeconds() ? -1 : (epochSeconds > ts.getEpochSeconds() ? 1 : nanoOfSecond - ts.getNanoOfSecond());
            if (z < 0) {
                right = m;
                continue;
            }
            left = m + 1;
        }
        if (right == 0) {
            throw new IllegalArgumentException("Value below lower bound");
        }
        return this.entries[right - 1];
    }

    @Override
    public P get(int index) {
        return this.entries[index];
    }

    @Override
    public int size() {
        return this.entries.length;
    }
}

