/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.jasper.util.SystemLogHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

public class AntCompiler
extends Compiler {
    protected Project project = null;
    protected JasperAntLogger logger;

    protected Project getProject() {
        if (this.project != null) {
            return this.project;
        }
        this.project = new Project();
        this.logger = new JasperAntLogger();
        this.logger.setOutputPrintStream(System.out);
        this.logger.setErrorPrintStream(System.err);
        this.logger.setMessageOutputLevel(2);
        this.project.addBuildListener((BuildListener)this.logger);
        if (System.getProperty("catalina.home") != null) {
            this.project.setBasedir(System.getProperty("catalina.home"));
        }
        if (this.options.getCompiler() != null) {
            this.project.setProperty("build.compiler", this.options.getCompiler());
        }
        this.project.init();
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateClass(String[] smap) throws FileNotFoundException, JasperException, Exception {
        BuildException be;
        StringBuffer errorReport;
        String javaFileName;
        block21: {
            long t1 = 0L;
            String javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            javaFileName = this.ctxt.getServletJavaFileName();
            String classpath = this.ctxt.getClassPath();
            String sep = System.getProperty("path.separator");
            errorReport = new StringBuffer();
            StringBuffer info = new StringBuffer();
            info.append("Compile: javaFileName=" + javaFileName + "\n");
            info.append("    classpath=" + classpath + "\n");
            SystemLogHandler.setThread();
            this.getProject();
            Javac javac = (Javac)this.project.createTask("javac");
            Path path = new Path(this.project);
            path.setPath(System.getProperty("java.class.path"));
            info.append("    cp=" + System.getProperty("java.class.path") + "\n");
            StringTokenizer tokenizer = new StringTokenizer(classpath, sep);
            while (tokenizer.hasMoreElements()) {
                String pathElement = tokenizer.nextToken();
                File repository = new File(pathElement);
                path.setLocation(repository);
                info.append("    cp=" + repository + "\n");
            }
            Path srcPath = new Path(this.project);
            srcPath.setLocation(this.options.getScratchDir());
            info.append("    work dir=" + this.options.getScratchDir() + "\n");
            String exts = System.getProperty("java.ext.dirs");
            if (exts != null) {
                Path extdirs = new Path(this.project);
                extdirs.setPath(exts);
                javac.setExtdirs(extdirs);
                info.append("    extension dir=" + exts + "\n");
            }
            if (this.ctxt.getOptions().getFork()) {
                String endorsed = System.getProperty("java.endorsed.dirs");
                if (endorsed != null) {
                    Javac.ImplementationSpecificArgument endorsedArg = javac.createCompilerArg();
                    endorsedArg.setLine("-J-Djava.endorsed.dirs=" + endorsed);
                    info.append("    endorsed dir=" + endorsed + "\n");
                } else {
                    info.append("    no endorsed dirs specified\n");
                }
            }
            javac.setEncoding(javaEncoding);
            javac.setClasspath(path);
            javac.setDebug(this.ctxt.getOptions().getClassDebugInfo());
            javac.setSrcdir(srcPath);
            javac.setTempdir(this.options.getScratchDir());
            javac.setOptimize(!this.ctxt.getOptions().getClassDebugInfo());
            javac.setFork(this.ctxt.getOptions().getFork());
            info.append("    srcDir=" + srcPath + "\n");
            if (this.options.getCompiler() != null) {
                javac.setCompiler(this.options.getCompiler());
                info.append("    compiler=" + this.options.getCompiler() + "\n");
            }
            if (this.options.getCompilerTargetVM() != null) {
                javac.setTarget(this.options.getCompilerTargetVM());
                info.append("   compilerTargetVM=" + this.options.getCompilerTargetVM() + "\n");
            }
            if (this.options.getCompilerSourceVM() != null) {
                javac.setSource(this.options.getCompilerSourceVM());
                info.append("   compilerSourceVM=" + this.options.getCompilerSourceVM() + "\n");
            }
            PatternSet.NameEntry includes = javac.createInclude();
            includes.setName(this.ctxt.getJavaPath());
            info.append("    include=" + this.ctxt.getJavaPath() + "\n");
            be = null;
            try {
                if (this.ctxt.getOptions().getFork()) {
                    javac.execute();
                    break block21;
                }
                Object object = javacLock;
                synchronized (object) {
                    javac.execute();
                }
            }
            catch (BuildException e) {
                be = e;
            }
        }
        errorReport.append(this.logger.getReport());
        String errorCapture = SystemLogHandler.unsetThread();
        if (errorCapture != null) {
            errorReport.append(System.getProperty("line.separator"));
            errorReport.append(errorCapture);
        }
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (be != null) {
            String errorReportString = errorReport.toString();
            JavacErrorDetail[] javacErrors = ErrorDispatcher.parseJavacErrors(errorReportString, javaFileName, this.pageNodes);
            if (javacErrors != null) {
                this.errDispatcher.javacError(javacErrors);
            } else {
                this.errDispatcher.javacError(errorReportString, (Exception)((Object)be));
            }
        }
        this.logger = null;
        this.project = null;
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(smap);
        }
    }

    static {
        System.setErr(new SystemLogHandler(System.err));
    }

    class JasperAntLogger
    extends DefaultLogger {
        protected StringBuffer reportBuf = new StringBuffer();

        JasperAntLogger() {
        }

        protected void printMessage(String message, PrintStream stream, int priority) {
        }

        protected void log(String message) {
            this.reportBuf.append(message);
            this.reportBuf.append(System.getProperty("line.separator"));
        }

        protected String getReport() {
            String report = this.reportBuf.toString();
            this.reportBuf.setLength(0);
            return report;
        }
    }
}

