/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jfree.util.ObjectUtilities;

public class ObjectTable
implements Serializable {
    private int rows;
    private int columns;
    private transient Object[][] data;
    private int rowIncrement;
    private int columnIncrement;

    public ObjectTable() {
        this(5, 5);
    }

    public ObjectTable(int increment) {
        this(increment, increment);
    }

    public ObjectTable(int rowIncrement, int colIncrement) {
        if (rowIncrement < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        if (colIncrement < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        this.rows = 0;
        this.columns = 0;
        this.rowIncrement = rowIncrement;
        this.columnIncrement = colIncrement;
        this.data = new Object[rowIncrement][];
    }

    public void clear() {
        this.rows = 0;
        this.columns = 0;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] != null) {
                Arrays.fill(this.data[i], null);
            }
            ++i;
        }
    }

    public void ensureCapacity(int row, int column) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("Row is invalid. " + row);
        }
        if (column < 0) {
            throw new IndexOutOfBoundsException("Column is invalid. " + column);
        }
        this.ensureRowCapacity(row);
        Object[] current = this.data[row];
        if (current == null) {
            Object[] enlarged = new Object[Math.max(column + 1, this.columnIncrement)];
            this.data[row] = enlarged;
        } else if (column >= current.length) {
            Object[] enlarged = new Object[column + this.columnIncrement];
            System.arraycopy(current, 0, enlarged, 0, current.length);
            this.data[row] = enlarged;
        }
    }

    protected void ensureRowCapacity(int row) {
        if (row >= this.data.length) {
            Object[][] enlarged = new Object[row + this.rowIncrement][];
            System.arraycopy(this.data, 0, enlarged, 0, this.data.length);
            this.data = enlarged;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectTable)) {
            return false;
        }
        ObjectTable ot = (ObjectTable)o;
        if (this.getRowCount() != ot.getRowCount()) {
            return false;
        }
        if (this.getColumnCount() != ot.getColumnCount()) {
            return false;
        }
        int r = 0;
        while (r < this.getRowCount()) {
            int c = 0;
            while (c < this.getColumnCount()) {
                if (!ObjectUtilities.equal(this.getObject(r, c), ot.getObject(r, c))) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public int getColumnIncrement() {
        return this.columnIncrement;
    }

    protected Object getObject(int row, int column) {
        if (row < this.data.length) {
            Object[] current = this.data[row];
            if (current == null) {
                return null;
            }
            if (column < current.length) {
                return current[column];
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getRowIncrement() {
        return this.rowIncrement;
    }

    public int hashCode() {
        int result = this.rows;
        result = 29 * result + this.columns;
        return result;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int rowCount = stream.readInt();
        this.data = new Object[rowCount][];
        int r = 0;
        while (r < rowCount) {
            boolean isNotNull = stream.readBoolean();
            if (isNotNull) {
                int columnCount = stream.readInt();
                Object[] column = new Object[columnCount];
                this.data[r] = column;
                int c = 0;
                while (c < columnCount) {
                    column[c] = this.readSerializedData(stream);
                    ++c;
                }
            }
            ++r;
        }
    }

    protected Object readSerializedData(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        return stream.readObject();
    }

    protected void setObject(int row, int column, Object object) {
        this.ensureCapacity(row, column);
        this.data[row][column] = object;
        this.rows = Math.max(this.rows, row + 1);
        this.columns = Math.max(this.columns, column + 1);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int rowCount = this.data.length;
        stream.writeInt(rowCount);
        int r = 0;
        while (r < rowCount) {
            Object[] column = this.data[r];
            stream.writeBoolean(column != null);
            if (column != null) {
                int columnCount = column.length;
                stream.writeInt(columnCount);
                int c = 0;
                while (c < columnCount) {
                    this.writeSerializedData(stream, column[c]);
                    ++c;
                }
            }
            ++r;
        }
    }

    protected void writeSerializedData(ObjectOutputStream stream, Object o) throws IOException {
        stream.writeObject(o);
    }
}

