/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import org.jfree.util.Log;

public class ResourceBundleSupport {
    private ResourceBundle resources;
    private TreeMap cache;
    private TreeSet lookupPath;
    private String resourceBase;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public ResourceBundleSupport(String baseName) {
        this(ResourceBundle.getBundle(baseName), baseName);
    }

    public ResourceBundleSupport(ResourceBundle resourceBundle) {
        this(resourceBundle, resourceBundle.toString());
    }

    protected ResourceBundleSupport(ResourceBundle resourceBundle, String baseName) {
        this.resources = resourceBundle;
        this.resourceBase = baseName;
        this.cache = new TreeMap();
        this.lookupPath = new TreeSet();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private ImageIcon createIcon(String resourceName, boolean scale, boolean large) {
        URL in = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (in == null) {
            Log.warn("Unable to find file in the class path: " + resourceName);
            return new ImageIcon(this.createTransparentImage(1, 1));
        }
        Image img = Toolkit.getDefaultToolkit().createImage(in);
        if (img == null) {
            Log.warn("Unable to instantiate the image: " + resourceName);
            return new ImageIcon(this.createTransparentImage(1, 1));
        }
        if (scale) {
            if (large) {
                return new ImageIcon(img.getScaledInstance(24, 24, 4));
            }
            return new ImageIcon(img.getScaledInstance(16, 16, 4));
        }
        return new ImageIcon(img);
    }

    public JMenu createMenu(String keyPrefix) {
        JMenu retval = new JMenu();
        retval.setText(this.getString(String.valueOf(keyPrefix) + ".name"));
        retval.setMnemonic(this.getMnemonic(String.valueOf(keyPrefix) + ".mnemonic"));
        return retval;
    }

    private final KeyStroke createMenuKeystroke(String key) {
        return KeyStroke.getKeyStroke(this.createMnemonic(key), this.getMenuKeyMask());
    }

    private Integer createMnemonic(String keyString) {
        if (keyString == null) {
            throw new NullPointerException("Key is null.");
        }
        if (keyString.length() == 0) {
            throw new IllegalArgumentException("Key is empty.");
        }
        int character = keyString.charAt(0);
        if (keyString.startsWith("VK_")) {
            try {
                Field f = (class$java$awt$event$KeyEvent != null ? class$java$awt$event$KeyEvent : (class$java$awt$event$KeyEvent = ResourceBundleSupport.class$("java.awt.event.KeyEvent"))).getField(keyString);
                Integer keyCode = (Integer)f.get(null);
                character = keyCode;
            }
            catch (Exception exception) {}
        }
        return new Integer(character);
    }

    public Icon createTransparentIcon(int width, int height) {
        return new ImageIcon(this.createTransparentImage(width, height));
    }

    private BufferedImage createTransparentImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        int[] data = img.getRGB(0, 0, width, height, null, 0, width);
        Arrays.fill(data, 0);
        img.setRGB(0, 0, width, height, data, 0, width);
        return img;
    }

    public String formatMessage(String key, Object parameter) {
        return MessageFormat.format(this.getString(key), parameter);
    }

    public String formatMessage(String key, Object par1, Object par2) {
        return MessageFormat.format(this.getString(key), par1, par2);
    }

    public String formatMessage(String key, Object[] parameters) {
        return MessageFormat.format(this.getString(key), parameters);
    }

    public Icon getIcon(String key) {
        String name = this.getString(key);
        return this.createIcon(name, false, false);
    }

    public Icon getIcon(String key, boolean large) {
        String name = this.getString(key);
        return this.createIcon(name, true, large);
    }

    public KeyStroke getKeyStroke(String key) {
        String name = this.getString(key);
        return this.createMenuKeystroke(name);
    }

    private int getMenuKeyMask() {
        try {
            return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return 2;
        }
    }

    public Integer getMnemonic(String key) {
        String name = this.getString(key);
        return this.createMnemonic(name);
    }

    protected final String getResourceBase() {
        return this.resourceBase;
    }

    public URL getResourceURL(String key) {
        String name = this.getString(key);
        URL in = Thread.currentThread().getContextClassLoader().getResource(name);
        if (in == null) {
            Log.warn("Unable to find file in the class path: " + name + "; key=" + key);
        }
        return in;
    }

    public synchronized String getString(String key) {
        String retval = (String)this.cache.get(key);
        if (retval != null) {
            return retval;
        }
        this.lookupPath.clear();
        return this.internalGetString(key);
    }

    protected String internalGetString(String key) {
        if (this.lookupPath.contains(key)) {
            throw new MissingResourceException("InfiniteLoop in resource lookup", this.getResourceBase(), this.lookupPath.toString());
        }
        String fromResBundle = this.resources.getString(key);
        if (fromResBundle.startsWith("@@")) {
            int idx = fromResBundle.indexOf(64, 2);
            if (idx == -1) {
                throw new MissingResourceException("Invalid format for global lookup key.", this.getResourceBase(), key);
            }
            try {
                ResourceBundle res = ResourceBundle.getBundle(fromResBundle.substring(2, idx));
                return res.getString(fromResBundle.substring(idx + 1));
            }
            catch (Exception e) {
                Log.error("Error during global lookup", e);
                throw new MissingResourceException("Error during global lookup", this.getResourceBase(), key);
            }
        }
        if (fromResBundle.startsWith("@")) {
            String newKey = fromResBundle.substring(1);
            this.lookupPath.add(key);
            String retval = this.internalGetString(newKey);
            this.cache.put(key, retval);
            return retval;
        }
        this.cache.put(key, fromResBundle);
        return fromResBundle;
    }
}

