/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.jsr94.tck.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.rules.ConfigurationException;
import javax.rules.RuleRuntime;
import javax.rules.RuleServiceProvider;
import javax.rules.RuleServiceProviderManager;
import javax.rules.StatefulRuleSession;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jcp.jsr94.tck.util.TestFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class TestCaseUtil {
    private static String ruleServiceProvider;
    private static String ruleExecutionSetUri;
    private static Vector ruleServiceProviderJarURLs;
    private static String ruleExecutionSetLocation;
    private static String testFactory;

    public static String getTestFactory() {
        if (testFactory == null) {
            TestCaseUtil.parseTckConfiguration();
        }
        return testFactory;
    }

    public static String getRuleServiceProvider() {
        if (ruleServiceProvider == null) {
            TestCaseUtil.parseTckConfiguration();
        }
        return ruleServiceProvider;
    }

    public static String getRuleExecutionSetUri() {
        if (ruleExecutionSetUri == null) {
            TestCaseUtil.parseTckConfiguration();
        }
        return ruleExecutionSetUri;
    }

    public static RuleServiceProvider getRuleServiceProvider(String uri, URL[] urls) throws ClassNotFoundException, ConfigurationException {
        if (ruleServiceProvider == null) {
            TestCaseUtil.parseTckConfiguration();
        }
        if (ruleServiceProvider == null) {
            throw new ClassNotFoundException("rule-service-provider not specified");
        }
        URLClassLoader cl = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        Class<?> ruleServiceProviderClass = cl.loadClass(ruleServiceProvider);
        TestCase.assertNotNull((String)("[TestCaseUtil] Class loading on " + ruleServiceProvider + " failed. "), ruleServiceProviderClass);
        RuleServiceProviderManager.registerRuleServiceProvider((String)uri, ruleServiceProviderClass, (ClassLoader)cl);
        return RuleServiceProviderManager.getRuleServiceProvider((String)uri);
    }

    public static String getRuleExecutionSetLocation() {
        if (ruleExecutionSetLocation == null) {
            TestCaseUtil.parseTckConfiguration();
        }
        return ruleExecutionSetLocation;
    }

    public static Vector getRuleServiceProviderJarURLs() {
        if (ruleServiceProviderJarURLs == null) {
            TestCaseUtil.parseTckConfiguration();
        }
        return ruleServiceProviderJarURLs;
    }

    public static RuleServiceProvider getRuleServiceProvider(String uri) throws ClassNotFoundException, ConfigurationException {
        if (ruleServiceProvider == null) {
            TestCaseUtil.parseTckConfiguration();
        }
        if (ruleServiceProvider == null) {
            throw new ClassNotFoundException("rule-service-provider not specified");
        }
        Class<?> ruleServiceProviderClass = Class.forName(ruleServiceProvider);
        TestCase.assertNotNull((String)("[TestCaseUtil] Class.forName on " + ruleServiceProvider + " failed. "), ruleServiceProviderClass);
        RuleServiceProviderManager.registerRuleServiceProvider((String)uri, ruleServiceProviderClass);
        return RuleServiceProviderManager.getRuleServiceProvider((String)uri);
    }

    public static StatefulRuleSession getStatefulRuleSession(String uri, String ruleExecutionSetUri) throws Exception {
        RuleServiceProvider serviceProvider = TestCaseUtil.getRuleServiceProvider(uri);
        TestCase.assertNotNull((String)("[TestCaseUtil] RuleServiceProvider " + uri + " not found."), (Object)serviceProvider);
        RuleAdministrator ruleAdministration = serviceProvider.getRuleAdministrator();
        TestCase.assertNotNull((String)"[TestCaseUtil] RuleAdministrator not found.", (Object)ruleAdministration);
        InputStream inStream = TestCaseUtil.getRuleExecutionSetInputStream(ruleExecutionSetUri);
        TestCase.assertNotNull((String)"[TestCaseUtil] inStream non null", (Object)inStream);
        RuleExecutionSet res = ruleAdministration.getLocalRuleExecutionSetProvider(TestFactory.newInstance().createLocalRuleExecutionSetProviderMap()).createRuleExecutionSet(inStream, TestFactory.newInstance().createRuleExecutionSetMap());
        TestCase.assertNotNull((String)("[TestCaseUtil] RuleExecutionSet " + ruleExecutionSetUri + " could not be created."), (Object)res);
        inStream.close();
        ruleAdministration.registerRuleExecutionSet(uri, res, TestFactory.newInstance().createRegisterRuleExecutionSetMap());
        RuleRuntime ruleRuntime = serviceProvider.getRuleRuntime();
        TestCase.assertNotNull((String)"[TestCaseUtil] RuleRuntime not created.", (Object)ruleRuntime);
        StatefulRuleSession session = (StatefulRuleSession)ruleRuntime.createRuleSession(uri, TestFactory.newInstance().createRuleSessionMap(0), 0);
        TestCase.assertNotNull((String)"[TestCaseUtil] StatefulRuleSession not created.", (Object)session);
        return session;
    }

    public static StatelessRuleSession getStatelessRuleSession(String uri, String ruleExecutionSetUri) throws Exception {
        RuleServiceProvider serviceProvider = TestCaseUtil.getRuleServiceProvider(uri);
        TestCase.assertNotNull((String)("[TestCaseUtil] RuleServiceProvider " + uri + " not found."), (Object)serviceProvider);
        RuleAdministrator ruleAdministration = serviceProvider.getRuleAdministrator();
        TestCase.assertNotNull((String)"[TestCaseUtil] RuleAdministrator not found.", (Object)ruleAdministration);
        InputStream inStream = TestCaseUtil.getRuleExecutionSetInputStream(ruleExecutionSetUri);
        RuleExecutionSet res = ruleAdministration.getLocalRuleExecutionSetProvider(TestFactory.newInstance().createLocalRuleExecutionSetProviderMap()).createRuleExecutionSet(inStream, TestFactory.newInstance().createRuleExecutionSetMap());
        TestCase.assertNotNull((String)("[TestCaseUtil] RuleExecutionSet " + ruleExecutionSetUri + " could not be created."), (Object)res);
        inStream.close();
        ruleAdministration.registerRuleExecutionSet(uri, res, TestFactory.newInstance().createRegisterRuleExecutionSetMap());
        RuleRuntime ruleRuntime = serviceProvider.getRuleRuntime();
        TestCase.assertNotNull((String)"[TestCaseUtil] RuleRuntime not created.", (Object)ruleRuntime);
        return (StatelessRuleSession)ruleRuntime.createRuleSession(uri, TestFactory.newInstance().createRuleSessionMap(1), 1);
    }

    public static InputStream getRuleExecutionSetInputStream(String ruleExecutionSetUri) {
        String location = TestCaseUtil.getRuleExecutionSetLocation();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(location + "/" + ruleExecutionSetUri);
            TestCase.assertNotNull((String)("[TestCaseUtil] Input stream for " + location + "/" + ruleExecutionSetUri + " could not be created."), (Object)inStream);
        }
        catch (FileNotFoundException e) {
            TestCase.fail((String)e.getMessage());
        }
        return inStream;
    }

    public static Reader getRuleExecutionSetReader(String ruleExecutionSetUri) {
        if (ruleExecutionSetLocation == null) {
            TestCaseUtil.parseTckConfiguration();
        }
        FileReader reader = null;
        try {
            reader = new FileReader(ruleExecutionSetLocation + "/" + ruleExecutionSetUri);
            TestCase.assertNotNull((String)("[TestCaseUtil] Reader for " + ruleExecutionSetLocation + "/" + ruleExecutionSetUri + " could not be created."), (Object)reader);
        }
        catch (FileNotFoundException e) {
            TestCase.fail((String)e.getMessage());
        }
        return reader;
    }

    public static Element getRuleExecutionSetDocumentElement(String ruleExecutionSetUri) {
        Document resDoc = null;
        InputStream inStream = TestCaseUtil.getRuleExecutionSetInputStream(ruleExecutionSetUri);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            resDoc = db.parse(inStream);
            inStream.close();
        }
        catch (Exception e) {
            TestCase.fail((String)e.getMessage());
        }
        return resDoc.getDocumentElement();
    }

    private static void parseTckConfiguration() {
        try {
            String libDir = System.getProperty("jsr94.tck.configuration");
            if (libDir == null || libDir.length() == 0) {
                libDir = "./lib";
            }
            FileInputStream inStream = new FileInputStream(libDir + "/tck.conf");
            Document configurationDoc = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            configurationDoc = db.parse(inStream);
            ((InputStream)inStream).close();
            Element documentElement = configurationDoc.getDocumentElement();
            NodeList confNodeList = documentElement.getChildNodes();
            ruleServiceProviderJarURLs = new Vector(4);
            for (int i = 0; i < confNodeList.getLength(); ++i) {
                Node childNode = confNodeList.item(i);
                if (childNode == null) continue;
                String nodeName = childNode.getNodeName();
                if (nodeName.equals("rule-service-provider")) {
                    ruleServiceProvider = childNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodeName.equals("test-factory")) {
                    testFactory = childNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodeName.equals("rule-execution-set-uri")) {
                    ruleExecutionSetUri = childNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodeName.equals("rule-service-provider-jar-url")) {
                    String el = childNode.getFirstChild().getNodeValue();
                    ruleServiceProviderJarURLs.addElement(el);
                    continue;
                }
                if (!nodeName.equals("rule-execution-set-location")) continue;
                ruleExecutionSetLocation = childNode.getFirstChild().getNodeValue();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void processTestException(Exception e, TestCase test, String methName) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        e.printStackTrace(printer);
        printer.flush();
        String msg = writer.toString();
        String lineno = null;
        String fullname = test.getClass().getName() + "." + methName;
        StringTokenizer tokens = new StringTokenizer(msg, "\n\r");
        while (tokens.hasMoreElements()) {
            int i2;
            int i1;
            String next = (String)tokens.nextElement();
            if (next.indexOf(fullname) < 0 || (i1 = next.lastIndexOf(58)) < 0 || (i2 = next.lastIndexOf(41)) < 0 || i2 <= i1) continue;
            lineno = next.substring(i1 + 1, i2);
            break;
        }
        if (lineno != null) {
            Assert.fail((String)("Exception thrown at line " + lineno + ":\n" + e.getMessage()));
        } else {
            Assert.fail((String)("Exception thrown:\n" + e.getMessage()));
        }
    }
}

