/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package link.thingscloud.freeswitch.esl.constant;

/**
 * <p>EventNames class.</p>
 *
 * @author : <a href="mailto:ant.zhou@aliyun.com">zhouhailin</a>
 * @version $Id: $Id
 */
public class EventNames {
    /**
     * Constant <code>CUSTOM="CUSTOM"</code>
     */
    public static final String CUSTOM = "CUSTOM";
    /**
     * Constant <code>CLONE="CLONE"</code>
     */
    public static final String CLONE = "CLONE";
    /**
     * Constant <code>CHANNEL_CREATE="CHANNEL_CREATE"</code>
     */
    public static final String CHANNEL_CREATE = "CHANNEL_CREATE";
    /**
     * Constant <code>CHANNEL_DESTROY="CHANNEL_DESTROY"</code>
     */
    public static final String CHANNEL_DESTROY = "CHANNEL_DESTROY";
    /**
     * Constant <code>CHANNEL_STATE="CHANNEL_STATE"</code>
     */
    public static final String CHANNEL_STATE = "CHANNEL_STATE";
    /**
     * Constant <code>CHANNEL_CALLSTATE="CHANNEL_CALLSTATE"</code>
     */
    public static final String CHANNEL_CALLSTATE = "CHANNEL_CALLSTATE";
    /**
     * Constant <code>CHANNEL_ANSWER="CHANNEL_ANSWER"</code>
     */
    public static final String CHANNEL_ANSWER = "CHANNEL_ANSWER";
    /**
     * Constant <code>CHANNEL_HANGUP="CHANNEL_HANGUP"</code>
     */
    public static final String CHANNEL_HANGUP = "CHANNEL_HANGUP";
    /**
     * Constant <code>CHANNEL_HANGUP_COMPLETE="CHANNEL_HANGUP_COMPLETE"</code>
     */
    public static final String CHANNEL_HANGUP_COMPLETE = "CHANNEL_HANGUP_COMPLETE";
    /**
     * Constant <code>CHANNEL_EXECUTE="CHANNEL_EXECUTE"</code>
     */
    public static final String CHANNEL_EXECUTE = "CHANNEL_EXECUTE";
    /**
     * Constant <code>CHANNEL_EXECUTE_COMPLETE="CHANNEL_EXECUTE_COMPLETE"</code>
     */
    public static final String CHANNEL_EXECUTE_COMPLETE = "CHANNEL_EXECUTE_COMPLETE";
    /**
     * Constant <code>CHANNEL_HOLD="CHANNEL_HOLD"</code>
     */
    public static final String CHANNEL_HOLD = "CHANNEL_HOLD";
    /**
     * Constant <code>CHANNEL_UNHOLD="CHANNEL_UNHOLD"</code>
     */
    public static final String CHANNEL_UNHOLD = "CHANNEL_UNHOLD";
    /**
     * Constant <code>CHANNEL_BRIDGE="CHANNEL_BRIDGE"</code>
     */
    public static final String CHANNEL_BRIDGE = "CHANNEL_BRIDGE";
    /**
     * Constant <code>CHANNEL_UNBRIDGE="CHANNEL_UNBRIDGE"</code>
     */
    public static final String CHANNEL_UNBRIDGE = "CHANNEL_UNBRIDGE";
    /**
     * Constant <code>CHANNEL_PROGRESS="CHANNEL_PROGRESS"</code>
     */
    public static final String CHANNEL_PROGRESS = "CHANNEL_PROGRESS";
    /**
     * Constant <code>CHANNEL_PROGRESS_MEDIA="CHANNEL_PROGRESS_MEDIA"</code>
     */
    public static final String CHANNEL_PROGRESS_MEDIA = "CHANNEL_PROGRESS_MEDIA";
    /**
     * Constant <code>CHANNEL_OUTGOING="CHANNEL_OUTGOING"</code>
     */
    public static final String CHANNEL_OUTGOING = "CHANNEL_OUTGOING";
    /**
     * Constant <code>CHANNEL_PARK="CHANNEL_PARK"</code>
     */
    public static final String CHANNEL_PARK = "CHANNEL_PARK";
    /**
     * Constant <code>CHANNEL_UNPARK="CHANNEL_UNPARK"</code>
     */
    public static final String CHANNEL_UNPARK = "CHANNEL_UNPARK";
    /**
     * Constant <code>CHANNEL_APPLICATION="CHANNEL_APPLICATION"</code>
     */
    public static final String CHANNEL_APPLICATION = "CHANNEL_APPLICATION";
    /**
     * Constant <code>CHANNEL_ORIGINATE="CHANNEL_ORIGINATE"</code>
     */
    public static final String CHANNEL_ORIGINATE = "CHANNEL_ORIGINATE";
    /**
     * Constant <code>CHANNEL_UUID="CHANNEL_UUID"</code>
     */
    public static final String CHANNEL_UUID = "CHANNEL_UUID";
    /**
     * Constant <code>API="API"</code>
     */
    public static final String API = "API";
    /**
     * Constant <code>LOG="LOG"</code>
     */
    public static final String LOG = "LOG";
    /**
     * Constant <code>INBOUND_CHAN="INBOUND_CHAN"</code>
     */
    public static final String INBOUND_CHAN = "INBOUND_CHAN";
    /**
     * Constant <code>OUTBOUND_CHAN="OUTBOUND_CHAN"</code>
     */
    public static final String OUTBOUND_CHAN = "OUTBOUND_CHAN";
    /**
     * Constant <code>STARTUP="STARTUP"</code>
     */
    public static final String STARTUP = "STARTUP";
    /**
     * Constant <code>SHUTDOWN="SHUTDOWN"</code>
     */
    public static final String SHUTDOWN = "SHUTDOWN";
    /**
     * Constant <code>PUBLISH="PUBLISH"</code>
     */
    public static final String PUBLISH = "PUBLISH";
    /**
     * Constant <code>UNPUBLISH="UNPUBLISH"</code>
     */
    public static final String UNPUBLISH = "UNPUBLISH";
    /**
     * Constant <code>TALK="TALK"</code>
     */
    public static final String TALK = "TALK";
    /**
     * Constant <code>NOTALK="NOTALK"</code>
     */
    public static final String NOTALK = "NOTALK";
    /**
     * Constant <code>SESSION_CRASH="SESSION_CRASH"</code>
     */
    public static final String SESSION_CRASH = "SESSION_CRASH";
    /**
     * Constant <code>MODULE_LOAD="MODULE_LOAD"</code>
     */
    public static final String MODULE_LOAD = "MODULE_LOAD";
    /**
     * Constant <code>MODULE_UNLOAD="MODULE_UNLOAD"</code>
     */
    public static final String MODULE_UNLOAD = "MODULE_UNLOAD";
    /**
     * Constant <code>DTMF="DTMF"</code>
     */
    public static final String DTMF = "DTMF";
    /**
     * Constant <code>MESSAGE="MESSAGE"</code>
     */
    public static final String MESSAGE = "MESSAGE";
    /**
     * Constant <code>PRESENCE_IN="PRESENCE_IN"</code>
     */
    public static final String PRESENCE_IN = "PRESENCE_IN";
    /**
     * Constant <code>NOTIFY_IN="NOTIFY_IN"</code>
     */
    public static final String NOTIFY_IN = "NOTIFY_IN";
    /**
     * Constant <code>PRESENCE_OUT="PRESENCE_OUT"</code>
     */
    public static final String PRESENCE_OUT = "PRESENCE_OUT";
    /**
     * Constant <code>PRESENCE_PROBE="PRESENCE_PROBE"</code>
     */
    public static final String PRESENCE_PROBE = "PRESENCE_PROBE";
    /**
     * Constant <code>MESSAGE_WAITING="MESSAGE_WAITING"</code>
     */
    public static final String MESSAGE_WAITING = "MESSAGE_WAITING";
    /**
     * Constant <code>MESSAGE_QUERY="MESSAGE_QUERY"</code>
     */
    public static final String MESSAGE_QUERY = "MESSAGE_QUERY";
    /**
     * Constant <code>ROSTER="ROSTER"</code>
     */
    public static final String ROSTER = "ROSTER";
    /**
     * Constant <code>CODEC="CODEC"</code>
     */
    public static final String CODEC = "CODEC";
    /**
     * Constant <code>BACKGROUND_JOB="BACKGROUND_JOB"</code>
     */
    public static final String BACKGROUND_JOB = "BACKGROUND_JOB";
    /**
     * Constant <code>DETECTED_SPEECH="DETECTED_SPEECH"</code>
     */
    public static final String DETECTED_SPEECH = "DETECTED_SPEECH";
    /**
     * Constant <code>DETECTED_TONE="DETECTED_TONE"</code>
     */
    public static final String DETECTED_TONE = "DETECTED_TONE";
    /**
     * Constant <code>PRIVATE_COMMAND="PRIVATE_COMMAND"</code>
     */
    public static final String PRIVATE_COMMAND = "PRIVATE_COMMAND";
    /**
     * Constant <code>HEARTBEAT="HEARTBEAT"</code>
     */
    public static final String HEARTBEAT = "HEARTBEAT";
    /**
     * Constant <code>TRAP="TRAP"</code>
     */
    public static final String TRAP = "TRAP";
    /**
     * Constant <code>ADD_SCHEDULE="ADD_SCHEDULE"</code>
     */
    public static final String ADD_SCHEDULE = "ADD_SCHEDULE";
    /**
     * Constant <code>DEL_SCHEDULE="DEL_SCHEDULE"</code>
     */
    public static final String DEL_SCHEDULE = "DEL_SCHEDULE";
    /**
     * Constant <code>EXE_SCHEDULE="EXE_SCHEDULE"</code>
     */
    public static final String EXE_SCHEDULE = "EXE_SCHEDULE";
    /**
     * Constant <code>RE_SCHEDULE="RE_SCHEDULE"</code>
     */
    public static final String RE_SCHEDULE = "RE_SCHEDULE";
    /**
     * Constant <code>RELOADXML="RELOADXML"</code>
     */
    public static final String RELOADXML = "RELOADXML";
    /**
     * Constant <code>NOTIFY="NOTIFY"</code>
     */
    public static final String NOTIFY = "NOTIFY";
    /**
     * Constant <code>PHONE_FEATURE="PHONE_FEATURE"</code>
     */
    public static final String PHONE_FEATURE = "PHONE_FEATURE";
    /**
     * Constant <code>PHONE_FEATURE_SUBSCRIBE="PHONE_FEATURE_SUBSCRIBE"</code>
     */
    public static final String PHONE_FEATURE_SUBSCRIBE = "PHONE_FEATURE_SUBSCRIBE";
    /**
     * Constant <code>SEND_MESSAGE="SEND_MESSAGE"</code>
     */
    public static final String SEND_MESSAGE = "SEND_MESSAGE";
    /**
     * Constant <code>RECV_MESSAGE="RECV_MESSAGE"</code>
     */
    public static final String RECV_MESSAGE = "RECV_MESSAGE";
    /**
     * Constant <code>REQUEST_PARAMS="REQUEST_PARAMS"</code>
     */
    public static final String REQUEST_PARAMS = "REQUEST_PARAMS";
    /**
     * Constant <code>CHANNEL_DATA="CHANNEL_DATA"</code>
     */
    public static final String CHANNEL_DATA = "CHANNEL_DATA";
    /**
     * Constant <code>GENERAL="GENERAL"</code>
     */
    public static final String GENERAL = "GENERAL";
    /**
     * Constant <code>COMMAND="COMMAND"</code>
     */
    public static final String COMMAND = "COMMAND";
    /**
     * Constant <code>SESSION_HEARTBEAT="SESSION_HEARTBEAT"</code>
     */
    public static final String SESSION_HEARTBEAT = "SESSION_HEARTBEAT";
    /**
     * Constant <code>CLIENT_DISCONNECTED="CLIENT_DISCONNECTED"</code>
     */
    public static final String CLIENT_DISCONNECTED = "CLIENT_DISCONNECTED";
    /**
     * Constant <code>SERVER_DISCONNECTED="SERVER_DISCONNECTED"</code>
     */
    public static final String SERVER_DISCONNECTED = "SERVER_DISCONNECTED";
    /**
     * Constant <code>SEND_INFO="SEND_INFO"</code>
     */
    public static final String SEND_INFO = "SEND_INFO";
    /**
     * Constant <code>RECV_INFO="RECV_INFO"</code>
     */
    public static final String RECV_INFO = "RECV_INFO";
    /**
     * Constant <code>RECV_RTCP_MESSAGE="RECV_RTCP_MESSAGE"</code>
     */
    public static final String RECV_RTCP_MESSAGE = "RECV_RTCP_MESSAGE";
    /**
     * Constant <code>CALL_SECURE="CALL_SECURE"</code>
     */
    public static final String CALL_SECURE = "CALL_SECURE";
    /**
     * Constant <code>NAT="NAT"</code>
     */
    public static final String NAT = "NAT";
    /**
     * Constant <code>RECORD_START="RECORD_START"</code>
     */
    public static final String RECORD_START = "RECORD_START";
    /**
     * Constant <code>RECORD_STOP="RECORD_STOP"</code>
     */
    public static final String RECORD_STOP = "RECORD_STOP";
    /**
     * Constant <code>PLAYBACK_START="PLAYBACK_START"</code>
     */
    public static final String PLAYBACK_START = "PLAYBACK_START";
    /**
     * Constant <code>PLAYBACK_STOP="PLAYBACK_STOP"</code>
     */
    public static final String PLAYBACK_STOP = "PLAYBACK_STOP";
    /**
     * Constant <code>CALL_UPDATE="CALL_UPDATE"</code>
     */
    public static final String CALL_UPDATE = "CALL_UPDATE";
    /**
     * Constant <code>FAILURE="FAILURE"</code>
     */
    public static final String FAILURE = "FAILURE";
    /**
     * Constant <code>SOCKET_DATA="SOCKET_DATA"</code>
     */
    public static final String SOCKET_DATA = "SOCKET_DATA";
    /**
     * Constant <code>MEDIA_BUG_START="MEDIA_BUG_START"</code>
     */
    public static final String MEDIA_BUG_START = "MEDIA_BUG_START";
    /**
     * Constant <code>MEDIA_BUG_STOP="MEDIA_BUG_STOP"</code>
     */
    public static final String MEDIA_BUG_STOP = "MEDIA_BUG_STOP";
    /**
     * Constant <code>CONFERENCE_DATA_QUERY="CONFERENCE_DATA_QUERY"</code>
     */
    public static final String CONFERENCE_DATA_QUERY = "CONFERENCE_DATA_QUERY";
    /**
     * Constant <code>CONFERENCE_DATA="CONFERENCE_DATA"</code>
     */
    public static final String CONFERENCE_DATA = "CONFERENCE_DATA";
    /**
     * Constant <code>CALL_SETUP_REQ="CALL_SETUP_REQ"</code>
     */
    public static final String CALL_SETUP_REQ = "CALL_SETUP_REQ";
    /**
     * Constant <code>CALL_SETUP_RESULT="CALL_SETUP_RESULT"</code>
     */
    public static final String CALL_SETUP_RESULT = "CALL_SETUP_RESULT";
    /**
     * Constant <code>CALL_DETAIL="CALL_DETAIL"</code>
     */
    public static final String CALL_DETAIL = "CALL_DETAIL";
    /**
     * Constant <code>DEVICE_STATE="DEVICE_STATE"</code>
     */
    public static final String DEVICE_STATE = "DEVICE_STATE";
    /**
     * Constant <code>ALL="ALL"</code>
     */
    public static final String ALL = "ALL";

    private EventNames() {
    }
}
