/*
 * Copyright 2002-2004 Greg Hinkle
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.mc4j.ems.connection;

import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.support.ConnectionProvider;

import java.util.List;
import java.util.SortedSet;

/**
 * TODO GH: Decide exception handling strategy (runtime?)
 *
 * @author Greg Hinkle (ghinkle@users.sourceforge.net), Apr 4, 2005
 * @version $Revision: 1.2 $($Author: ghinkl $ / $Date: 2006/04/12 19:11:33 $)
 */
public interface EmsConnection extends Refreshable {


    ConnectionTracker getTracker();

    void close();

    void loadSynchronous(boolean deep);

    void addRegistrationListener(MBeanRegistrationListener registrationListener);

    void removeRegistrationListener(MBeanRegistrationListener registrationListener);

    /**
     * This will register a new MBean, but that may not be immediately recognized
     * @param className
     * @param objectName
     */
    void createMBean(String className, String objectName) throws EmsException;

    void removeMBean(String objectName) throws EmsException;

    SortedSet<EmsBean> getBeans();

    EmsBean getBean(String objectName);

    List<EmsBean> queryBeans(String objectName);

    EmsBean registerBean(String className, String objectName);

    EmsBean registerBean(String className, String objectName, Object[] params, String[] signature);

    /**
     *
     * @param objectName
     * @return
     * @throws EmsMalformedObjectNameException when an invalid object name is provided
     */
    Object buildObjectName(String objectName)  throws EmsMalformedObjectNameException ;

    /**
     *
     * @return
     * @since 1.0.5
     */
    long getRoundTrips();

    /**
     *
     * @return
     * @since 1.0.5
     */
    long getFailures();

    /**
     *
     * @since 1.0.6
     * @return
     */
    public ConnectionProvider getConnectionProvider();
}
