/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.connection.support.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnectException;
import org.mc4j.ems.connection.EmsException;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.classloader.ChildFirstClassloader;
import org.mc4j.ems.connection.support.metadata.JSR160ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.LocalVMTypeDescriptor;

public class ClassLoaderFactory {
    private static ClassLoaderFactory INSTANCE;
    private static Log log;
    private static Map<String, File> jarCache;
    private static Map<FileKey, File> tempJarCache;

    public static ClassLoaderFactory getInstance() {
        return INSTANCE;
    }

    protected URL storeImplToTemp(String archiveResource, File tempDir) {
        try {
            if (jarCache.containsKey(archiveResource)) {
                return jarCache.get(archiveResource).toURI().toURL();
            }
            InputStream is = ClassLoaderFactory.class.getClassLoader().getResourceAsStream(archiveResource);
            if (is == null) {
                throw new EmsException("Unable to find resource to store [" + archiveResource + "]");
            }
            File tmpFile = this.copyFileToTemp(archiveResource, is, tempDir);
            jarCache.put(archiveResource, tmpFile);
            return tmpFile.toURI().toURL();
        }
        catch (FileNotFoundException e) {
            throw new EmsException("Unable to make temporary file store", e);
        }
        catch (IOException e) {
            throw new EmsException("Unable to make temporary file store", e);
        }
    }

    private File copyFileToTemp(String archiveResource, InputStream is, File directory) throws IOException {
        String jarName = new File(archiveResource).getName();
        jarName = jarName.substring(0, jarName.length() - 4);
        File tmpFile = File.createTempFile(jarName, ".jar", directory);
        tmpFile.deleteOnExit();
        log.trace((Object)("Copying jar [" + archiveResource + "] to temporary file [" + tmpFile.getAbsolutePath() + "]"));
        FileOutputStream fos = new FileOutputStream(tmpFile);
        byte[] buffer = new byte[4096];
        int size = is.read(buffer);
        while (size != -1) {
            fos.write(buffer, 0, size);
            size = is.read(buffer);
        }
        fos.close();
        is.close();
        return tmpFile;
    }

    public URL getCachedTempForFile(File file, File directory) throws MalformedURLException {
        try {
            FileKey key = new FileKey(file);
            File result = tempJarCache.get(key);
            if (result == null) {
                result = this.copyFileToTemp(file.getName(), new FileInputStream(file), directory);
                tempJarCache.put(key, result);
            }
            return result.toURI().toURL();
        }
        catch (IOException ioe) {
            log.debug((Object)("Could not create temporary copy of jar [" + file + "]"), (Throwable)ioe);
            return file.toURI().toURL();
        }
    }

    public ClassLoader buildClassLoader(ConnectionSettings settings) {
        String tempDirString = (String)settings.getControlProperties().get("mc4j.ems.JarTempDir");
        File tempDir = null;
        if (tempDirString != null) {
            tempDir = new File(tempDirString);
        }
        ArrayList<URL> entries = new ArrayList<URL>();
        if (settings.getClassPathEntries() != null) {
            Iterator<File> i$ = settings.getClassPathEntries().iterator();
            while (i$.hasNext()) {
                File file = i$.next();
                try {
                    if (Boolean.valueOf(settings.getControlProperties().getProperty("mc4j.ems.CopyJarsToTemp", "false")).booleanValue()) {
                        entries.add(this.getCachedTempForFile(file, tempDir));
                        continue;
                    }
                    entries.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new EmsConnectException("Unable to read class path library url", e);
                }
            }
        }
        URL implURL = this.storeImplToTemp("org-mc4j-ems-impl.jar", tempDir);
        entries.add(implURL);
        if (settings.getConnectionType() instanceof LocalVMTypeDescriptor) {
            try {
                Class.forName("com.sun.tools.attach.VirtualMachine");
            }
            catch (ClassNotFoundException e) {
                File toolsJar = null;
                toolsJar = this.findToolsJarForHome(System.getProperty("java.home"));
                if (toolsJar == null) {
                    toolsJar = this.findToolsJarForHome(System.getProperty("env_java_home"));
                }
                if (toolsJar != null) {
                    try {
                        log.debug((Object)("Found tools.jar at " + toolsJar.getPath()));
                        entries.add(toolsJar.toURI().toURL());
                    }
                    catch (MalformedURLException e1) {}
                }
                throw new EmsConnectException("Unable to find tools.jar. Add it to your classpath to use Sun local vm connections.");
            }
        }
        if (settings.getConnectionType() instanceof JSR160ConnectionTypeDescriptor && settings.getConnectionType().getConnectionClasspathEntries() == null && Double.parseDouble(System.getProperty("java.version").substring(0, 3)) < 1.5) {
            entries.add(this.storeImplToTemp("lib/jsr160-includes/mx4j.jar", tempDir));
            entries.add(this.storeImplToTemp("lib/jsr160-includes/mx4j-remote.jar", tempDir));
        }
        URL[] entryArray = entries.toArray(new URL[entries.size()]);
        URLClassLoader loader = null;
        loader = settings.getConnectionType().isUseChildFirstClassLoader() ? new ChildFirstClassloader(entryArray, ClassLoaderFactory.class.getClassLoader()) : new URLClassLoader(entryArray, ClassLoaderFactory.class.getClassLoader());
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer("Classloader built with: \n");
            Iterator i$ = entries.iterator();
            while (i$.hasNext()) {
                URL url = (URL)i$.next();
                buf.append("\t").append(url).append("\n");
            }
            log.debug((Object)buf.toString());
        }
        return loader;
    }

    private File findToolsJarForHome(String javaHome) {
        File toolsJar = null;
        if (javaHome != null) {
            File javaHomeDir = new File(javaHome);
            if (!javaHomeDir.exists() || !javaHomeDir.isDirectory()) {
                return null;
            }
            toolsJar = this.findToolsJar(javaHomeDir);
            if (toolsJar == null) {
                toolsJar = this.findToolsJar(javaHomeDir.getParentFile());
            }
        }
        return toolsJar;
    }

    public File findToolsJar(File home) {
        File f = new File(home, "lib" + File.separator + "tools.jar");
        log.debug((Object)("Looking for tools jar at: " + f.getPath()));
        return f.exists() && f.isFile() ? f : null;
    }

    static {
        log = LogFactory.getLog((Class)ClassLoaderFactory.class);
        jarCache = new HashMap<String, File>();
        tempJarCache = Collections.synchronizedMap(new HashMap());
        String className = System.getProperty("org.mc4j.ems.classloaderfactory");
        if (className != null) {
            try {
                INSTANCE = (ClassLoaderFactory)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new EmsException("Unable to load custom classloader factory " + className, e);
            }
        }
        if (INSTANCE == null) {
            INSTANCE = new ClassLoaderFactory();
        }
    }

    public static class FileKey {
        long lastModified;
        long size;
        File f;

        public FileKey(File f) {
            this.lastModified = f.lastModified();
            this.size = f.length();
            this.f = f;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileKey fileKey = (FileKey)o;
            if (this.lastModified != fileKey.lastModified) {
                return false;
            }
            if (this.size != fileKey.size) {
                return false;
            }
            return this.f.equals(fileKey.f);
        }

        public int hashCode() {
            int result = (int)(this.lastModified ^ this.lastModified >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            result = 31 * result + this.f.hashCode();
            return result;
        }
    }
}

