/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.connection.support.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedJarClassLoader
extends URLClassLoader {
    public static final String JAVA_PROTOCOL_HANDLER = "java.protocol.handler.pkgs";
    public static Log log = LogFactory.getLog(NestedJarClassLoader.class);
    static Map<URL, ClassLoader> loadMap;

    @Override
    public URL[] getURLs() {
        URL[] all = super.getURLs();
        ArrayList<URL> safe = new ArrayList<URL>();
        for (URL url : all) {
            if (url.getProtocol().indexOf("deepjar") >= 0) continue;
            safe.add(url);
        }
        return safe.toArray(new URL[safe.size()]);
    }

    public static NestedJarClassLoader newInstance(URL[] urls, ClassLoader parent) {
        return new NestedJarClassLoader(urls, parent);
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        if (string.indexOf("MBeanServer") >= 0) {
            log.debug((Object)("MBeanServer Class being loaded in ClassLoader " + this));
        }
        return super.findClass(string);
    }

    public NestedJarClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        for (URL url : urls) {
            if (!"deepjar".equals(url.getProtocol())) continue;
            loadMap.put(url, parent);
        }
    }

    public static ClassLoader getRunningLoader(URL url) {
        return loadMap.get(url);
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        NestedJarClassLoader cl = NestedJarClassLoader.newInstance(new URL[]{new URL("deepjar://org-mc4j-ems-impl.jar")}, NestedJarClassLoader.class.getClassLoader());
        Class<?> testClass = Class.forName("org.mc4j.ems.impl.jmx.connection.DConnection", false, cl);
        log.info(testClass);
        log.info((Object)("Time: " + (System.currentTimeMillis() - start) + "ns"));
        start = System.currentTimeMillis();
        testClass = Class.forName("org.mc4j.ems.impl.jmx.connection.PooledConnectionTracker", false, cl);
        log.info(testClass);
        log.info((Object)("Time: " + (System.currentTimeMillis() - start) + "ns"));
    }

    static {
        String handlerPackage = "org.mc4j.ems.connection.support.classloader";
        String value = System.getProperty(JAVA_PROTOCOL_HANDLER);
        value = value == null ? handlerPackage : value + "|" + handlerPackage;
        System.setProperty(JAVA_PROTOCOL_HANDLER, value);
        log.debug((Object)("Updated URL Handler Packages to: " + System.getProperty(JAVA_PROTOCOL_HANDLER)));
        loadMap = new HashMap<URL, ClassLoader>();
    }
}

