/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.connection.support.classloader;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Map;
import org.mc4j.ems.connection.support.classloader.deepjar.Handler;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepClassLoader
extends ClassLoader {
    private URL[] searchPaths;
    private Map<String, ByteCode> codeMap;
    private Map<String, ProtectionDomain> protectionDomainMap;
    public static final String JAVA_PROTOCOL_HANDLER = "java.protocol.handler.pkgs";

    public DeepClassLoader(ClassLoader parent, URL[] urls) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(name);
        if (cls != null) {
            return cls;
        }
        String cache = new StringBuffer().append(name.replace('/', '.')).append(".class").toString();
        ByteCode bytecode = this.codeMap.get(cache);
        if (bytecode != null) {
            ProtectionDomain pd = this.protectionDomainMap.get(bytecode.codebase);
            if (pd == null) {
                ProtectionDomain cd = this.getClass().getProtectionDomain();
                URL url = cd.getCodeSource().getLocation();
                try {
                    url = new URL(new StringBuffer().append("jar:").append(url).append("!/").append(bytecode.codebase).toString());
                }
                catch (MalformedURLException mux) {
                    mux.printStackTrace(System.out);
                }
                CodeSource source = new CodeSource(url, (CodeSigner[])null);
                pd = new ProtectionDomain(source, null, this, null);
                this.protectionDomainMap.put(bytecode.codebase, pd);
            }
            return this.defineClass(name, bytecode.bytes, 0, bytecode.length, pd);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String resourceName) {
        try {
            String resource = this.resolve(resourceName);
            if (resource != null) {
                return new URL(new StringBuffer().append(Handler.PROTOCOL).append(":").append(resource).toString());
            }
            return null;
        }
        catch (MalformedURLException mux) {
            System.out.println(new StringBuffer().append("Unable to find resource ").append(resourceName).toString());
            return null;
        }
    }

    protected String resolve(String resourceName) {
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        resourceName = resourceName.replace('/', '.');
        String resource = null;
        if (resource == null) {
            resource = this.codeMap.get(resourceName) == null ? null : resourceName;
        }
        return resource;
    }

    static {
        String handlerPackage = "org.mc4j.ems.connection.support.classloader.deepjar";
        String existingHandlers = System.getProperty(JAVA_PROTOCOL_HANDLER);
        String newHandlers = null;
        newHandlers = existingHandlers != null && existingHandlers.length() > 0 ? new StringBuffer().append(handlerPackage).append("|").append(existingHandlers).toString() : handlerPackage;
        System.setProperty(JAVA_PROTOCOL_HANDLER, newHandlers);
    }

    protected class ByteCode {
        public byte[] bytes;
        public int length;
        public String name;
        public String original;
        public String codebase;

        public ByteCode(String name, String $original, byte[] bytes, int length, String codebase) {
            this.name = name;
            this.original = $original;
            this.bytes = bytes;
            this.codebase = codebase;
        }
    }
}

