/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenProjectFactory
implements ProjectFactory {
    private static final Log logger = LogFactory.getLog((Class)MavenProjectFactory.class);

    public boolean isProject(FileObject fileObject) {
        File projectDir = FileUtil.toFile((FileObject)fileObject);
        if (projectDir == null) {
            return false;
        }
        File project = new File(projectDir, "project.xml");
        return project.isFile() && !"nbproject".equalsIgnoreCase(projectDir.getName());
    }

    public Project loadProject(FileObject fileObject, ProjectState projectState) throws IOException {
        if (FileUtil.toFile((FileObject)fileObject) == null) {
            return null;
        }
        if ("nbproject".equalsIgnoreCase(fileObject.getName())) {
            return null;
        }
        FileObject projectFile = fileObject.getFileObject("project.xml");
        if (projectFile == null || !projectFile.isData()) {
            return null;
        }
        File projectDiskFile = FileUtil.toFile((FileObject)projectFile);
        if (projectDiskFile == null) {
            return null;
        }
        try {
            MavenProject proj = new MavenProject(projectFile, projectDiskFile);
            return proj;
        }
        catch (Exception exc) {
            logger.error((Object)("Cannot load project=" + projectDiskFile), (Throwable)exc);
            ErrorManager.getDefault().getInstance(MavenProjectFactory.class.getName()).notify(1, (Throwable)exc);
            return null;
        }
    }

    public void saveProject(Project project) throws IOException {
    }
}

