/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Build;
import org.apache.maven.project.Resource;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.nodes.DirScannerSubClass;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;

public class MavenSourcesImpl
implements Sources {
    private static final Log logger = LogFactory.getLog((Class)MavenSourcesImpl.class);
    public static final String TYPE_RESOURCES = "Resources";
    public static final String TYPE_TEST_RESOURCES = "TestResources";
    public static final String TYPE_XDOCS = "XDocs";
    public static final String TYPE_GEN_SOURCES = "GeneratedSources";
    public static final String NAME_PROJECTROOT = "ProjectRoot";
    public static final String NAME_XDOCS = "XDocs";
    public static final String NAME_SOURCE = "1SourceRoot";
    public static final String NAME_TESTSOURCE = "2TestSourceRoot";
    public static final String NAME_INTEGRATIONSOURCE = "5IntegrationSourceRoot";
    public static final String NAME_CACTUS_SOURCE = "3CactusSourceRoot";
    public static final String NAME_ASPECTSOURCE = "4AspectSourceRoot";
    public static final String NAME_GENERATED_SOURCE = "6GeneratedSourceRoot";
    public static final String TYPE_DOC_ROOT = "doc_root";
    public static final String TYPE_WEB_INF = "web_inf";
    private MavenProject project;
    private List listeners;
    private Map javaGroup;
    private HashMap resGroup;
    private SourceGroup xdocsGroup;
    private SourceGroup genSrcGroup;
    private SourceGroup webDocSrcGroup;
    private Object lock = new Object();

    public MavenSourcesImpl(MavenProject proj) {
        this.project = proj;
        this.listeners = new ArrayList();
        this.javaGroup = new TreeMap();
        this.resGroup = new HashMap();
        this.project.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                MavenSourcesImpl.this.checkChanges(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChanges(boolean synchronous) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            try {
                FileObject folder = URLMapper.findFileObject((URL)this.project.getSrcDirectory().toURL());
                changed |= this.checkJavaGroupCache(folder, NAME_SOURCE, "Sources");
                folder = URLMapper.findFileObject((URL)this.project.getTestSrcDirectory().toURL());
                changed |= this.checkJavaGroupCache(folder, NAME_TESTSOURCE, "Test Sources");
                folder = URLMapper.findFileObject((URL)this.project.getAspectsDirectory().toURL());
                changed |= this.checkJavaGroupCache(folder, NAME_ASPECTSOURCE, "Aspect Sources");
                folder = URLMapper.findFileObject((URL)this.project.getIntegrationTestsDirectory().toURL());
                changed |= this.checkJavaGroupCache(folder, NAME_INTEGRATIONSOURCE, "Integration Test Sources");
                URI cactus = this.project.getCactusDirectory();
                folder = cactus == null ? null : URLMapper.findFileObject((URL)cactus.toURL());
                changed |= this.checkJavaGroupCache(folder, NAME_CACTUS_SOURCE, "Cactus Test Sources");
                folder = URLMapper.findFileObject((URL)this.project.getGeneratedSourcesDir().toURL());
                changed |= this.checkGeneratedGroupCache(folder);
            }
            catch (MalformedURLException exc) {
                logger.error((Object)"Malformed URL", (Throwable)exc);
                changed = false;
            }
        }
        if (changed) {
            if (synchronous) {
                this.fireChange();
            } else {
                RequestProcessor.getDefault();
                RequestProcessor.postRequest((Runnable)new Runnable(){

                    public void run() {
                        MavenSourcesImpl.this.fireChange();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList currList;
        List list = this.listeners;
        synchronized (list) {
            currList = new ArrayList(this.listeners);
        }
        Iterator it = currList.iterator();
        ChangeEvent event = new ChangeEvent(this);
        while (it.hasNext()) {
            ChangeListener list2 = (ChangeListener)it.next();
            list2.stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceGroup[] getSourceGroups(String str) {
        if ("generic".equals(str)) {
            return new SourceGroup[]{GenericSources.group((Project)this.project, (FileObject)this.project.getProjectDirectory(), (String)NAME_PROJECTROOT, (String)"Project Root", null, null)};
        }
        if ("java".equals(str)) {
            ArrayList toReturn = new ArrayList();
            Object object = this.lock;
            synchronized (object) {
                this.checkChanges(false);
                toReturn.addAll(this.javaGroup.values());
            }
            SourceGroup[] grp = new SourceGroup[toReturn.size()];
            grp = toReturn.toArray(grp);
            return grp;
        }
        if ("XDocs".equals(str)) {
            return this.createXDocs();
        }
        if (TYPE_GEN_SOURCES.equals(str)) {
            try {
                FileObject folder = URLMapper.findFileObject((URL)this.project.getGeneratedSourcesDir().toURL());
                SourceGroup grp = null;
                Object object = this.lock;
                synchronized (object) {
                    this.checkGeneratedGroupCache(folder);
                    grp = this.genSrcGroup;
                }
                if (grp != null) {
                    return new SourceGroup[]{grp};
                }
                return new SourceGroup[0];
            }
            catch (MalformedURLException exc) {
                logger.error((Object)"Malformed URL", (Throwable)exc);
                return new SourceGroup[0];
            }
        }
        if (TYPE_DOC_ROOT.equals(str)) {
            return this.createWebDocRoot();
        }
        if (TYPE_RESOURCES.equals(str) || TYPE_TEST_RESOURCES.equals(str)) {
            ArrayList<ResourceGroup> toReturn = new ArrayList<ResourceGroup>();
            Build build = this.project.getOriginalMavenProject().getBuild();
            if (build != null) {
                List resources = null;
                if (TYPE_RESOURCES.equals(str)) {
                    resources = build.getResources();
                } else if (build.getUnitTest() != null) {
                    resources = build.getUnitTest().getResources();
                }
                if (resources != null) {
                    Iterator it = resources.iterator();
                    int count = 0;
                    while (it.hasNext()) {
                        ++count;
                        Resource res = (Resource)it.next();
                        String path = this.project.getPropertyResolver().resolveString(res.getDirectory());
                        FileObject folder = FileUtilities.findFolder(this.project.getProjectDirectory(), path);
                        if (folder == null) {
                            File fl = FileUtil.normalizeFile((File)new File(path));
                            folder = FileUtil.toFileObject((File)fl);
                        }
                        if (folder == null) continue;
                        toReturn.add(new ResourceGroup(this.project, folder, res, "Resource" + count + res.getDirectory(), res.getDirectory(), null, null));
                    }
                }
            }
            SourceGroup[] grp = new SourceGroup[toReturn.size()];
            grp = toReturn.toArray(grp);
            return grp;
        }
        logger.warn((Object)("unknown source type=" + str));
        return new SourceGroup[0];
    }

    private boolean checkJavaGroupCache(FileObject root, String name, String displayName) {
        SourceGroup group = (SourceGroup)this.javaGroup.get(name);
        if (root == null && group != null) {
            this.javaGroup.remove(name);
            return true;
        }
        if (root == null) {
            return false;
        }
        boolean changed = false;
        if (group == null) {
            group = GenericSources.group((Project)this.project, (FileObject)root, (String)name, (String)displayName, null, null);
            this.javaGroup.put(name, group);
            changed = true;
        } else if (!group.getRootFolder().equals(root)) {
            group = GenericSources.group((Project)this.project, (FileObject)root, (String)name, (String)displayName, null, null);
            this.javaGroup.put(name, group);
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceGroup[] createWebDocRoot() {
        try {
            FileObject folder = URLMapper.findFileObject((URL)this.project.getWebAppDirectory().toURL());
            SourceGroup grp = null;
            Object object = this.lock;
            synchronized (object) {
                this.checkWebDocGroupCache(folder);
                grp = this.webDocSrcGroup;
            }
            if (grp != null) {
                return new SourceGroup[]{grp};
            }
            return new SourceGroup[0];
        }
        catch (MalformedURLException exc) {
            logger.error((Object)"Malformed URL", (Throwable)exc);
            return new SourceGroup[0];
        }
    }

    private boolean checkWebDocGroupCache(FileObject root) {
        if (root == null && this.webDocSrcGroup != null) {
            this.webDocSrcGroup = null;
            return true;
        }
        if (root == null) {
            return false;
        }
        boolean changed = false;
        if (this.webDocSrcGroup == null || !this.webDocSrcGroup.getRootFolder().equals(root)) {
            this.webDocSrcGroup = GenericSources.group((Project)this.project, (FileObject)root, (String)TYPE_DOC_ROOT, (String)"Web Document Sources", null, null);
            changed = true;
        }
        return changed;
    }

    private boolean checkGeneratedGroupCache(FileObject root) {
        if (root == null && this.genSrcGroup != null) {
            this.genSrcGroup = null;
            return true;
        }
        if (root == null) {
            return false;
        }
        boolean changed = false;
        if (this.genSrcGroup == null || !this.genSrcGroup.getRootFolder().equals(root)) {
            this.genSrcGroup = GenericSources.group((Project)this.project, (FileObject)root, (String)NAME_GENERATED_SOURCE, (String)"Generated Sources", null, null);
            changed = true;
        }
        return changed;
    }

    private SourceGroup[] createXDocs() {
        String path = this.project.getPropertyResolver().getResolvedValue("maven.docs.src");
        if (path != null) {
            File rootDir;
            File docs = FileUtil.normalizeFile((File)new File(path));
            if (!docs.exists() && !(docs = FileUtil.normalizeFile((File)new File(rootDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory()), path))).exists()) {
                return new SourceGroup[0];
            }
            FileObject dir = FileUtil.toFileObject((File)docs);
            if (this.xdocsGroup == null || !this.xdocsGroup.getRootFolder().equals(dir)) {
                this.xdocsGroup = GenericSources.group((Project)this.project, (FileObject)dir, (String)"XDocs", (String)"Documentation", null, null);
            }
            return new SourceGroup[]{this.xdocsGroup};
        }
        return new SourceGroup[0];
    }

    public static final class ResourceGroup
    implements SourceGroup {
        private final FileObject rootFolder;
        private File rootFile;
        private final String name;
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;
        private MavenProject project;
        private Resource resource;

        ResourceGroup(MavenProject p, FileObject rootFold, Resource res, String nm, String displayNm, Icon icn, Icon opened) {
            this.project = p;
            this.resource = res;
            this.rootFolder = rootFold;
            this.rootFile = FileUtil.toFile((FileObject)this.rootFolder);
            this.name = nm;
            this.displayName = displayNm;
            this.icon = icn;
            this.openedIcon = opened;
        }

        public FileObject getRootFolder() {
            return this.rootFolder;
        }

        public File getRootFolderFile() {
            return this.rootFile;
        }

        public Resource getResource() {
            return this.resource;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon(boolean opened) {
            return opened ? this.icon : this.openedIcon;
        }

        public boolean contains(FileObject file) {
            logger.debug((Object)("Resourcegroup.contains()=" + file));
            if (file != this.rootFolder && !FileUtil.isParentOf((FileObject)this.rootFolder, (FileObject)file)) {
                throw new IllegalArgumentException();
            }
            if (FileOwnerQuery.getOwner((FileObject)file) != this.project) {
                return false;
            }
            File f = FileUtil.toFile((FileObject)file);
            if (f != null) {
                return SharabilityQuery.getSharability((File)f) != 2 && DirScannerSubClass.checkIncluded(file, this.rootFolder, this.resource);
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }
}

