/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.classpath;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.classpath.BootClassPathImpl;
import org.mevenide.netbeans.project.classpath.SrcBuildClassPathImpl;
import org.mevenide.netbeans.project.classpath.SrcClassPathImpl;
import org.mevenide.netbeans.project.classpath.SrcRuntimeClassPathImpl;
import org.mevenide.netbeans.project.classpath.TestSrcBuildClassPathImpl;
import org.mevenide.netbeans.project.classpath.TestSrcClassPathImpl;
import org.mevenide.netbeans.project.classpath.TestSrcRuntimeClassPathImpl;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ClassPathProviderImpl
implements ClassPathProvider {
    private static final Log logger = LogFactory.getLog((Class)ClassPathProviderImpl.class);
    private static final int TYPE_SRC = 0;
    private static final int TYPE_TESTSRC = 1;
    private static final int TYPE_TESTCLASS = 3;
    private static final int TYPE_CLASS = 2;
    private static final int TYPE_ARTIFACT = 4;
    private static final int TYPE_UNKNOWN = -1;
    private MavenProject project;
    private Reference[] cache = new SoftReference[7];

    public ClassPathProviderImpl(MavenProject proj) {
        this.project = proj;
    }

    public ClassPath[] getProjectClassPaths(String type) {
        if ("classpath/boot".equals(type)) {
            logger.debug((Object)"get boot path");
            return new ClassPath[]{this.getBootClassPath()};
        }
        logger.debug((Object)("getProjectClassPaths type =" + type));
        if ("classpath/compile".equals(type)) {
            ArrayList<ClassPath> l = new ArrayList<ClassPath>(2);
            logger.debug((Object)"COMPILEgetProjectClassPaths src");
            FileObject d = FileUtilities.convertURItoFileObject(this.project.getSrcDirectory());
            if (d != null) {
                logger.debug((Object)("COMPILEgetProjectClassPaths src adding1=" + d));
                l.add(this.getCompileTimeClasspath(d));
            }
            if ((d = FileUtilities.convertURItoFileObject(this.project.getTestSrcDirectory())) != null) {
                logger.debug((Object)("COMPILEgetProjectClassPaths src adding2=" + d));
                l.add(this.getCompileTimeClasspath(d));
            }
            return l.toArray(new ClassPath[l.size()]);
        }
        if ("classpath/execute".equals(type)) {
            ArrayList<ClassPath> l = new ArrayList<ClassPath>(2);
            logger.debug((Object)"EXECUTEgetProjectClassPaths src");
            FileObject d = FileUtilities.convertURItoFileObject(this.project.getSrcDirectory());
            if (d != null) {
                logger.debug((Object)("EXECUTEgetProjectClassPaths src adding1=" + d));
                l.add(this.getRuntimeClasspath(d));
            }
            if ((d = FileUtilities.convertURItoFileObject(this.project.getTestSrcDirectory())) != null) {
                logger.debug((Object)("EXECUTEgetProjectClassPaths src adding2=" + d));
                l.add(this.getRuntimeClasspath(d));
            }
            return l.toArray(new ClassPath[l.size()]);
        }
        if ("classpath/source".equals(type)) {
            ArrayList<ClassPath> l = new ArrayList<ClassPath>(2);
            logger.debug((Object)"getProjectClassPaths src");
            FileObject d = FileUtilities.convertURItoFileObject(this.project.getSrcDirectory());
            if (d != null) {
                logger.debug((Object)("getProjectClassPaths src adding1=" + d));
                l.add(this.getSourcepath(d));
            }
            if ((d = FileUtilities.convertURItoFileObject(this.project.getTestSrcDirectory())) != null) {
                logger.debug((Object)("getProjectClassPaths src adding2=" + d));
                l.add(this.getSourcepath(d));
            }
            logger.debug((Object)("getProjectClassPaths src lenght=" + l.size()));
            return l.toArray(new ClassPath[l.size()]);
        }
        return new ClassPath[0];
    }

    public ClassPath findClassPath(FileObject file, String type) {
        logger.debug((Object)("findClassPath type =" + type));
        logger.debug((Object)("findClassPath file =" + file.getName()));
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(file);
        }
        if (type.equals("classpath/execute")) {
            return this.getRuntimeClasspath(file);
        }
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(file);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    private int getType(FileObject file) {
        FileObject dir = FileUtilities.convertURItoFileObject(this.project.getSrcDirectory());
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 0;
        }
        dir = FileUtilities.convertURItoFileObject(this.project.getWebAppDirectory());
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 0;
        }
        dir = FileUtilities.convertURItoFileObject(this.project.getTestSrcDirectory());
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 1;
        }
        dir = FileUtilities.convertURItoFileObject(this.project.getCactusDirectory());
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 1;
        }
        dir = FileUtilities.convertURItoFileObject(this.project.getBuildClassesDir());
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 2;
        }
        dir = FileUtilities.convertURItoFileObject(this.project.getTestBuildClassesDir());
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 3;
        }
        return -1;
    }

    private ClassPath getSourcepath(FileObject file) {
        int type = this.getType(file);
        logger.debug((Object)("getSourcepath type=" + type));
        if (type != 0 && type != 1) {
            return null;
        }
        ClassPath cp = null;
        if (this.cache[type] == null || (cp = (ClassPath)this.cache[type].get()) == null) {
            if (type == 0) {
                logger.debug((Object)"create Sourcepath src");
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)new SrcClassPathImpl(this.project));
            } else {
                logger.debug((Object)"create Sourcepath testsrc");
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)new TestSrcClassPathImpl(this.project));
            }
            this.cache[type] = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    private ClassPath getCompileTimeClasspath(FileObject file) {
        int type = this.getType(file);
        logger.debug((Object)("getCompileTimeClasspath type=" + type));
        if (type != 0 && type != 1) {
            return null;
        }
        ClassPath cp = null;
        if (this.cache[2 + type] == null || (cp = (ClassPath)this.cache[2 + type].get()) == null) {
            if (type == 0) {
                logger.debug((Object)"create CompileTimeClasspath src");
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)new SrcBuildClassPathImpl(this.project));
            } else {
                logger.debug((Object)"create CompileTimeClasspath testsrc");
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)new TestSrcBuildClassPathImpl(this.project));
            }
            this.cache[2 + type] = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    private ClassPath getRuntimeClasspath(FileObject file) {
        int type = this.getType(file);
        logger.debug((Object)("getRuntimeTimeClasspath type=" + type));
        if (type != 0 && type != 1) {
            return null;
        }
        ClassPath cp = null;
        if (this.cache[4 + type] == null || (cp = (ClassPath)this.cache[4 + type].get()) == null) {
            if (type == 0) {
                logger.debug((Object)"create RumtimeClasspath src");
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)new SrcRuntimeClassPathImpl(this.project));
            } else {
                logger.debug((Object)"create RumtimeClasspath testsrc");
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)new TestSrcRuntimeClassPathImpl(this.project));
            }
            this.cache[4 + type] = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    private ClassPath getBootClassPath() {
        ClassPath cp = null;
        if (this.cache[6] == null || (cp = (ClassPath)this.cache[6].get()) == null) {
            cp = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImpl(this.project));
            this.cache[6] = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }
}

