/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.mevenide.netbeans.project.customizer.MavenPropertyChange;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;

public class CheckBoxPropertyChange
implements MavenPropertyChange {
    private String key;
    private String value;
    private int location;
    private String newValue;
    private boolean defaultValue;
    private int newLocation;
    private JCheckBox check;
    private OriginChange origin;
    private DocListener listener;
    private boolean opposite;
    private boolean ignore = false;

    public CheckBoxPropertyChange(String keyParam, String oldValue, int oldLocation, JCheckBox box, OriginChange oc, boolean defVal, boolean opp) {
        this.opposite = opp;
        this.key = keyParam;
        this.check = box;
        this.location = oldLocation;
        this.newLocation = oldLocation;
        this.defaultValue = defVal;
        this.origin = oc;
        this.value = oldValue;
        boolean boolValue = false;
        boolValue = this.value != null ? CheckBoxPropertyChange.checkResolvedBoolean(this.value) : this.defaultValue;
        this.setCheckBoxValue(boolValue, this.opposite);
        this.origin.setInitialLocationID(oldLocation);
        this.listener = new DocListener();
        this.origin.setChangeObserver(this.listener);
        this.check.addActionListener(this.listener);
    }

    public String getKey() {
        return this.key;
    }

    public int getNewLocation() {
        return this.newLocation;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public int getOldLocation() {
        return this.location;
    }

    public String getOldValue() {
        return this.value;
    }

    public boolean hasChanged() {
        return this.newLocation != this.location || CheckBoxPropertyChange.checkResolvedBoolean(this.getOldValue()) != CheckBoxPropertyChange.checkResolvedBoolean(this.getNewValue());
    }

    private void setCheckBoxValue(boolean boolValue, boolean opp) {
        String string = this.newValue = boolValue ? "true" : "false";
        if (opp) {
            this.check.setSelected(!boolValue);
        } else {
            this.check.setSelected(boolValue);
        }
    }

    static boolean checkResolvedBoolean(String value) {
        if (value == null) {
            return false;
        }
        String tr = value.trim();
        return "on".equalsIgnoreCase(tr) || "true".equalsIgnoreCase(tr) || "yes".equalsIgnoreCase(tr);
    }

    private final class DocListener
    implements ActionListener,
    OriginChange.ChangeObserver {
        private DocListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (CheckBoxPropertyChange.this.ignore) {
                return;
            }
            if (CheckBoxPropertyChange.this.opposite) {
                CheckBoxPropertyChange.this.newValue = CheckBoxPropertyChange.this.check.isSelected() ? "false" : "true";
            } else {
                CheckBoxPropertyChange.this.newValue = CheckBoxPropertyChange.this.check.isSelected() ? "true" : "false";
            }
            if (CheckBoxPropertyChange.this.origin.getSelectedLocationID() == -1 || CheckBoxPropertyChange.this.origin.getSelectedLocationID() == -2) {
                CheckBoxPropertyChange.this.origin.setAction(11);
            }
        }

        public void locationChanged() {
            if (CheckBoxPropertyChange.this.ignore) {
                return;
            }
            CheckBoxPropertyChange.this.newLocation = CheckBoxPropertyChange.this.origin.getSelectedLocationID();
            if (CheckBoxPropertyChange.this.newLocation < 0) {
                CheckBoxPropertyChange.this.ignore = true;
                CheckBoxPropertyChange.this.setCheckBoxValue(CheckBoxPropertyChange.this.defaultValue, CheckBoxPropertyChange.this.opposite);
                CheckBoxPropertyChange.this.ignore = false;
            }
        }
    }
}

