/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.customizer.MavenChange;
import org.mevenide.netbeans.project.customizer.ProjectPanel;
import org.mevenide.netbeans.project.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.project.customizer.ui.LocationComboFactory;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;
import org.mevenide.netbeans.project.customizer.ui.OriginChangeCellEditor;
import org.mevenide.netbeans.project.customizer.ui.PropertyTableModel;
import org.mevenide.netbeans.project.customizer.ui.TableRowPropertyChange;

public class DefaultPluginPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)DefaultPluginPanel.class);
    private ProjectValidateObserver valObserver;
    private MavenProject project;
    private PropertyTableModel mod;
    private Properties props;
    private HashMap changes;
    private JLabel lblDescription;
    private JScrollPane spProperties;
    private JTable tblProperties;

    public DefaultPluginPanel(MavenProject proj) {
        this.project = proj;
        this.changes = new HashMap();
        this.initComponents();
        this.valObserver = null;
        this.props = new Properties();
        InputStream stream = null;
        try {
            stream = DefaultPluginPanel.class.getClassLoader().getResourceAsStream("org/mevenide/properties/maven_defaults.properties");
            this.props.load(stream);
        }
        catch (Exception exc) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            logger.error((Object)"Cannot load default properties.", (Throwable)exc);
        }
        this.populateChangeInstances();
    }

    private void initComponents() {
        this.spProperties = new JScrollPane();
        this.tblProperties = new JTable();
        this.lblDescription = new JLabel();
        this.setLayout(new GridBagLayout());
        this.spProperties.setViewportView(this.tblProperties);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.spProperties, gridBagConstraints);
        this.lblDescription.setText("These are the default, build-in Maven properties, not associated with a specific plugin.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.lblDescription, gridBagConstraints);
    }

    private void populateChangeInstances() {
        this.createChangeInstance("maven.build.dest");
        this.createChangeInstance("maven.build.dir");
        this.createChangeInstance("maven.build.src");
        this.createChangeInstance("maven.conf.dir");
        this.createChangeInstance("maven.docs.dest");
        this.createChangeInstance("maven.docs.omitXmlDeclaration");
        this.createChangeInstance("maven.docs.outputencoding");
        this.createChangeInstance("maven.docs.src");
        this.createChangeInstance("maven.gen.docs");
        this.createChangeInstance("maven.home.local");
        this.createChangeInstance("maven.mode.online");
        this.createChangeInstance("maven.plugin.dir");
        this.createChangeInstance("maven.plugin.unpacked.dir");
        this.createChangeInstance("maven.plugin.user.dir");
        this.createChangeInstance("maven.repo.central");
        this.createChangeInstance("maven.repo.central.directory");
        this.createChangeInstance("maven.repo.local");
        this.createChangeInstance("maven.repo.remote");
        this.createChangeInstance("maven.repo.remote.enabled");
        this.createChangeInstance("maven.scp.executable");
        this.createChangeInstance("maven.src.dir");
        this.createChangeInstance("maven.ssh.executable");
        this.createChangeInstance("maven.proxy.host");
        this.createChangeInstance("maven.proxy.port");
        this.createChangeInstance("maven.proxy.username");
        this.createChangeInstance("maven.proxy.password");
        this.createChangeInstance("maven.proxy.ntlm.host");
        this.createChangeInstance("maven.proxy.ntlm.domain");
        this.mod = new PropertyTableModel(this.project.getPropertyResolver(), this.changes.values());
        this.tblProperties.setModel(this.mod);
        TableColumn col = this.tblProperties.getTableHeader().getColumnModel().getColumn(2);
        col.setMaxWidth(40);
        col.setMinWidth(20);
        col.setPreferredWidth(30);
        col.setCellRenderer(this.mod);
        col.setCellEditor(new OriginChangeCellEditor(LocationComboFactory.createPropertiesChange(this.project)));
        col = this.tblProperties.getTableHeader().getColumnModel().getColumn(1);
        col.setCellRenderer(this.mod);
        col = this.tblProperties.getTableHeader().getColumnModel().getColumn(0);
        col.setCellRenderer(this.mod);
    }

    private void createChangeInstance(String key) {
        String value = this.project.getPropertyResolver().getValue(key);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = "";
            location = -1;
        }
        OriginChange chng = LocationComboFactory.createPropertiesChange(this.project);
        String def = this.props.getProperty(key);
        def = def == null ? "" : def;
        this.changes.put(key, new TableRowPropertyChange(key, value, location, LocationComboFactory.createPropertiesChange(this.project), def));
    }

    public List getChanges() {
        ArrayList<MavenChange> toReturn = new ArrayList<MavenChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenChange change = (MavenChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    public void setResolveValues(boolean resolve) {
        this.mod.setResolve(resolve);
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    private void doValidate() {
        logger.debug((Object)"Listener called");
        ProjectValidateObserver obs = this.valObserver;
        if (obs != null) {
            obs.resetValidState(this.isInValidState(), this.getValidityMessage());
        }
    }

    private int doValidateCheck() {
        return 0;
    }

    public boolean isInValidState() {
        return this.doValidateCheck() == 0;
    }

    public String getValidityMessage() {
        int retCode = this.doValidateCheck();
        String message = "";
        return message;
    }
}

