/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.apache.maven.project.Organization;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.customizer.MavenChange;
import org.mevenide.netbeans.project.customizer.MultiTextComponentPOMChange;
import org.mevenide.netbeans.project.customizer.ProjectPanel;
import org.mevenide.netbeans.project.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.project.customizer.TextComponentPOMChange;
import org.mevenide.netbeans.project.customizer.ui.LocationComboFactory;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;
import org.mevenide.project.io.IContentProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class OrgPanel
extends JPanel
implements ProjectPanel {
    private ProjectValidateObserver valObserver;
    private MavenProject project;
    private OriginChange ocSiteAddress;
    private OriginChange ocSiteDir;
    private OriginChange ocDistAddress;
    private OriginChange ocDistDir;
    private OriginChange ocOrganization;
    private OriginChange ocIssueTracking;
    private HashMap changes;
    private boolean initialized;
    private JButton btnDistAddress;
    private JButton btnDistDir;
    private JButton btnIssueTracking;
    private JButton btnOrganization;
    private JButton btnSiteAddress;
    private JButton btnSiteDir;
    private JButton btnURL;
    private JPanel jPanel1;
    private JLabel lblDistAddress;
    private JLabel lblDistDir;
    private JLabel lblIssueTracking;
    private JLabel lblLogo;
    private JLabel lblName;
    private JLabel lblOrganization;
    private JLabel lblSiteAddress;
    private JLabel lblSiteDir;
    private JLabel lblURL;
    private JPanel pnlOrganization;
    private JTextField txtDistAddress;
    private JTextField txtDistDir;
    private JTextField txtIssueTracking;
    private JTextField txtLogo;
    private JTextField txtName;
    private JTextField txtSiteAddress;
    private JTextField txtSiteDir;
    private JTextField txtURL;

    public OrgPanel(MavenProject proj) {
        this.project = proj;
        this.changes = new HashMap();
        this.initComponents();
        this.valObserver = null;
        this.setName(NbBundle.getMessage((Class)OrgPanel.class, (String)"OrgPanel.name"));
        this.btnURL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String url = OrgPanel.this.txtURL.getText().trim();
                url = OrgPanel.this.project.getPropertyResolver().resolveString(url);
                if (url.startsWith("http://")) {
                    try {
                        URL link = new URL(url);
                        HtmlBrowser.URLDisplayer.getDefault().showURL(link);
                    }
                    catch (MalformedURLException exc) {
                        NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)"Is not a valid URL.", 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
                    }
                }
            }
        });
        this.initialized = false;
    }

    private void initComponents() {
        this.lblOrganization = new JLabel();
        this.ocOrganization = LocationComboFactory.createPOMChange(this.project, true);
        this.btnOrganization = (JButton)this.ocOrganization.getComponent();
        this.pnlOrganization = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblURL = new JLabel();
        this.txtURL = new JTextField();
        this.btnURL = new JButton();
        this.lblLogo = new JLabel();
        this.txtLogo = new JTextField();
        this.lblSiteAddress = new JLabel();
        this.txtSiteAddress = new JTextField();
        this.ocSiteAddress = LocationComboFactory.createPOMChange(this.project, false);
        this.btnSiteAddress = (JButton)this.ocSiteAddress.getComponent();
        this.lblSiteDir = new JLabel();
        this.txtSiteDir = new JTextField();
        this.ocSiteDir = LocationComboFactory.createPOMChange(this.project, false);
        this.btnSiteDir = (JButton)this.ocSiteDir.getComponent();
        this.lblDistAddress = new JLabel();
        this.txtDistAddress = new JTextField();
        this.ocDistAddress = LocationComboFactory.createPOMChange(this.project, false);
        this.btnDistAddress = (JButton)this.ocDistAddress.getComponent();
        this.lblDistDir = new JLabel();
        this.txtDistDir = new JTextField();
        this.ocDistDir = LocationComboFactory.createPOMChange(this.project, false);
        this.btnDistDir = (JButton)this.ocDistDir.getComponent();
        this.lblIssueTracking = new JLabel();
        this.txtIssueTracking = new JTextField();
        this.ocIssueTracking = LocationComboFactory.createPOMChange(this.project, false);
        this.btnIssueTracking = (JButton)this.ocIssueTracking.getComponent();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblOrganization.setLabelFor(this.btnOrganization);
        this.lblOrganization.setText("Organization:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.lblOrganization, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.btnOrganization, gridBagConstraints);
        this.pnlOrganization.setLayout(new GridBagLayout());
        this.pnlOrganization.setBorder(new EtchedBorder(0));
        this.lblName.setLabelFor(this.txtName);
        this.lblName.setText(NbBundle.getMessage((Class)OrgPanel.class, (String)"OrgPanel.lblName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.pnlOrganization.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.pnlOrganization.add((Component)this.txtName, gridBagConstraints);
        this.lblURL.setLabelFor(this.txtURL);
        this.lblURL.setText(NbBundle.getMessage((Class)OrgPanel.class, (String)"OrgPanel.lblURL.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.pnlOrganization.add((Component)this.lblURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.pnlOrganization.add((Component)this.txtURL, gridBagConstraints);
        this.btnURL.setText(NbBundle.getMessage((Class)OrgPanel.class, (String)"OrgPanel.btnURL.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 6);
        this.pnlOrganization.add((Component)this.btnURL, gridBagConstraints);
        this.lblLogo.setLabelFor(this.txtLogo);
        this.lblLogo.setText(NbBundle.getMessage((Class)OrgPanel.class, (String)"OrgPanel.lblLogo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.pnlOrganization.add((Component)this.lblLogo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 6, 0);
        this.pnlOrganization.add((Component)this.txtLogo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        this.add((Component)this.pnlOrganization, gridBagConstraints);
        this.lblSiteAddress.setLabelFor(this.txtSiteAddress);
        this.lblSiteAddress.setText(NbBundle.getMessage((Class)OrgPanel.class, (String)"OrgPanel.lblSiteAddress.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblSiteAddress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtSiteAddress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnSiteAddress, gridBagConstraints);
        this.lblSiteDir.setLabelFor(this.txtSiteDir);
        this.lblSiteDir.setText(NbBundle.getMessage((Class)OrgPanel.class, (String)"OrgPanel.lblSiteDir.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblSiteDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtSiteDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnSiteDir, gridBagConstraints);
        this.lblDistAddress.setLabelFor(this.txtDistAddress);
        this.lblDistAddress.setText(NbBundle.getMessage((Class)OrgPanel.class, (String)"OrgPanel.lblDistAddress.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblDistAddress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtDistAddress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnDistAddress, gridBagConstraints);
        this.lblDistDir.setLabelFor(this.txtDistDir);
        this.lblDistDir.setText(NbBundle.getMessage((Class)OrgPanel.class, (String)"OrgPanel.lblSiteDist.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblDistDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtDistDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnDistDir, gridBagConstraints);
        this.lblIssueTracking.setLabelFor(this.txtIssueTracking);
        this.lblIssueTracking.setText("Issue Tracking URL :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblIssueTracking, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtIssueTracking, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnIssueTracking, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
    }

    private void populateChangeInstances() {
        this.createChangeInstance("siteAddress", this.txtSiteAddress, this.ocSiteAddress);
        this.createChangeInstance("siteDirectory", this.txtSiteDir, this.ocSiteDir);
        this.createChangeInstance("distributionAddress", this.txtDistAddress, this.ocDistAddress);
        this.createChangeInstance("distributionDirectory", this.txtDistDir, this.ocDistDir);
        this.createChangeInstance("issueTrackingUrl", this.txtIssueTracking, this.ocIssueTracking);
        Organization org = this.project.getOriginalMavenProject().getOrganization();
        String key = "pom.organization";
        int location = this.project.getProjectWalker().getLocation(key);
        HashMap<String, String> oldValues = new HashMap<String, String>();
        if (org != null) {
            if (org.getUrl() != null) {
                oldValues.put("url", org.getUrl());
            }
            if (org.getName() != null) {
                oldValues.put("name", org.getName());
            }
            if (org.getLogo() != null) {
                oldValues.put("logo", org.getLogo());
            }
        }
        HashMap<String, JTextField> fields = new HashMap<String, JTextField>();
        fields.put("url", this.txtURL);
        fields.put("logo", this.txtLogo);
        fields.put("name", this.txtName);
        this.changes.put(key, new MultiTextComponentPOMChange(key, oldValues, location, fields, this.ocOrganization));
    }

    private void createChangeInstance(String propName, JTextField field, OriginChange oc) {
        String key = "pom." + propName;
        String value = this.project.getProjectWalker().getValue(key);
        int location = this.project.getProjectWalker().getLocation(key);
        if (value == null) {
            value = "";
        }
        this.changes.put(key, new TextComponentPOMChange(key, value, location, field, oc));
    }

    public void setResolveValues(boolean resolve) {
        this.assignValue("siteAddress", resolve);
        this.assignValue("siteDirectory", resolve);
        this.assignValue("distributionAddress", resolve);
        this.assignValue("distributionDirectory", resolve);
        this.assignValue("issueTrackingUrl", resolve);
        MultiTextComponentPOMChange change = (MultiTextComponentPOMChange)this.changes.get("pom.organization");
        if (resolve) {
            IContentProvider prov = change.getChangedContent();
            HashMap<String, String> resolvedvalues = new HashMap<String, String>();
            String val = prov.getValue("url");
            if (val != null) {
                resolvedvalues.put("url", this.project.getPropertyResolver().resolveString(val));
            }
            if ((val = prov.getValue("name")) != null) {
                resolvedvalues.put("name", this.project.getPropertyResolver().resolveString(val));
            }
            if ((val = prov.getValue("logo")) != null) {
                resolvedvalues.put("logo", this.project.getPropertyResolver().resolveString(val));
            }
            change.setResolvedValues(resolvedvalues);
        } else {
            change.resetToNonResolvedValue();
        }
    }

    private void assignValue(String actionName, boolean resolve) {
        String key = "pom." + actionName;
        TextComponentPOMChange change = (TextComponentPOMChange)this.changes.get(key);
        if (resolve) {
            String value = this.project.getPropertyResolver().resolveString(change.getNewValue());
            change.setResolvedValue(value);
        } else {
            change.resetToNonResolvedValue();
        }
    }

    public List getChanges() {
        ArrayList<MavenChange> toReturn = new ArrayList<MavenChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenChange change = (MavenChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    public boolean isInValidState() {
        return true;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    public String getValidityMessage() {
        return "";
    }
}

