/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.customizer.DefaultPluginPanel;
import org.mevenide.netbeans.project.customizer.PluginPanel;
import org.mevenide.netbeans.project.customizer.ProjectPanel;
import org.mevenide.netbeans.project.customizer.ProjectValidateObserver;
import org.mevenide.plugins.IPluginInfo;
import org.mevenide.plugins.PluginInfoFactory;
import org.mevenide.plugins.PluginInfoManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class PluginListPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)PluginListPanel.class);
    private ProjectValidateObserver valObserver;
    private MavenProject project;
    private Model mod;
    private List globalPanelList;
    private ConfigurationChildren childNodes;
    private List subPanelList;
    private ExplorerManager manager;
    private boolean initialized;
    private JLabel lblDescription;
    private JScrollPane spPlugins;
    private JTable tblPlugins;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public PluginListPanel(MavenProject proj, List panelsList, ExplorerManager man) {
        this.project = proj;
        this.globalPanelList = panelsList;
        this.manager = man;
        this.subPanelList = new ArrayList();
        this.childNodes = new ConfigurationChildren();
        this.initComponents();
        this.valObserver = null;
        this.initialized = false;
    }

    private void initComponents() {
        this.spPlugins = new JScrollPane();
        this.tblPlugins = new JTable();
        this.lblDescription = new JLabel();
        this.setLayout(new GridBagLayout());
        this.spPlugins.setViewportView(this.tblPlugins);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.spPlugins, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.lblDescription, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateTable();
        }
    }

    private void populateTable() {
        PluginInfoManager man = PluginInfoFactory.getInstance().createManager(this.project.getContext());
        IPluginInfo[] infos = man.getCurrentPlugins();
        final ArrayList<WrapperRow> vals = new ArrayList<WrapperRow>(10 + (infos != null ? infos.length : 0));
        WrapperRow rw = new UsedPropsWrapper();
        vals.add(rw);
        this.globalPanelList.add(rw.getCustomizer());
        rw = new DefaultPropsWrapper();
        vals.add(rw);
        this.globalPanelList.add(rw.getCustomizer());
        this.subPanelList.addAll(vals);
        if (infos != null) {
            for (int i = 0; i < infos.length; ++i) {
                boolean isUsed = man.isUsedByProject(infos[i]);
                rw = new PluginWrapper(infos[i], isUsed);
                vals.add(rw);
                if (!isUsed) continue;
                this.subPanelList.add(rw);
                this.globalPanelList.add(rw.getCustomizer());
            }
        }
        this.childNodes.refreshMyKeys();
        this.mod = new Model(vals);
        this.tblPlugins.setModel(this.mod);
        TableColumn col = this.tblPlugins.getTableHeader().getColumnModel().getColumn(0);
        col.setMaxWidth(40);
        col.setMinWidth(20);
        col.setPreferredWidth(30);
        this.setupColumn(1);
        this.setupColumn(2);
        col = this.tblPlugins.getTableHeader().getColumnModel().getColumn(3);
        col.setCellRenderer(this.mod);
        this.tblPlugins.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    PluginListPanel.this.tblPlugins.getModel().setValueAt(Boolean.TRUE, PluginListPanel.this.tblPlugins.getSelectedRow(), 0);
                    Node[] nds = PluginListPanel.this.childNodes.getNodes();
                    for (int i = 0; i < nds.length; ++i) {
                        ConfigurationNode nd = (ConfigurationNode)nds[i];
                        if (nd.getRow() != vals.get(PluginListPanel.this.tblPlugins.getSelectedRow())) continue;
                        try {
                            PluginListPanel.this.manager.setSelectedNodes(new Node[]{nd});
                            continue;
                        }
                        catch (PropertyVetoException exc) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    private void setupColumn(int column) {
        TableColumn col = this.tblPlugins.getTableHeader().getColumnModel().getColumn(column);
        col.setCellRenderer(this.mod);
        Component comp = this.tblPlugins.getDefaultRenderer(this.mod.getColumnClass(column)).getTableCellRendererComponent(this.tblPlugins, this.longestLine(column), false, false, 0, column);
        int cellWidth = comp.getPreferredSize().width;
        col.setPreferredWidth(cellWidth);
    }

    private String longestLine(int column) {
        int average = 0;
        for (int i = 0; i < this.mod.getRowCount(); ++i) {
            String val = (String)this.mod.getValueAt(i, column);
            average += val.length();
        }
        average /= this.mod.getRowCount();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < average; ++i) {
            buf.append("-");
        }
        return buf.toString();
    }

    public List getChanges() {
        return Collections.EMPTY_LIST;
    }

    public void setResolveValues(boolean resolve) {
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    public boolean isInValidState() {
        return true;
    }

    public String getValidityMessage() {
        return "";
    }

    public Children getNodeChildren() {
        return this.childNodes;
    }

    private static class ConfigurationNode
    extends AbstractNode {
        private WrapperRow row;

        public ConfigurationNode(WrapperRow description) {
            super(Children.LEAF);
            this.setName(description.getName());
            this.setDisplayName(description.getLongName());
            this.row = description;
            this.setIconBase("org/mevenide/netbeans/project/resources/Bullet");
        }

        public boolean hasCustomizer() {
            return true;
        }

        public Component getCustomizer() {
            return this.row.getCustomizer();
        }

        public WrapperRow getRow() {
            return this.row;
        }
    }

    private static class Comp
    implements Comparator {
        private Comp() {
        }

        public int compare(Object obj, Object obj1) {
            WrapperRow change1 = (WrapperRow)obj;
            WrapperRow change2 = (WrapperRow)obj1;
            if (change1 instanceof UsedPropsWrapper) {
                return -1;
            }
            if (change2 instanceof UsedPropsWrapper) {
                return 1;
            }
            if (change1 instanceof DefaultPropsWrapper) {
                return -1;
            }
            if (change2 instanceof DefaultPropsWrapper) {
                return 1;
            }
            return change1.getName().compareTo(change2.getName());
        }
    }

    private class ConfigurationChildren
    extends Children.Keys {
        public void addNotify() {
            if (!PluginListPanel.this.initialized) {
                PluginListPanel.this.initialized = true;
                PluginListPanel.this.populateTable();
            }
            TreeSet st = new TreeSet(new Comp());
            st.addAll(PluginListPanel.this.subPanelList);
            this.setKeys(st);
        }

        public void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
        }

        public void refreshMyKeys() {
            TreeSet st = new TreeSet(new Comp());
            st.addAll(PluginListPanel.this.subPanelList);
            this.setKeys(st);
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{new ConfigurationNode((WrapperRow)key)};
        }
    }

    private class Model
    implements TableModel,
    TableCellRenderer {
        private List rows;
        private DefaultTableCellRenderer delegate = new DefaultTableCellRenderer();

        public Model(List rowlist) {
            this.rows = rowlist;
        }

        public void setValueAt(Object aValue, int row, int column) {
            WrapperRow rw;
            if (column == 0 && (rw = (WrapperRow)this.rows.get(row)) instanceof PluginWrapper) {
                ((PluginWrapper)rw).setEnabled((Boolean)aValue);
            }
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "See";
            }
            if (column == 1) {
                return "Name";
            }
            if (column == 2) {
                return "Version";
            }
            if (column == 3) {
                return "Description";
            }
            return "XXX";
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = PluginListPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return class$java$lang$String == null ? (class$java$lang$String = PluginListPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int row, int column) {
            WrapperRow rowObj = (WrapperRow)this.rows.get(row);
            if (column == 0) {
                return rowObj.isEnabled();
            }
            if (column == 1) {
                return rowObj.getLongName();
            }
            if (column == 2) {
                return rowObj.getVersion();
            }
            if (column == 3) {
                return rowObj.getDescription();
            }
            return "";
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            Component com = this.delegate.getTableCellRendererComponent(jTable, obj, isSelected, hasFocus, row, column);
            if (com instanceof JLabel) {
                JLabel lbl = (JLabel)com;
                WrapperRow wr = (WrapperRow)this.rows.get(row);
                lbl.setToolTipText(wr.getDescription());
                lbl.setBackground(UIManager.getColor("Label.background"));
            }
            return com;
        }
    }

    private class PluginWrapper
    implements WrapperRow {
        private boolean enabled;
        private IPluginInfo info;
        private Component customizer;

        public PluginWrapper(IPluginInfo plugininfo, boolean en) {
            this.info = plugininfo;
            this.enabled = en;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bool) {
            this.enabled = bool;
            if (this.enabled) {
                PluginListPanel.this.subPanelList.add(this);
                PluginListPanel.this.globalPanelList.add(this.getCustomizer());
            } else {
                PluginListPanel.this.subPanelList.remove(this);
            }
            PluginListPanel.this.childNodes.refreshMyKeys();
        }

        public String getName() {
            return this.info.getName();
        }

        public String getLongName() {
            String ln = this.info.getLongName();
            if (ln.startsWith("Maven ")) {
                ln = ln.substring("Maven ".length());
            }
            return ln;
        }

        public String getDescription() {
            return this.info.getDescription();
        }

        public String getVersion() {
            return this.info.getVersion();
        }

        public Component getCustomizer() {
            if (this.customizer == null) {
                this.customizer = PluginPanel.createPluginPanel(PluginListPanel.this.project, this.info);
            }
            return this.customizer;
        }
    }

    private class UsedPropsWrapper
    implements WrapperRow {
        private Component customizer = null;

        private UsedPropsWrapper() {
        }

        public boolean isEnabled() {
            return true;
        }

        public String getName() {
            return "used";
        }

        public String getLongName() {
            return "Used Properties";
        }

        public String getDescription() {
            return "All properties that are used/defined in the project independent of plugin.";
        }

        public String getVersion() {
            return "";
        }

        public Component getCustomizer() {
            if (this.customizer == null) {
                this.customizer = PluginPanel.createUsedPanel(PluginListPanel.this.project);
            }
            return this.customizer;
        }
    }

    private class DefaultPropsWrapper
    implements WrapperRow {
        private Component customizer = null;

        private DefaultPropsWrapper() {
        }

        public boolean isEnabled() {
            return true;
        }

        public String getName() {
            return "default";
        }

        public String getLongName() {
            return "Default properties";
        }

        public String getDescription() {
            return "Maven's default propetries";
        }

        public String getVersion() {
            return "";
        }

        public Component getCustomizer() {
            if (this.customizer == null) {
                this.customizer = new DefaultPluginPanel(PluginListPanel.this.project);
            }
            return this.customizer;
        }
    }

    private static interface WrapperRow {
        public boolean isEnabled();

        public String getName();

        public String getLongName();

        public String getDescription();

        public String getVersion();

        public Component getCustomizer();
    }
}

