/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;
import org.openide.util.Utilities;

class LocationComboBox
extends JButton {
    private LocationWrapper current;
    private LocationWrapper[] all;
    private JPopupMenu currentLoc;
    private OriginChange.ChangeObserver observer;
    private boolean showText;

    public LocationComboBox(boolean show) {
        this.showText = show;
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(true);
        this.setBorder(new MyBorder());
        this.setRolloverEnabled(true);
        this.currentLoc = new JPopupMenu();
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LocationComboBox.this.currentLoc.show(LocationComboBox.this, 0, LocationComboBox.this.getSize().height);
            }
        });
        this.setIcon(new ImageIcon(Utilities.loadImage((String)"org/openide/resources/actions/empty.gif")));
        this.setText("");
    }

    public LocationWrapper getSelectedItem() {
        return this.current;
    }

    public void setInitialItem(int location) {
        LocationWrapper selected = this.findWrapper(location);
        this.setSelectedItem(selected);
    }

    private void setSelectedItem(LocationWrapper selected) {
        this.setToolTipText(selected.getName());
        this.setIcon(selected.getIcon());
        this.setDisabledIcon(selected.getIcon());
        if (this.showText) {
            this.setText(selected.getName());
        }
        this.currentLoc.removeAll();
        this.initStatePopup(selected);
        this.current = selected;
    }

    public void setItems(LocationWrapper[] wrappers) {
        this.all = wrappers;
    }

    public LocationWrapper[] getItems() {
        return this.all;
    }

    public void invokePopupAction(LocationWrapper wrap) {
        this.setSelectedItem(wrap);
        if (this.observer != null) {
            this.observer.locationChanged();
        }
    }

    public void invokePopupAction(int location) {
        LocationWrapper wrap = this.findWrapper(location);
        if (wrap != null) {
            this.invokePopupAction(wrap);
        } else {
            System.out.println("how come, no wrapper for " + location);
        }
    }

    private LocationWrapper findWrapper(int location) {
        for (int i = 0; i < this.all.length; ++i) {
            if (this.all[i].getID() != location) continue;
            return this.all[i];
        }
        return null;
    }

    public void setChangeObserver(OriginChange.ChangeObserver obs) {
        this.observer = obs;
    }

    private void initStatePopup(LocationWrapper selItem) {
        if (selItem == null) {
            return;
        }
        for (int i = 0; i < this.all.length; ++i) {
            if (this.all[i] == selItem || !this.all[i].includeInPopup()) continue;
            String name = this.all[i].getMoveName();
            Icon icon = this.all[i].getIcon();
            JMenuItem item = this.currentLoc.add(name);
            item.setAction(new MyAction(this.all[i], name, icon));
        }
    }

    private class MyBorder
    implements Border {
        private MyBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.translate(x, y);
            Color col = null;
            LocationComboBox box = (LocationComboBox)c;
            if (box.getModel().isRollover()) {
                col = UIManager.getColor("InternalFrame.borderHighlight");
            }
            if (box.isFocusOwner()) {
                col = UIManager.getColor("InternalFrame.borderLight");
            }
            if (col != null) {
                g.setColor(col);
                g.drawRect(0, 0, width - 1, height - 1);
            }
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class MyAction
    extends AbstractAction {
        private LocationWrapper wrapper;

        public MyAction(LocationWrapper wrap, String name, Icon icon) {
            this.wrapper = wrap;
            this.putValue("Name", name);
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent e) {
            LocationComboBox.this.invokePopupAction(this.wrapper);
        }
    }

    static class LocationWrapper {
        private String name;
        private Icon icon;
        private File file;
        private int loc;
        private String moveName;
        private Icon moveIcon;

        public LocationWrapper(String nm, Icon icn, String mvName, Icon mvIcon, File fil, int id) {
            this.name = nm;
            this.icon = icn;
            this.file = fil;
            this.loc = id;
            this.moveName = mvName;
            this.moveIcon = mvIcon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public Icon getMoveIcon() {
            return this.moveIcon;
        }

        public String getMoveName() {
            return this.moveName;
        }

        public boolean includeInPopup() {
            return this.moveName != null;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            return this.getName();
        }

        public int getID() {
            return this.loc;
        }
    }
}

