/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.mevenide.netbeans.project.customizer.ui.TableRowPropertyChange;
import org.mevenide.properties.IPropertyResolver;

public class PropertyTableModel
implements TableModel,
TableCellRenderer {
    private static final int COLUMN_KEY = 0;
    private static final int COLUMN_VALUE = 1;
    private static final int COLUMN_ORIGIN = 2;
    private ArrayList lst;
    private DefaultTableCellRenderer keyDelegate;
    private DefaultTableCellRenderer valueDelegate;
    private boolean resolve;
    private IPropertyResolver resolver;
    private List listeners;

    public PropertyTableModel(IPropertyResolver res, Collection valuelist) {
        TreeSet set = new TreeSet(new KeyComparator());
        set.addAll(valuelist);
        this.lst = new ArrayList(set);
        this.keyDelegate = new DefaultTableCellRenderer();
        this.valueDelegate = new DefaultTableCellRenderer();
        this.resolve = false;
        this.resolver = res;
        this.listeners = new ArrayList();
    }

    public void setResolve(boolean res) {
        this.resolve = res;
        this.fireTableModelChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableModelChange() {
        TableModelEvent event = new TableModelEvent(this);
        ArrayList toFire = null;
        List list = this.listeners;
        synchronized (list) {
            toFire = new ArrayList(this.listeners);
        }
        Iterator it = toFire.iterator();
        while (it.hasNext()) {
            TableModelListener list2 = (TableModelListener)it.next();
            list2.tableChanged(event);
        }
    }

    public Object getValueAt(int row, int column) {
        TableRowPropertyChange change = (TableRowPropertyChange)this.lst.get(row);
        if (column == 0) {
            return change.getKey();
        }
        if (column == 1) {
            return change.getNewValue();
        }
        if (column == 2) {
            return new Integer(change.getNewLocation());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableModelListener(TableModelListener tableModelListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(tableModelListener);
        }
    }

    public Class getColumnClass(int param) {
        if (param == 2) {
            return Integer.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Property Key";
        }
        if (column == 1) {
            return "Property Value";
        }
        if (column == 2) {
            return "Location";
        }
        return "";
    }

    public int getRowCount() {
        return this.lst.size();
    }

    public boolean isCellEditable(int row, int column) {
        if (this.resolve) {
            return false;
        }
        if (column == 1 || column == 2) {
            TableRowPropertyChange change = (TableRowPropertyChange)this.lst.get(row);
            return change.getNewLocation() != 99;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableModelListener(TableModelListener tableModelListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(tableModelListener);
        }
    }

    public void setValueAt(Object obj, int row, int column) {
        TableRowPropertyChange change;
        if (column == 1) {
            change = (TableRowPropertyChange)this.lst.get(row);
            if (!obj.toString().equals(change.getNewValue())) {
                change.setNewValue(obj.toString());
                this.fireTableModelChange();
            }
        }
        if (column == 2) {
            change = (TableRowPropertyChange)this.lst.get(row);
            Integer integ = (Integer)obj;
            change.setNewLocation(integ);
            this.fireTableModelChange();
        }
    }

    public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        TableRowPropertyChange change = (TableRowPropertyChange)this.lst.get(row);
        if (column == 0) {
            Component com = this.keyDelegate.getTableCellRendererComponent(jTable, change.getKey(), isSelected, hasFocus, row, column);
            if (com instanceof JLabel) {
                JLabel lbl = (JLabel)com;
                lbl.setToolTipText(change.getKey());
                lbl.setBackground(UIManager.getColor("Label.background"));
            }
            return com;
        }
        if (column == 1) {
            String val;
            DefaultTableCellRenderer render = this.resolve || change.getNewLocation() == 99 ? this.keyDelegate : this.valueDelegate;
            Component com = render.getTableCellRendererComponent(jTable, val = this.resolve ? this.resolver.resolveString(change.getNewValue()) : change.getNewValue(), isSelected, hasFocus, row, column);
            if (com instanceof JLabel) {
                JLabel lbl = (JLabel)com;
                lbl.setToolTipText(val);
            }
            return com;
        }
        if (column == 2) {
            return change.getOriginComponent();
        }
        return this.keyDelegate.getTableCellRendererComponent(jTable, "", isSelected, hasFocus, row, column);
    }

    private static class KeyComparator
    implements Comparator {
        private KeyComparator() {
        }

        public int compare(Object obj, Object obj1) {
            TableRowPropertyChange change1 = (TableRowPropertyChange)obj;
            TableRowPropertyChange change2 = (TableRowPropertyChange)obj1;
            return change1.getKey().compareTo(change2.getKey());
        }
    }
}

