/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.dependencies;

import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.project.Dependency;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.customizer.DependencyPOMChange;
import org.mevenide.netbeans.project.dependencies.DependencyNode;
import org.mevenide.netbeans.project.dependencies.MultiRepositoryNode;
import org.mevenide.netbeans.project.dependencies.RepoPathGrouper;
import org.mevenide.netbeans.project.dependencies.RepositoryUtilities;
import org.mevenide.netbeans.project.writer.NbProjectWriter;
import org.mevenide.repository.IRepositoryReader;
import org.mevenide.repository.RepoPathElement;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class DependencyChildren
extends Children.Keys {
    private static final String KEY_VERSIONS = "Versions";
    private static final String KEY_SOURCES = "Sources";
    private static final String KEY_CLASSES = "Classes";
    private static final String KEY_JAVADOC = "Javadoc";
    private MavenProject project;
    private DependencyPOMChange change;
    private DependencyNode parentNode;
    static /* synthetic */ Class class$org$mevenide$repository$RepoPathElement;
    static /* synthetic */ Class class$java$util$List;

    public DependencyChildren(Lookup lookup) {
        this.project = (MavenProject)lookup.lookup(MavenProject.class);
        this.change = (DependencyPOMChange)lookup.lookup(DependencyPOMChange.class);
    }

    protected Node[] createNodes(Object obj) {
        Node node = null;
        if (obj == KEY_VERSIONS) {
            node = this.createVersionsNode();
        }
        if (obj == KEY_SOURCES) {
            node = this.createSourcesNode();
        }
        if (obj == KEY_CLASSES) {
            node = this.createClassesNode();
        }
        if (obj == KEY_JAVADOC) {
            node = this.createJavadocNode();
        }
        if (node == null) {
            return new Node[0];
        }
        return new Node[]{node};
    }

    protected void removeNotify() {
        super.removeNotify();
        this.setKeys(Collections.EMPTY_LIST);
    }

    protected void addNotify() {
        this.parentNode = (DependencyNode)this.getNode();
        this.doRefresh();
        super.addNotify();
    }

    void doRefresh() {
        if (this.parentNode == null) {
            return;
        }
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add(KEY_VERSIONS);
        if (!this.parentNode.isDependencyProjectOpen()) {
            if (this.parentNode.hasSourceInRepository()) {
                nodes.add(KEY_SOURCES);
            } else {
                nodes.add(KEY_CLASSES);
            }
            if (this.parentNode.hasJavadocInRepository()) {
                nodes.add(KEY_JAVADOC);
            }
        }
        this.setKeys(nodes);
    }

    private Node createVersionsNode() {
        IRepositoryReader[] readers = RepositoryUtilities.createRemoteReaders(this.project.getPropertyResolver());
        Dependency dep = DependencyNode.createDependencySnapshot(this.change.getChangedContent());
        RepoPathElement[] els = new RepoPathElement[readers.length + 1];
        String grId = dep.getGroupId() != null ? dep.getGroupId() : dep.getId();
        String artId = dep.getArtifactId() != null ? dep.getArtifactId() : dep.getId();
        String type = dep.getType() == null ? "jar" : dep.getType();
        String ext = dep.getExtension();
        for (int i = 0; i < els.length; ++i) {
            IRepositoryReader read = i == 0 ? RepositoryUtilities.createLocalReader(this.project.getLocFinder()) : readers[i - 1];
            els[i] = new RepoPathElement(read, null, grId, type, null, artId, ext);
        }
        RepoPathGrouper gr = new RepoPathGrouper(els);
        MultiRepositoryNode nd = new MultiRepositoryNode(gr);
        AbstractNode ret = new AbstractNode((Children)new VersionsChildren((Node)nd));
        ret.setName("versions");
        ret.setDisplayName("Available Versions");
        ret.setIconBase("org/mevenide/netbeans/project/resources/Versions");
        return ret;
    }

    private Node createSourcesNode() {
        Dependency dep = DependencyNode.createDependencySnapshot(this.change.getChangedContent());
        dep.setType("src.jar");
        URI uri = FileUtilities.getDependencyURI(dep, this.project);
        FileObject obj = FileUtilities.convertURItoFileObject(uri);
        if (obj != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)obj);
                Node original = dobj.getNodeDelegate();
                AbstractNode src = new AbstractNode((Children)new FilterNode.Children(original));
                src.setName("sources");
                src.setDisplayName("Browse Sources");
                return src;
            }
            catch (DataObjectNotFoundException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
                return null;
            }
        }
        return null;
    }

    private Node createJavadocNode() {
        Dependency dep = DependencyNode.createDependencySnapshot(this.change.getChangedContent());
        dep.setType("javadoc.jar");
        URI uri = FileUtilities.getDependencyURI(dep, this.project);
        FileObject obj = FileUtilities.convertURItoFileObject(uri);
        if (obj == null) {
            dep.setType("javadoc");
            uri = FileUtilities.getDependencyURI(dep, this.project);
            obj = FileUtilities.convertURItoFileObject(uri);
        }
        if (obj != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)obj);
                Node original = dobj.getNodeDelegate();
                AbstractNode src = new AbstractNode((Children)new FilterNode.Children(original));
                src.setName("javadoc");
                src.setDisplayName("Browse Javadoc");
                return src;
            }
            catch (DataObjectNotFoundException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
                return null;
            }
        }
        return null;
    }

    private Node createClassesNode() {
        Dependency dep = DependencyNode.createDependencySnapshot(this.change.getChangedContent());
        URI uri = FileUtilities.getDependencyURI(dep, this.project);
        FileObject obj = FileUtilities.convertURItoFileObject(uri);
        if (obj != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)obj);
                Node original = dobj.getNodeDelegate();
                AbstractNode src = new AbstractNode((Children)new FilterNode.Children(original));
                src.setName("content");
                src.setDisplayName("Browse Content");
                return src;
            }
            catch (DataObjectNotFoundException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
                return null;
            }
        }
        return null;
    }

    private class SetAsDependencyAction
    extends AbstractAction {
        private Lookup lookup;

        public SetAsDependencyAction(Lookup look) {
            this.lookup = look;
            this.putValue("Name", "Set as Dependency");
        }

        public void actionPerformed(ActionEvent e) {
            Lookup.Result res = this.lookup.lookup(new Lookup.Template(class$org$mevenide$repository$RepoPathElement == null ? (class$org$mevenide$repository$RepoPathElement = DependencyChildren.class$("org.mevenide.repository.RepoPathElement")) : class$org$mevenide$repository$RepoPathElement));
            Collection col = res.allInstances();
            RepoPathElement element = (RepoPathElement)col.iterator().next();
            HashMap newValues = DependencyChildren.this.change.getOldValues();
            newValues.put("version", element.getVersion());
            DependencyChildren.this.change.setNewValues(newValues, DependencyChildren.this.change.getOldProperties());
            try {
                NbProjectWriter writer = new NbProjectWriter(DependencyChildren.this.project);
                List deps = (List)DependencyChildren.this.getNode().getLookup().lookup(class$java$util$List == null ? (class$java$util$List = DependencyChildren.class$("java.util.List")) : class$java$util$List);
                writer.applyChanges(deps);
            }
            catch (Exception exc) {
                ErrorManager.getDefault().notify(256, (Throwable)exc);
            }
        }
    }

    private class OneVersionNode
    extends FilterNode {
        public OneVersionNode(Node original) {
            super(original);
        }

        public Action[] getActions(boolean context) {
            Action[] parent = super.getActions(context);
            Action[] toRet = new Action[parent.length + 1];
            toRet[0] = new SetAsDependencyAction(this.getLookup());
            for (int i = 1; i < toRet.length; ++i) {
                toRet[i] = parent[i - 1];
            }
            return toRet;
        }
    }

    private class VersionsChildren
    extends FilterNode.Children {
        VersionsChildren(Node original) {
            super(original);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Node) {
                return new Node[]{new OneVersionNode((Node)key)};
            }
            return super.createNodes(key);
        }
    }
}

