/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.exec;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.goals.grabber.IGoalsGrabber;
import org.mevenide.goals.grabber.ProjectGoalsGrabber;
import org.mevenide.netbeans.project.ActionProviderImpl;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.MavenSettings;
import org.mevenide.netbeans.project.exec.DefaultRunConfig;
import org.mevenide.netbeans.project.exec.RunConfig;
import org.mevenide.netbeans.project.exec.RunGoalsPanel;
import org.mevenide.netbeans.project.goals.GoalUtils;
import org.mevenide.netbeans.project.goals.GoalsGrabberProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class RunGoalsAction
extends AbstractAction
implements Presenter.Popup {
    private static Log log = LogFactory.getLog((Class)RunGoalsAction.class);
    private static final int MAX_ITEMS_IN_POPUP = 17;
    private static final int MAX_LENGTH_OF_ITEM = 30;
    private MavenProject project;
    private static final int ACTION_RUN = 0;
    private static final int ACTION_SHOW_CUSTOM_DIALOG = 1;
    static /* synthetic */ Class class$org$mevenide$netbeans$project$ActionProviderImpl;

    public RunGoalsAction(MavenProject proj) {
        this.putValue("Name", NbBundle.getMessage((Class)RunGoalsAction.class, (String)"LBL_RunGoalsAction"));
        this.project = proj;
    }

    public JMenuItem getPopupPresenter() {
        return new SpecialSubMenu(this, new ActSubMenuModel(this.project), true);
    }

    public void actionPerformed(ActionEvent e) {
    }

    private static class GPanel
    extends JPanel
    implements RunConfig {
        private RunGoalsPanel panel;
        private JCheckBox cbAdd;

        public GPanel(MavenProject project, GoalsGrabberProvider provider) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints con = new GridBagConstraints();
            con.insets = new Insets(12, 12, 6, 12);
            con.anchor = 18;
            this.panel = new RunGoalsPanel(project, provider);
            this.add((Component)this.panel, con);
            this.cbAdd = new JCheckBox();
            this.cbAdd.setText(NbBundle.getMessage((Class)(class$org$mevenide$netbeans$project$exec$RunGoalsAction == null ? (class$org$mevenide$netbeans$project$exec$RunGoalsAction = RunGoalsAction.class$("org.mevenide.netbeans.project.exec.RunGoalsAction")) : class$org$mevenide$netbeans$project$exec$RunGoalsAction), (String)"RunGoalsAction.cbAdd.text"));
            this.cbAdd.setToolTipText(NbBundle.getMessage((Class)(class$org$mevenide$netbeans$project$exec$RunGoalsAction == null ? (class$org$mevenide$netbeans$project$exec$RunGoalsAction = RunGoalsAction.class$("org.mevenide.netbeans.project.exec.RunGoalsAction")) : class$org$mevenide$netbeans$project$exec$RunGoalsAction), (String)"RunGoalsAction.cbAdd.tooltip"));
            this.cbAdd.setMnemonic(NbBundle.getMessage((Class)(class$org$mevenide$netbeans$project$exec$RunGoalsAction == null ? (class$org$mevenide$netbeans$project$exec$RunGoalsAction = RunGoalsAction.class$("org.mevenide.netbeans.project.exec.RunGoalsAction")) : class$org$mevenide$netbeans$project$exec$RunGoalsAction), (String)"RunGoalsAction.cbAdd.mnemonic").charAt(0));
            con = new GridBagConstraints();
            con.insets = new Insets(0, 12, 12, 12);
            con.gridx = 0;
            con.gridy = 1;
            con.anchor = 18;
            this.add((Component)this.cbAdd, con);
        }

        public String getGoalsToExecute() {
            return this.panel.getGoalsToExecute();
        }

        public boolean doAddToFavourites() {
            return this.cbAdd.isSelected();
        }

        public boolean isOffline() {
            return this.panel.isOffline();
        }

        public boolean isDebug() {
            return this.panel.isDebug();
        }

        public boolean isExceptions() {
            return this.panel.isExceptions();
        }

        public boolean isNoBanner() {
            return this.panel.isNoBanner();
        }

        public boolean isNonverbose() {
            return this.panel.isNonverbose();
        }

        public String getMavenHome() {
            return this.panel.getMavenHome();
        }

        public String getMavenLocalHome() {
            return this.panel.getMavenLocalHome();
        }
    }

    private static class ItemWrapper {
        private String goals;
        private int actionType;

        public ItemWrapper(String gls) {
            this.goals = gls;
            this.actionType = 0;
        }

        public ItemWrapper(String gls, int actionTp) {
            this(gls);
            this.actionType = actionTp;
        }

        public String getGoals() {
            return this.goals;
        }

        public int getType() {
            return this.actionType;
        }
    }

    private static final class ActSubMenuModel
    implements Actions.SubMenuModel {
        private List targets = null;
        private MavenProject project = null;

        ActSubMenuModel(MavenProject proj) {
            this.project = proj;
        }

        public int getCount() {
            if (this.targets == null) {
                return 0;
            }
            return this.targets.size();
        }

        public String getLabel(int index) {
            ItemWrapper item = (ItemWrapper)this.targets.get(index);
            return item == null ? null : item.getGoals();
        }

        public HelpCtx getHelpCtx(int index) {
            return new HelpCtx("org.mevenide.ui.netbeans");
        }

        public void performActionAt(int index) {
            ItemWrapper item = (ItemWrapper)this.targets.get(index);
            if (item == null) {
                return;
            }
            String mgoal = item.getGoals();
            RunConfig config = null;
            log.debug((Object)("item=" + item.getGoals() + " of type " + item.getType()));
            if (item.getType() == 1) {
                GoalsGrabberProvider goalProvider = GoalUtils.createProjectGoalsProvider(this.project.getContext(), this.project.getLocFinder());
                GPanel panel = new GPanel(this.project, goalProvider);
                DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage((Class)(class$org$mevenide$netbeans$project$exec$RunGoalsAction == null ? (class$org$mevenide$netbeans$project$exec$RunGoalsAction = RunGoalsAction.class$("org.mevenide.netbeans.project.exec.RunGoalsAction")) : class$org$mevenide$netbeans$project$exec$RunGoalsAction), (String)"RunGoalsAction.dialog.title"));
                Object[] options = new Object[]{new JButton(NbBundle.getMessage((Class)(class$org$mevenide$netbeans$project$exec$RunGoalsAction == null ? (class$org$mevenide$netbeans$project$exec$RunGoalsAction = RunGoalsAction.class$("org.mevenide.netbeans.project.exec.RunGoalsAction")) : class$org$mevenide$netbeans$project$exec$RunGoalsAction), (String)"RunGoalsAction.executeButton")), NotifyDescriptor.CANCEL_OPTION};
                desc.setOptions(options);
                desc.setClosingOptions(options);
                desc.setValue(options[0]);
                Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                if (!retValue.equals(options[0]) || panel.getGoalsToExecute().trim().length() == 0) {
                    return;
                }
                mgoal = panel.getGoalsToExecute();
                if (panel.doAddToFavourites()) {
                    this.doValidateAndAddToFavs(goalProvider, mgoal);
                }
                config = panel;
            } else {
                config = new DefaultRunConfig();
            }
            final String goal = mgoal;
            final DefaultRunConfig fConfig = config;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ActionProviderImpl impl = (ActionProviderImpl)ActSubMenuModel.this.project.getLookup().lookup(class$org$mevenide$netbeans$project$ActionProviderImpl == null ? (class$org$mevenide$netbeans$project$ActionProviderImpl = RunGoalsAction.class$("org.mevenide.netbeans.project.ActionProviderImpl")) : class$org$mevenide$netbeans$project$ActionProviderImpl);
                    impl.runGoal(goal, ActSubMenuModel.this.project.getLookup(), fConfig);
                }
            });
        }

        private void doValidateAndAddToFavs(GoalsGrabberProvider provider, String goals) {
            try {
                IGoalsGrabber grabber = provider.getGoalsGrabber();
                StringTokenizer token = new StringTokenizer(goals, " ");
                while (token.hasMoreTokens()) {
                    String goal = token.nextToken();
                    String origin = grabber.getOrigin(goal);
                    if (origin != null && !"Project".equals(origin)) continue;
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$mevenide$netbeans$project$exec$RunGoalsAction == null ? (class$org$mevenide$netbeans$project$exec$RunGoalsAction = RunGoalsAction.class$("org.mevenide.netbeans.project.exec.RunGoalsAction")) : class$org$mevenide$netbeans$project$exec$RunGoalsAction), (String)"RunGoalsAction.warning1", (Object)goal));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                MavenSettings settings = MavenSettings.getDefault();
                String[] oldGoals = settings.getTopGoals();
                String[] newGoals = new String[oldGoals.length + 1];
                for (int i = 0; i < oldGoals.length; ++i) {
                    newGoals[i] = oldGoals[i];
                }
                newGoals[oldGoals.length] = goals;
                settings.setTopGoals(newGoals);
                if (settings.isShowAddFavouriteHint()) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$mevenide$netbeans$project$exec$RunGoalsAction == null ? (class$org$mevenide$netbeans$project$exec$RunGoalsAction = RunGoalsAction.class$("org.mevenide.netbeans.project.exec.RunGoalsAction")) : class$org$mevenide$netbeans$project$exec$RunGoalsAction), (String)"RunGoalsAction.hint1"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    MavenSettings.getDefault().setShowAddFavouriteHint(false);
                }
            }
            catch (Exception exc) {
                log.error((Object)"Cannot create goals grabber", (Throwable)exc);
                ErrorManager.getDefault().notify(4096, (Throwable)exc);
            }
        }

        void addNotify() {
            this.targets = Collections.EMPTY_LIST;
            if (this.project.getOriginalMavenProject() == null) {
                return;
            }
            this.targets = new ArrayList(15);
            File[] fls = this.project.getContext().getPOMContext().getProjectFiles();
            for (int x = 0; x < fls.length; ++x) {
                File mavenxml = new File(fls[x].getParentFile(), "maven.xml");
                if (!mavenxml.exists()) continue;
                try {
                    ProjectGoalsGrabber grabber = new ProjectGoalsGrabber();
                    grabber.setMavenXmlFile(mavenxml.getAbsolutePath());
                    grabber.refresh();
                    String[] plugins = grabber.getPlugins();
                    if (plugins == null) continue;
                    for (int i = 0; i < plugins.length; ++i) {
                        String[] goals = grabber.getGoals(plugins[i]);
                        if (goals == null) continue;
                        for (int j = 0; j < goals.length; ++j) {
                            if ("(default)".equals(goals[j])) {
                                this.targets.add(new ItemWrapper(plugins[i]));
                                continue;
                            }
                            this.targets.add(new ItemWrapper(plugins[i] + ":" + goals[j]));
                        }
                    }
                    this.targets.add(null);
                    continue;
                }
                catch (Exception ioe) {
                    log.error((Object)"Error loading project-specific goals", (Throwable)ioe);
                }
            }
            String[] str = MavenSettings.getDefault().getTopGoals();
            if (str != null) {
                for (int i = 0; i < str.length; ++i) {
                    if (this.targets.size() >= 17) continue;
                    this.targets.add(new ItemWrapper(str[i].length() > 30 ? str[i].substring(0, 27) + "..." : str[i]));
                }
            }
            this.targets.add(new ItemWrapper(NbBundle.getMessage((Class)(class$org$mevenide$netbeans$project$exec$RunGoalsAction == null ? (class$org$mevenide$netbeans$project$exec$RunGoalsAction = RunGoalsAction.class$("org.mevenide.netbeans.project.exec.RunGoalsAction")) : class$org$mevenide$netbeans$project$exec$RunGoalsAction), (String)"RunGoalsAction.moreGoals"), 1));
            if (this.targets.size() == 1) {
                this.targets.add(null);
            }
        }

        public synchronized void addChangeListener(ChangeListener l) {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
        }
    }

    private static final class SpecialSubMenu
    extends Actions.SubMenu {
        private final ActSubMenuModel model;

        SpecialSubMenu(Action action, ActSubMenuModel mdl, boolean popup) {
            super(action, (Actions.SubMenuModel)mdl, popup);
            this.model = mdl;
            this.model.addNotify();
        }

        public void addNotify() {
            super.addNotify();
        }
    }
}

