/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.libraries;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.context.DefaultQueryContext;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.environment.LocationFinderAggregator;
import org.mevenide.environment.SysEnvLocationFinder;
import org.mevenide.environment.sysenv.SysEnvProvider;
import org.mevenide.netbeans.project.NbSysEnvProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenRepoLibraryProvider
implements LibraryProvider {
    private static final Log logger = LogFactory.getLog((Class)MavenRepoLibraryProvider.class);
    public static final String TYPE = "MavenRepository";
    public static final String VOLUME_TYPE_CLASSPATH = "classpath";
    private PropertyChangeSupport support;
    private ILocationFinder finder;
    private File locRepoFile;

    public MavenRepoLibraryProvider() {
        SysEnvLocationFinder.setDefaultSysEnvProvider((SysEnvProvider)new NbSysEnvProvider());
        this.support = new PropertyChangeSupport(this);
        this.locRepoFile = this.findRepo();
        logger.debug((Object)"created instance");
        logger.debug((Object)("repo=" + this.locRepoFile));
    }

    public void setMavenContext(ILocationFinder locFinder) {
        this.finder = locFinder;
        File newRepo = this.findRepo();
        if (newRepo != null && !newRepo.equals(this.locRepoFile)) {
            this.locRepoFile = newRepo;
            this.fireLibrariesChanged();
        }
    }

    private File findRepo() {
        if (this.finder == null) {
            this.finder = new LocationFinderAggregator(DefaultQueryContext.getNonProjectContextInstance());
        }
        File toReturn = new File(this.finder.getMavenLocalRepository());
        return toReturn;
    }

    private void fireLibrariesChanged() {
        this.support.firePropertyChange("libraries", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public LibraryImplementation[] getLibraries() {
        logger.debug((Object)"getLibraries");
        File obj = this.locRepoFile;
        if (obj != null) {
            FileObject[] groups;
            HashSet toReturn = new HashSet();
            FileObject root = FileUtil.toFileObject((File)obj);
            if (root != null && (groups = root.getChildren()) != null && groups.length > 0) {
                for (int i = 0; i < groups.length; ++i) {
                    this.processGroup(groups[i], toReturn);
                }
            }
            LibraryImplementation[] impls = new LibraryImplementation[toReturn.size()];
            impls = toReturn.toArray(impls);
            return impls;
        }
        return new LibraryImplementation[0];
    }

    private void processGroup(FileObject fo, Set libraries) {
        logger.debug((Object)("processGroup:" + fo.getName()));
        FileObject[] types = fo.getChildren();
        if (types != null && types.length > 0) {
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].isFolder()) continue;
                String type = types[i].getName();
                if (type.length() > 1 && type.endsWith("s")) {
                    type = type.substring(0, type.length() - 1);
                }
                if (!"jar".equals(type)) continue;
                this.processType(types[i], type, libraries);
            }
        }
    }

    private void processType(FileObject type, String typStr, Set libraries) {
        logger.debug((Object)("processType" + type.getName() + " typ=" + typStr));
        FileObject[] artifacts = type.getChildren();
        if (artifacts != null && artifacts.length > 0) {
            for (int i = 0; i < artifacts.length; ++i) {
                logger.debug((Object)("Artifact=" + artifacts[i].getNameExt() + " isdata=" + artifacts[i].isData()));
                if (!artifacts[i].isData() || !artifacts[i].getExt().equals(typStr)) continue;
                try {
                    LibraryImplementation library = LibrariesSupport.createLibraryImplementation((String)"j2se", (String[])new String[]{VOLUME_TYPE_CLASSPATH, "javadoc", "src"});
                    library.setName(artifacts[i].getNameExt());
                    StringBuffer desc = new StringBuffer();
                    desc.append("\nType:").append(library.getType());
                    library.setDescription(desc.toString());
                    library.setLocalizingBundle(null);
                    ArrayList<URL> urls = new ArrayList<URL>();
                    URL url = FileUtil.toFile((FileObject)artifacts[i]).toURI().toURL();
                    url = FileUtil.getArchiveRoot((URL)url);
                    urls.add(url);
                    logger.debug((Object)("url=" + url));
                    library.setContent(VOLUME_TYPE_CLASSPATH, urls);
                    this.checkJavadocAndSrc(library, artifacts[i]);
                    libraries.add(library);
                    continue;
                }
                catch (Exception exc) {
                    logger.error((Object)"Error while creating library", (Throwable)exc);
                }
            }
        }
    }

    private void checkJavadocAndSrc(LibraryImplementation library, FileObject artifact) throws Exception {
        FileObject srcFile;
        URL url;
        ArrayList<URL> urls;
        FileObject javadocFile;
        String artName = artifact.getName();
        FileObject groupDir = artifact.getParent().getParent();
        FileObject javadocsDir = groupDir.getFileObject("javadocs");
        FileObject srcsDir = groupDir.getFileObject("src");
        if (javadocsDir != null && (javadocFile = javadocsDir.getFileObject(artName, "javadoc")) != null) {
            urls = new ArrayList<URL>();
            url = FileUtil.toFile((FileObject)javadocFile).toURI().toURL();
            url = FileUtil.getArchiveRoot((URL)url);
            urls.add(url);
            logger.debug((Object)("javadoc url=" + url));
            library.setContent("javadoc", urls);
        }
        if (srcsDir != null && (srcFile = srcsDir.getFileObject(artName, "src")) != null) {
            urls = new ArrayList();
            url = FileUtil.toFile((FileObject)srcFile).toURI().toURL();
            url = FileUtil.getArchiveRoot((URL)url);
            urls.add(url);
            logger.debug((Object)("src url=" + url));
            library.setContent("src", urls);
        }
    }
}

