/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.Action;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;

class PluginScriptNode
extends AbstractNode {
    private static Action[] actions;

    PluginScriptNode(FileObject rootFolder) {
        super((Children)new PluginScriptChildren(rootFolder));
        this.setName("PluginScript");
        this.setDisplayName("Plugin Script");
        this.setIconBase("org/netbeans/modules/java/j2seproject/ui/resources/packageRoot");
    }

    public Action[] getActions(boolean context) {
        if (actions == null) {
            actions = new Action[0];
        }
        return actions;
    }

    private static class PluginScriptChildren
    extends Children.Keys
    implements PropertyChangeListener,
    FileChangeListener {
        private static final Object KEY_PLUGIN_SCRIPT = "PluginScript";
        private static final Object KEY_PLUGIN_PROPS = "PluginProps";
        private FileObject fileObject;
        private DataObject pluginDO;
        private DataObject propsDO;

        PluginScriptChildren(FileObject rootFolder) {
            this.fileObject = rootFolder;
            this.fileObject.addFileChangeListener(WeakListener.fileChange((FileChangeListener)this, (Object)this.fileObject));
        }

        public void addNotify() {
            super.addNotify();
            this.setKeys(new Object[]{KEY_PLUGIN_SCRIPT, KEY_PLUGIN_PROPS});
            this.pluginDO = this.findDO("jelly");
            this.propsDO = this.findDO("properties");
            if (this.pluginDO != null) {
                this.pluginDO.addPropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.propsDO != null) {
                this.propsDO.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
            super.removeNotify();
            if (this.propsDO != null) {
                this.propsDO.removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.pluginDO != null) {
                this.pluginDO.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        protected Node[] createNodes(Object obj) {
            if (obj == KEY_PLUGIN_SCRIPT && this.pluginDO != null && this.pluginDO.isValid()) {
                return new Node[]{this.pluginDO.getNodeDelegate().cloneNode()};
            }
            if (obj == KEY_PLUGIN_PROPS && this.propsDO != null && this.propsDO.isValid()) {
                return new Node[]{this.propsDO.getNodeDelegate().cloneNode()};
            }
            return new Node[0];
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("valid".equals(evt.getPropertyName())) {
                if (evt.getSource() == this.pluginDO) {
                    if (this.pluginDO != null) {
                        this.pluginDO.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.pluginDO = this.findDO("jelly");
                    if (this.pluginDO != null) {
                        this.pluginDO.addPropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.refreshKey(KEY_PLUGIN_SCRIPT);
                }
                if (evt.getSource() == this.propsDO) {
                    if (this.propsDO != null) {
                        this.propsDO.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.propsDO = this.findDO("properties");
                    if (this.propsDO != null) {
                        this.propsDO.addPropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.refreshKey(KEY_PLUGIN_PROPS);
                }
            }
        }

        private DataObject findDO(String extension) {
            FileObject fo = this.fileObject.getFileObject("plugin", extension);
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException exc) {
                // empty catch block
            }
            return dobj;
        }

        private void doFileUpdates() {
            DataObject findDO;
            if (this.pluginDO != null != ((findDO = this.findDO("jelly")) != null)) {
                if (this.pluginDO != null) {
                    this.pluginDO.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.pluginDO = findDO;
                if (this.pluginDO != null) {
                    this.pluginDO.addPropertyChangeListener((PropertyChangeListener)this);
                }
                this.refreshKey(KEY_PLUGIN_SCRIPT);
            }
            if (this.propsDO != null != ((findDO = this.findDO("properties")) != null)) {
                if (this.propsDO != null) {
                    this.propsDO.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.propsDO = findDO;
                if (this.propsDO != null) {
                    this.propsDO.addPropertyChangeListener((PropertyChangeListener)this);
                }
                this.refreshKey(KEY_PLUGIN_PROPS);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.doFileUpdates();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.doFileUpdates();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.doFileUpdates();
        }
    }
}

