/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.MavenSourcesImpl;
import org.mevenide.netbeans.project.nodes.ResourceFilterNode;
import org.mevenide.netbeans.project.nodes.ShowAllResourcesAction;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

class ResourcesRootChildren
extends Children.Keys {
    private static Log logger = LogFactory.getLog((Class)ResourcesRootChildren.class);
    private MavenProject project;
    private PropertyChangeListener changeListener;
    private boolean test;

    public ResourcesRootChildren(MavenProject prj, boolean testResource) {
        this.project = prj;
        this.test = testResource;
        this.changeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    ResourcesRootChildren.this.regenerateKeys();
                    ResourcesRootChildren.this.refresh();
                }
            }
        };
    }

    protected void addNotify() {
        super.addNotify();
        this.project.addPropertyChangeListener(this.changeListener);
        this.regenerateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.project.removePropertyChangeListener(this.changeListener);
        super.removeNotify();
    }

    private void regenerateKeys() {
        ArrayList<SourceGroup> list = new ArrayList<SourceGroup>();
        Sources srcs = (Sources)this.project.getLookup().lookup(Sources.class);
        if (srcs == null) {
            throw new IllegalStateException("need Sources instance in lookup");
        }
        SourceGroup[] resgroup = srcs.getSourceGroups(this.test ? "TestResources" : "Resources");
        for (int i = 0; i < resgroup.length; ++i) {
            list.add(resgroup[i]);
        }
        this.setKeys(list);
    }

    protected Node[] createNodes(Object key) {
        MavenSourcesImpl.ResourceGroup grp = (MavenSourcesImpl.ResourceGroup)key;
        Node[] toReturn = new Node[1];
        try {
            DataObject dobj = DataObject.find((FileObject)grp.getRootFolder());
            Node original = dobj.getNodeDelegate().cloneNode();
            toReturn[0] = new MyFilterNode(original, new ResourceFilterNode.ResFilterChildren(original, grp.getRootFolderFile(), grp.getResource()), grp);
        }
        catch (DataObjectNotFoundException exc) {
            toReturn = new Node[]{};
        }
        return toReturn;
    }

    private class MyFilterNode
    extends FilterNode {
        private MavenSourcesImpl.ResourceGroup group;

        MyFilterNode(Node original, FilterNode.Children children, MavenSourcesImpl.ResourceGroup grp) {
            super(original, (Children)children);
            this.group = grp;
        }

        public String getDisplayName() {
            String toReturn = this.group.getResource().getDirectory();
            return toReturn;
        }

        public String getHtmlDisplayName() {
            String toReturn = this.getDisplayName();
            if (this.group.getResource().getTargetPath() != null) {
                toReturn = toReturn + " -> <I>" + this.group.getResource().getTargetPath() + "</I>";
            }
            return toReturn;
        }

        public Image getIcon(int param) {
            Image retValue = super.getIcon(param);
            retValue = Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/resourceBadge.gif"), (int)8, (int)8);
            return retValue;
        }

        public Image getOpenedIcon(int param) {
            Image retValue = super.getOpenedIcon(param);
            retValue = Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/resourceBadge.gif"), (int)8, (int)8);
            return retValue;
        }

        public Action[] getActions(boolean context) {
            List<Action> supers = Arrays.asList(super.getActions(context));
            ArrayList<Action> lst = new ArrayList<Action>(supers.size() + 5);
            lst.add(ShowAllResourcesAction.getInstance());
            lst.add(null);
            lst.addAll(supers);
            Action[] retValue = new Action[lst.size()];
            retValue = lst.toArray(retValue);
            return retValue;
        }
    }
}

