/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.output;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.output.AbstractOutputProcessor;
import org.mevenide.netbeans.api.output.OutputVisitor;
import org.mevenide.netbeans.project.MavenProject;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class AnnouncementOutputListenerProvider
extends AbstractOutputProcessor {
    private static final Log logger = LogFactory.getLog((Class)AnnouncementOutputListenerProvider.class);
    private static final String[] ANNOUNCEGOALS = new String[]{"announcement:generate:", "announcement:generate-all:"};
    private Pattern pattern = Pattern.compile(".*\\[echo\\] Generating announcement for .* in (.*)\\.\\.\\.");
    private MavenProject project;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

    public AnnouncementOutputListenerProvider(MavenProject proj) {
        this.project = proj;
    }

    public String[] getWatchedGoals() {
        return ANNOUNCEGOALS;
    }

    public void processLine(String line, OutputVisitor visitor) {
        Matcher match;
        if (this.isInWatchedGoals(line) && (match = this.pattern.matcher(line)).matches()) {
            String file = match.group(1);
            visitor.setOutputListener(new AnnOutputListener(this.project, file));
        }
    }

    private static class AnnOutputListener
    implements OutputListener {
        private MavenProject project;
        private File file;

        public AnnOutputListener(MavenProject proj, String fileStr) {
            this.file = new File(fileStr);
            this.project = proj;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            FileObject fo = FileUtil.toFileObject((File)this.file);
            if (fo == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)fo);
                OpenCookie ed = (OpenCookie)dob.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = AnnouncementOutputListenerProvider.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                if (ed != null) {
                    ed.open();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (DataObjectNotFoundException donfe) {
                logger.warn((Object)"DO not found.", (Throwable)donfe);
            }
            catch (IOException ioe) {
                logger.warn((Object)ioe);
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }
}

