/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.output;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mevenide.reports.PmdResult;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class PmdAnnotation
extends Annotation
implements PropertyChangeListener,
OutputListener {
    private static final Set hyperlinks = new WeakSet();
    private boolean dead = false;
    private final PmdResult.Violation violation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachAllAnnotations() {
        Set set = hyperlinks;
        synchronized (set) {
            Iterator it = hyperlinks.iterator();
            while (it.hasNext()) {
                ((PmdAnnotation)it.next()).destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PmdAnnotation(PmdResult.Violation viol) {
        this.violation = viol;
        Set set = hyperlinks;
        synchronized (set) {
            hyperlinks.add(this);
        }
    }

    public void outputLineSelected(OutputEvent ev) {
    }

    public void outputLineAction(OutputEvent ev) {
        FileObject fo = FileUtil.toFileObject((File)this.violation.getFile());
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            EditorCookie cook = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (cook != null) {
                Line l;
                cook.open();
                PmdAnnotation.attachAllInFile(cook, this);
                int lineInt = Integer.parseInt(this.violation.getLine());
                if (lineInt != -1 && !(l = cook.getLineSet().getOriginal(lineInt - 1)).isDeleted()) {
                    l.show(2);
                }
            }
        }
        catch (DataObjectNotFoundException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
        }
    }

    PmdResult.Violation getViolation() {
        return this.violation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void attachAllInFile(EditorCookie cook, PmdAnnotation annot) {
        HashSet newSet = null;
        Set set = hyperlinks;
        synchronized (set) {
            newSet = new HashSet(hyperlinks);
        }
        Iterator it = newSet.iterator();
        while (it.hasNext()) {
            Line l;
            int lineInt;
            PmdAnnotation ann = (PmdAnnotation)it.next();
            PmdResult.Violation violation = ann.getViolation();
            if (!violation.getFile().equals(annot.getViolation().getFile()) || (lineInt = Integer.parseInt(violation.getLine())) == -1 || (l = cook.getLineSet().getOriginal(lineInt - 1)).isDeleted()) continue;
            ann.attachAsNeeded(l);
        }
    }

    public void outputLineCleared(OutputEvent ev) {
        this.doDetach();
    }

    void destroy() {
        this.doDetach();
        this.dead = true;
    }

    private synchronized void attachAsNeeded(Line l) {
        if (this.getAttachedAnnotatable() == null) {
            Line ann = l;
            this.attach((Annotatable)ann);
            ann.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doDetach() {
        Annotatable ann = this.getAttachedAnnotatable();
        if (ann != null) {
            ann.removePropertyChangeListener((PropertyChangeListener)this);
            this.detach();
        }
        Set set = hyperlinks;
        synchronized (set) {
            hyperlinks.remove(this);
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (this.dead) {
            return;
        }
        String prop = ev.getPropertyName();
        if (prop == null || prop.equals("text") || prop.equals("deleted")) {
            this.doDetach();
        }
    }

    public String getAnnotationType() {
        return "org-mevenide-netbeans-project-pmd";
    }

    public String getShortDescription() {
        return this.violation.getViolationText();
    }

    public String toString() {
        return "pmd[" + this.violation.getViolationId() + ":" + this.violation.getLine() + "]";
    }
}

