/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.output;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.output.AbstractOutputProcessor;
import org.mevenide.netbeans.api.output.OutputVisitor;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.output.PmdAnnotation;
import org.mevenide.reports.PmdResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class PmdOutputListenerProvider
extends AbstractOutputProcessor {
    private static final Log logger = LogFactory.getLog((Class)PmdOutputListenerProvider.class);
    private static final String[] PMDGOALS = new String[]{"pmd:report:"};
    private Pattern failPattern = Pattern.compile("pmd\\:report\\:");
    private MavenProject project;

    public PmdOutputListenerProvider(MavenProject proj) {
        this.project = proj;
    }

    public String[] getWatchedGoals() {
        return PMDGOALS;
    }

    public void processLine(String line, OutputVisitor visitor) {
        Matcher match;
        if (this.isInWatchedGoals(line) && (match = this.failPattern.matcher(line)).matches()) {
            visitor.setOutputListener(new PmdOutputListener(this.project));
        }
    }

    private static class PmdOutputListener
    implements OutputListener {
        private MavenProject project;

        public PmdOutputListener(MavenProject proj) {
            this.project = proj;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            this.openReport();
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openReport() {
            PmdResult result = new PmdResult(this.project.getContext());
            String title = "PMD: " + this.project.getDisplayName();
            try {
                IOProvider.getDefault().getIO(title, false).getOut().reset();
            }
            catch (Exception exc) {
                logger.error((Object)"Exception while resetting output", (Throwable)exc);
            }
            InputOutput io = IOProvider.getDefault().getIO(title, false);
            io.select();
            OutputWriter writer = io.getOut();
            try {
                File[] files = result.getFiles();
                File srcRoot = new File(this.project.getSrcDirectory());
                FileObject rootFo = FileUtil.toFileObject((File)srcRoot);
                if (files.length == 0) {
                    writer.println("No files matched the defined pmd rules.");
                } else {
                    writer.println("Number of matched files: " + files.length);
                    writer.println(" ");
                }
                for (int i = 0; i < files.length; ++i) {
                    FileObject file = FileUtil.toFileObject((File)files[i]);
                    String relative = FileUtil.getRelativePath((FileObject)rootFo, (FileObject)file);
                    relative = relative == null ? files[i].toString() : relative.replace('\\', '/').replace('/', '.');
                    writer.println(relative);
                    List viols = result.getViolationsForFile(files[i]);
                    Iterator it = viols.iterator();
                    while (it.hasNext()) {
                        PmdResult.Violation v = (PmdResult.Violation)it.next();
                        PmdAnnotation list = new PmdAnnotation(v);
                        writer.println("   Line:" + v.getLine() + " " + v.getViolationText().trim(), (OutputListener)list);
                    }
                    writer.println(" ");
                }
            }
            catch (IOException exc) {
                logger.error((Object)"Exception while writing output", (Throwable)exc);
            }
            finally {
                writer.close();
            }
        }
    }
}

