/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.output;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.output.AbstractOutputProcessor;
import org.mevenide.netbeans.api.output.OutputProcessor;
import org.mevenide.netbeans.api.output.OutputVisitor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileUtil;

public class ViewInBrowseProcessor
extends AbstractOutputProcessor
implements OutputProcessor {
    private static final Log logger = LogFactory.getLog((Class)ViewInBrowseProcessor.class);
    private String[] goalsToWatch;
    private File file;
    private String questionMessage;
    private int priority;

    public ViewInBrowseProcessor(String[] goals, File fileToOpen, String question, int prior) {
        this.goalsToWatch = goals;
        this.file = fileToOpen;
        this.questionMessage = question;
        this.priority = prior;
    }

    public void processLine(String line, OutputVisitor visitor) {
        if (this.isWatchedGoalLine(line)) {
            visitor.setSuccessAction(new ViewAction());
        }
    }

    public String[] getWatchedGoals() {
        return this.goalsToWatch;
    }

    private class ViewAction
    extends AbstractAction {
        public ViewAction() {
            this.putValue("Question", ViewInBrowseProcessor.this.questionMessage);
            this.putValue("Priority", new Integer(ViewInBrowseProcessor.this.priority));
        }

        public void actionPerformed(ActionEvent event) {
            File fil = FileUtil.normalizeFile((File)ViewInBrowseProcessor.this.file);
            if (fil.exists()) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(fil.toURI().toURL());
                }
                catch (MalformedURLException exc) {
                    logger.error((Object)exc);
                }
            }
        }
    }
}

